/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.notify;

import com.huawei.network.qasn.m_q_interface_op.QAsnCreatePortInfoRpt;
import com.huawei.network.qasn.m_q_interface_op.QAsnDeletePortInfoRpt;
import com.huawei.network.qasn.m_q_interface_op.QAsnPortDetailInfoChgRpt;
import com.huawei.network.qasn.m_q_interface_op.QAsnPortMemberChgRpt;
import com.huawei.network.qasn.m_q_interface_op.QAsnPortStatusChgRpt;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnCreateCTPInfoRpt;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnDeleteCTPInfoRpt;
import com.huawei.network.qasn.m_q_ip_ctp_op.QAsnModifyCTPInfoRpt;
import com.huawei.network.qasn.m_q_ip_link_op.QAsnIPInterfaceChangeRpt;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.ifm.task.IQAsnGetPortDetailInfoTaskExtPoint;
import com.huawei.vmf.adapter.framework.notify.AbstractMOChangeListener;
import com.huawei.vmf.adapter.framework.syncdata.INEUploadHandler;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmInterface;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvc;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvp;
import com.huawei.vmf.adapter.fservice.ifm.model.ChannelSet;
import com.huawei.vmf.adapter.fservice.ifm.model.CposChannel;
import com.huawei.vmf.adapter.fservice.ifm.model.CposPort;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1Port;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.FlowDot1q;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv6Address;
import com.huawei.vmf.adapter.fservice.ifm.model.PosPort;
import com.huawei.vmf.adapter.fservice.ifm.model.QinqMapping;
import com.huawei.vmf.adapter.fservice.ifm.model.QinqTerminate;
import com.huawei.vmf.adapter.fservice.ifm.model.StmChannel;
import com.huawei.vmf.adapter.fservice.ifm.model.StmPort;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkMemberIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Vc12;
import com.huawei.vmf.adapter.fservice.ifm.model.Vc4;
import com.huawei.vmf.adapter.fservice.ifm.service.IPortLicenseService;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.sync.model.DataSyncSNNode;
import com.huawei.vmf.adapter.ifm.Activator;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.notify.AbstractQAsnRptNotify;
import com.huawei.vmf.adapter.ifm.notify.ChangeRecordPreProcess;
import com.huawei.vmf.adapter.ifm.notify.IChangeRecordPreProcess;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class InterfaceChangeListener
extends AbstractMOChangeListener
implements INEUploadHandler {
    private static final Logger logger = LoggerFactory.getLogger(InterfaceChangeListener.class);
    private static Collection<Class<? extends VmfMO>> MOTYPES = new ArrayList<Class<? extends VmfMO>>();
    private static final String NOTIFY_PCK_NAME = "com.huawei.vmf.adapter.ifm.notify";
    private IChangeRecordPreProcess changeRecordPreProcess = new ChangeRecordPreProcess(MOTYPES);
    private Collection<Class<?>> qasnRptClazzs = new ArrayList();

    public InterfaceChangeListener() {
        this.registerRpt();
    }

    public Collection<Class<? extends VmfMO>> getTrackMoType() {
        return MOTYPES;
    }

    public void handleChanges(Context context) throws VMFException {
        logger.info("start InterfaceChangeListener.");
        this.handlePortLic(context);
        this.handleQAsnRptNotify(context);
        logger.info("end InterfaceChangeListener.");
    }

    public void neUploadNotify(DataSyncSNNode dataSyncSNNode, Context context) {
        try {
            this.prepareChangeRecord(context);
            this.handlePortLic(context);
        }
        catch (VMFException e) {
            logger.error("neUploadNotify error.", (Throwable)e);
        }
    }

    public void prepareChangeRecord(Context context) {
        this.changeRecordPreProcess.preProcessChangeRecorde(context);
        super.prepareChangeRecord(context);
    }

    private void handlePortLic(Context context) throws VMFException {
        Object extendPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnGetPortDetailInfoTaskExtPoint.class);
        if (null != extendPoint) {
            return;
        }
        Set createMos = context.getChangeRecord(Interface.class).getCreates();
        Set delMos = context.getChangeRecord(Interface.class).getDeletes();
        if (CollectionUtils.isEmpty((Collection)createMos) && CollectionUtils.isEmpty((Collection)delMos)) {
            return;
        }
        IPortLicenseService portLicenseService = Activator.getService(IPortLicenseService.class);
        portLicenseService.applyPortLic((Collection)createMos, 1);
        portLicenseService.applyPortLic((Collection)delMos, -1);
    }

    private void handleQAsnRptNotify(Context context) throws VMFException {
        String notifyClassName = "";
        try {
            for (Class<?> qasnRptClazz : this.qasnRptClazzs) {
                notifyClassName = "com.huawei.vmf.adapter.ifm.notify." + qasnRptClazz.getSimpleName() + "Notify";
                Class<?> notifyClazz = Class.forName(notifyClassName);
                Constructor<?> cs = notifyClazz.getDeclaredConstructor(new Class[0]);
                cs.setAccessible(true);
                ((AbstractQAsnRptNotify)cs.newInstance(new Object[0])).handleChanges(context);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("can't get qasnRpt class. notifyClassName=" + notifyClassName, (Throwable)e);
            throw new VMFException(1107498880, "can't get qasnRpt class. className=" + notifyClassName, (Throwable)e);
        }
        catch (Exception e) {
            logger.error("New instance error. notifyClassName=" + notifyClassName, (Throwable)e);
            throw new VMFException(1107498880, "New instance error. notifyClassName=" + notifyClassName, (Throwable)e);
        }
    }

    private void registerRpt() {
        this.qasnRptClazzs.add(QAsnDeletePortInfoRpt.class);
        this.qasnRptClazzs.add(QAsnDeleteCTPInfoRpt.class);
        this.qasnRptClazzs.add(QAsnCreatePortInfoRpt.class);
        this.qasnRptClazzs.add(QAsnCreateCTPInfoRpt.class);
        this.qasnRptClazzs.add(QAsnPortStatusChgRpt.class);
        this.qasnRptClazzs.add(QAsnPortDetailInfoChgRpt.class);
        this.qasnRptClazzs.add(QAsnIPInterfaceChangeRpt.class);
        this.qasnRptClazzs.add(QAsnPortMemberChgRpt.class);
        this.qasnRptClazzs.add(QAsnModifyCTPInfoRpt.class);
    }

    static {
        MOTYPES.add(Interface.class);
        MOTYPES.add(Ipv4Address.class);
        MOTYPES.add(Ipv6Address.class);
        MOTYPES.add(TrunkIf.class);
        MOTYPES.add(TrunkMemberIf.class);
        MOTYPES.add(EthSubIf.class);
        MOTYPES.add(FlowDot1q.class);
        MOTYPES.add(QinqTerminate.class);
        MOTYPES.add(QinqMapping.class);
        MOTYPES.add(AtmInterface.class);
        MOTYPES.add(AtmPvc.class);
        MOTYPES.add(AtmPvp.class);
        MOTYPES.add(EthernetPort.class);
        MOTYPES.add(PosPort.class);
        MOTYPES.add(CposPort.class);
        MOTYPES.add(E1t1.class);
        MOTYPES.add(CposChannel.class);
        MOTYPES.add(E1t1Port.class);
        MOTYPES.add(ChannelSet.class);
        if (InterfaceUtil.isHasStmPortExtPoint()) {
            MOTYPES.add(StmPort.class);
            MOTYPES.add(Vc4.class);
            MOTYPES.add(Vc12.class);
            MOTYPES.add(StmChannel.class);
        } else {
            MOTYPES.add(CposPort.class);
        }
    }
}

