/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.notify;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IRelationMeta;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmInterface;
import com.huawei.vmf.adapter.fservice.ifm.model.CposPort;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1Port;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.PosPort;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.dao.InterfaceDao;
import com.huawei.vmf.adapter.ifm.notify.IChangeRecordPreProcess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ChangeRecordPreProcess
implements IChangeRecordPreProcess {
    private static final Logger logger = LoggerFactory.getLogger(ChangeRecordPreProcess.class);
    private Collection<Class<? extends VmfMO>> clazzs = new ArrayList<Class<? extends VmfMO>>();
    private Collection<Class<? extends VmfMO>> keyrefClazzs = Arrays.asList(TrunkIf.class, EthSubIf.class, AtmInterface.class, EthernetPort.class, PosPort.class, CposPort.class, E1t1Port.class);

    public ChangeRecordPreProcess(Collection<Class<? extends VmfMO>> clazzs) {
        this.clazzs = clazzs;
    }

    @Override
    public void preProcessChangeRecorde(Context context) {
        try {
            this.processDeleteRecord(context);
            this.processModifyRecord(context);
            this.processCreateRecord(context);
        }
        catch (VMFException e) {
            logger.error("preProcessChangeRecode error.", (Throwable)e);
        }
    }

    private <P, C> void addChildMosToParent(Class<P> parentClazz, Class<C> childClazz, Context context, EOperationType operationType) throws VMFException {
        Collection childs = this.getRecordMos(childClazz, context, operationType);
        if (CollectionUtils.isEmpty((Collection)childs)) {
            return;
        }
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        IRelationMeta parentRelationMeta = dao.getRelationMeta(parentClazz);
        HashMap<Object, Collection> parentMapping = new HashMap<Object, Collection>();
        for (Object child : childs) {
            Collection value;
            Object parentKey = parentRelationMeta.newInstance(parentClazz);
            this.setParentKeyByChildKey(parentClazz, (VmfMO)parentKey, childClazz, (VmfMO)child);
            if (parentKey instanceof Interface) {
                if (null == ((Interface)parentKey).getIfName()) continue;
                logger.info("this happened...");
            }
            if (!parentMapping.containsKey(parentKey)) {
                parentMapping.put(parentKey, new ArrayList());
            }
            if ((value = (Collection)parentMapping.get(parentKey)) != null) {
                value.add(child);
            }
            this.addParentRecord(parentClazz, parentKey, childClazz, context, operationType);
        }
        this.setRelationship(parentClazz, this.getRecordMos(parentClazz, context, operationType), childClazz, childs, parentMapping);
    }

    private void addCreateMoToModifyRecord(Class<? extends VmfMO> clazz, IMOChangeRecord<VmfMO> changeRecord) {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        Set creates = changeRecord.getCreates();
        Collection propertyNames = dao.getPersistentProperties(clazz);
        for (VmfMO createMo : creates) {
            Object[] propertyValues = dao.getPropertyValues(createMo);
            Iterator it = propertyNames.iterator();
            for (int i = 0; i < propertyValues.length && it.hasNext(); ++i) {
                String propertyName = (String)it.next();
                if (null == propertyValues[i]) continue;
                changeRecord.addModify((Object)createMo, new PropertyChangeItem(propertyName));
            }
        }
    }

    private void addCreateMoToModifyRecord(Context context) {
        for (Class<? extends VmfMO> clazz : this.clazzs) {
            IMOChangeRecord changeRecord = context.getChangeRecord(clazz);
            Set creates = changeRecord.getCreates();
            if (CollectionUtils.isEmpty((Collection)creates)) continue;
            this.addCreateMoToModifyRecord(clazz, (IMOChangeRecord<VmfMO>)changeRecord);
        }
    }

    private <P, C> void addParentRecord(Class<P> parentClazz, Object parentMo, Class<C> childClazz, Context context, EOperationType operationType) throws VMFException {
        String propertyName;
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        IMOChangeRecord record = context.getChangeRecord(parentClazz);
        IRelationMeta parentRelationMeta = dao.getRelationMeta(parentClazz);
        Collection parentMos = this.getRecordMos(parentClazz, context, operationType);
        boolean isKeyref = this.isKeyref(parentClazz, childClazz);
        String string = propertyName = isKeyref ? "keyref" : parentRelationMeta.getChildFieldName(childClazz);
        if (!parentMos.contains(parentMo)) {
            if (EOperationType.MODIFY != operationType) {
                record.addCreate(parentMo);
            } else {
                ArrayList<Object> parentKeys = new ArrayList<Object>();
                parentKeys.add(parentMo);
                Collection mos = dao.queryByKey(parentClazz, parentKeys, false);
                if (!CollectionUtils.isEmpty((Collection)mos)) {
                    record.addModify(mos.iterator().next(), new PropertyChangeItem(propertyName));
                }
            }
        }
    }

    private <P> Collection getRecordMos(Class<P> clazz, Context context, EOperationType operationType) {
        IMOChangeRecord record = context.getChangeRecord(clazz);
        Set mos = EOperationType.MODIFY == operationType ? record.getModifies() : record.getCreates();
        return mos;
    }

    private <P, C> boolean isKeyref(Class<P> parentType, Class<C> childType) {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        IRelationMeta relation = dao.getRelationMeta(parentType);
        Collection childTypes = relation.getChildrenType();
        return !childTypes.contains(childType);
    }

    private void processCreateRecord(Context context) throws VMFException {
        this.processDeployStatusChangeRecord(context, EOperationType.CREATE);
        for (Class<? extends VmfMO> keyrefClazz : this.keyrefClazzs) {
            this.addChildMosToParent(Interface.class, keyrefClazz, context, EOperationType.CREATE);
        }
    }

    private void processDeleteRecord(Context context) {
        this.processDeployStatusChangeRecord(context, EOperationType.DELETE);
    }

    private void processDeployStatusChangeRecord(Context context, EOperationType operationType) {
        for (Class<? extends VmfMO> clazz : this.clazzs) {
            IMOChangeRecord changeRecord = context.getChangeRecord(clazz);
            Collection modifies = changeRecord.getPropertyChangedMO(new String[]{"deployStatus"});
            if (CollectionUtils.isEmpty((Collection)modifies)) continue;
            Iterator iterator = modifies.iterator();
            while (iterator.hasNext()) {
                VmfMO modifyMo = (VmfMO)iterator.next();
                if (!(modifyMo instanceof DeployableMO)) continue;
                boolean isDeployed = ((DeployableMO)modifyMo).isDeployed();
                if (EOperationType.DELETE == operationType && !isDeployed) {
                    iterator.remove();
                    changeRecord.addDelete((Object)modifyMo);
                    continue;
                }
                if (EOperationType.CREATE == operationType && isDeployed) {
                    changeRecord.addCreate((Object)modifyMo);
                    continue;
                }
                logger.info("this can not happen.");
            }
        }
    }

    private void processModifyRecord(Context context) throws VMFException {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        this.addCreateMoToModifyRecord(context);
        Class<Interface> interfaceClazz = Interface.class;
        IRelationMeta infRelation = dao.getRelationMeta(interfaceClazz);
        for (Class clazz : infRelation.getChildrenType()) {
            this.addChildMosToParent(interfaceClazz, clazz, context, EOperationType.MODIFY);
        }
        for (Class clazz : this.keyrefClazzs) {
            IRelationMeta keyrefRelation = dao.getRelationMeta(clazz);
            for (Class keyrefChildType : keyrefRelation.getChildrenType()) {
                this.addChildMosToParent(clazz, keyrefChildType, context, EOperationType.MODIFY);
            }
            this.addChildMosToParent(interfaceClazz, clazz, context, EOperationType.MODIFY);
        }
    }

    private <P, C> void setParentKeyByChildKey(Class<P> parentClazz, VmfMO parent, Class<C> childClazz, VmfMO child) {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        boolean isKeyref = this.isKeyref(parentClazz, childClazz);
        IRelationMeta parentRelationMeta = dao.getRelationMeta(parentClazz);
        if (isKeyref) {
            if (parent instanceof Interface) {
                parent.setDevID(child.getDevID());
                parent.setVrID(child.getVrID());
                if (child instanceof TrunkIf) {
                    ((Interface)parent).setIfName(((TrunkIf)child).getIfName());
                } else if (child instanceof EthSubIf) {
                    ((Interface)parent).setIfName(((EthSubIf)child).getIfName());
                } else if (child instanceof Port) {
                    ((Interface)parent).setIfName(((Port)child).getName());
                } else {
                    logger.info("this can not happen.");
                }
            }
        } else {
            parentRelationMeta.setParentKeyByChildKey((Object)parent, (Object)child);
        }
    }

    private <P, C> void setRelationship(Class<P> parentClazz, Collection<P> parents, Class<C> childClazz, Collection<C> childs, Map<Object, Collection> parentMapping) throws VMFException {
        InterfaceDao dao = (InterfaceDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, InterfaceDao.class);
        boolean isKeyref = this.isKeyref(parentClazz, childClazz);
        if (!isKeyref) {
            dao.setRelationship(parentClazz, parents, childClazz, childs);
            return;
        }
        for (P parent : parents) {
            ((VmfMO)parent).addKeyRefMos(parentMapping.get(parent));
        }
    }
}

