/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.notify;

import com.huawei.communicate.core.MSGHead;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.vmf.adapter.common.exception.MdpCommunicationException;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.imap.IMessageSession;
import com.huawei.vmf.adapter.common.imap.MSGCommon;
import com.huawei.vmf.adapter.common.imap.MessageSessionFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.huawei.vmf.adapter.ifm.translation.asn.util.TranslatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractQAsnRptNotify {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQAsnRptNotify.class);
    protected Class<? extends VmfMO> clazz;
    protected FStruct rptAsn;
    protected IAsnTranslator<? extends FStruct, ? extends VmfMO> translator;
    protected InterfaceType interfaceType;
    protected boolean isSendReliableEvent;
    protected int eventId;

    public AbstractQAsnRptNotify(Class<? extends VmfMO> clazz, FStruct rptAsn, IAsnTranslator<? extends FStruct, ? extends VmfMO> translator, InterfaceType interfaceType, int eventId, boolean isSendReliableEvent) {
        this.clazz = clazz;
        this.rptAsn = rptAsn;
        this.translator = translator;
        this.isSendReliableEvent = isSendReliableEvent;
        this.eventId = eventId;
        this.interfaceType = interfaceType;
    }

    public void handleChanges(Context context) throws VMFException {
        AsnTranslationContext translationContext = new AsnTranslationContext();
        translationContext.setTransactionContext(context);
        Collection<VmfMO> changeRecords = this.getChangeRecords(context);
        if (!CollectionUtils.isEmpty(changeRecords)) {
            FStruct resultAsn = this.getResultAsn();
            if (resultAsn instanceof Collection) {
                Collection resultAsns = (Collection)resultAsn;
                resultAsns.addAll(this.getEncondeAsn(context, changeRecords, (IAsnTranslationContext)translationContext));
            }
            this.sendReport();
        }
    }

    protected abstract Collection<VmfMO> getChangeRecords(Context var1) throws VMFException;

    protected Collection<VmfMO> getDelChangeRecords(Class<? extends VmfMO> clazz, Context context) {
        ArrayList<VmfMO> interfaces = new ArrayList<VmfMO>();
        IMOChangeRecord changeRecord = context.getChangeRecord(clazz);
        Set deletes = changeRecord.getDeletes();
        interfaces.addAll(deletes);
        Set modifies = changeRecord.getModifies();
        if (!CollectionUtils.isEmpty((Collection)modifies)) {
            for (VmfMO modifyMo : modifies) {
                if (((DeployableMO)modifyMo).isDeployed()) continue;
                interfaces.add(modifyMo);
            }
        }
        return interfaces;
    }

    protected abstract FStruct getResultAsn();

    protected Collection<FStruct> getEncondeAsn(Context context, Collection<VmfMO> changeRecords, IAsnTranslationContext translationContext) throws VMFException {
        return this.translator.encode(changeRecords, translationContext);
    }

    protected Collection<FStruct> encodeUniResIDs(Collection<VmfMO> mos) {
        ArrayList<FStruct> encondeAsns = new ArrayList<FStruct>();
        for (VmfMO mo : mos) {
            QAsnUniResID uid = new QAsnUniResID();
            TranslatorUtil.encodePortUniResID((Interface)mo, uid);
            encondeAsns.add((FStruct)uid);
        }
        return encondeAsns;
    }

    protected Collection<VmfMO> filteMos(Collection<VmfMO> mos) {
        if (InterfaceType.BOTH == this.interfaceType) {
            return mos;
        }
        boolean isMainIf = InterfaceType.MAIN_IF == this.interfaceType;
        ArrayList<VmfMO> filteMos = new ArrayList<VmfMO>();
        for (VmfMO mo : mos) {
            if (isMainIf != InterfaceUtil.isMainInterface(((Interface)mo).getIfName())) continue;
            filteMos.add(mo);
        }
        return filteMos;
    }

    protected void sendReport() {
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            if (this.isSendReliableEvent) {
                session.sendReliableEvent(this.eventId, this.rptAsn);
                logger.info("sendReliableEvent:" + this.rptAsn.getClass().getName());
            } else {
                session.sendNoReliableEvent(this.eventId, this.rptAsn);
                logger.info("sendNoReliableEvent:" + this.rptAsn.getClass().getName());
            }
        }
        catch (VMFException e) {
            logger.error("sendReliableEvent error. rpt= " + this.rptAsn, (Throwable)e);
        }
    }

    protected Class getClazz() {
        return this.clazz;
    }

    protected void sendNotification(FStruct rpt, char procID, byte taskmgr, int cmd) {
        MSGHead head = MSGCommon.getMSGHead((char)procID, (byte)taskmgr, (int)cmd);
        try {
            MessageSessionFactory.getSession().sendNotification(head, rpt);
        }
        catch (MdpCommunicationException e) {
            logger.error("send notification error. head=" + head + ", rpt=" + rpt, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error("send notification error, May can not get MDP proxy servcie. head=" + head + ", rpt=" + rpt, (Throwable)e);
        }
    }

    protected static enum InterfaceType {
        MAIN_IF(0),
        SUB_IF(1),
        BOTH(2);

        private int type;

        private InterfaceType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

