/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.uflight.VMFResourceManger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.trapadmin.AbstractFaultListener;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.ifm.common.InterfaceUtil;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkFault
extends AbstractFaultListener {
    private static final Logger logger = LoggerFactory.getLogger(LinkFault.class);
    private List<Integer> alarms = new ArrayList<Integer>();

    public LinkFault() {
        this.alarms.add(3);
        this.alarms.add(4);
        this.alarms.add(3074752);
        this.alarms.add(2505274);
        this.alarms.add(1101787);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(List<AsnForwardFaultRptStrc> alarms) {
        boolean bisSuccess = false;
        Context context = new Context(true);
        try {
            this.refreshInterfaceStatus(alarms, context);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(context);
            dao.merge(Interface.class, false);
            context.commit();
            bisSuccess = true;
            MOChangePublisher.getInstance().notifyAlarmChanges(context);
        }
        catch (VMFException e) {
            logger.error("Error while notifyInterfaceStatChange. ", (Throwable)e);
        }
        finally {
            if (!bisSuccess) {
                context.rollback();
            }
            context.endTransaction();
        }
    }

    protected Class<?> getEffectedMOType() {
        return Interface.class;
    }

    protected void refreshInterfaceStatus(List<AsnForwardFaultRptStrc> alarms, Context context) {
        HashMap<String, Interface> interfaces = new HashMap<String, Interface>();
        HashSet<Interface> needLoadFromDevice = new HashSet<Interface>();
        for (AsnForwardFaultRptStrc cfgTrap : alarms) {
            String fdn = StringUtil.globalString((byte[])cfgTrap.strFdn);
            Interface inf = (Interface)interfaces.get(fdn);
            if (inf == null) {
                inf = this.getInterfaceKey(fdn);
                interfaces.put(fdn, inf);
            }
            int faultId = cfgTrap.sFaultID.intValue();
            int faultFlag = cfgTrap.cFaultFlag.intValue();
            if (faultFlag == 2) {
                String endUser = VMFResourceManger.getResString((String)"ALARM_END_USER");
                if (cfgTrap.strEndUserName != null && !StringUtil.globalString((byte[])cfgTrap.strEndUserName).contains(endUser)) {
                    needLoadFromDevice.add(inf);
                    continue;
                }
                inf.setIfAdminStatus(Interface.IF_ADMIN_STATUS_ENUM.UP);
                inf.setIfOperStatus(Interface.IF_OPER_STATUS_ENUM.UP);
                needLoadFromDevice.remove(inf);
                logger.info("auto recover interface status:{}", (Object)inf);
                continue;
            }
            if (this.alarms.contains(faultId)) {
                String detail = StringUtil.globalString((byte[])cfgTrap.strDetail);
                String[] params = (detail = detail.toLowerCase(Locale.getDefault())).split("=");
                Integer adminStat = params[1].startsWith("up") ? Interface.IF_ADMIN_STATUS_ENUM.UP : Interface.IF_ADMIN_STATUS_ENUM.DOWN;
                Integer operStat = params[2].startsWith("up") ? Interface.IF_OPER_STATUS_ENUM.UP : Interface.IF_OPER_STATUS_ENUM.DOWN;
                inf.setIfAdminStatus(adminStat);
                inf.setIfOperStatus(operStat);
                needLoadFromDevice.remove(inf);
                logger.info("link down interface status:{}", (Object)inf);
                continue;
            }
            logger.info("this can not happen.");
        }
        this.refreshInterfaceStatusFromDevice(needLoadFromDevice);
        IMOChangeRecord record = context.addChangeRecord(Interface.class);
        for (Map.Entry entry : interfaces.entrySet()) {
            record.addModify(entry.getValue(), new PropertyChangeItem("ifAdminStatus"));
            record.addModify(entry.getValue(), new PropertyChangeItem("ifOperStatus"));
        }
    }

    private Interface getInterfaceKey(String fdn) {
        Interface inf = InterfaceUtil.getIndexByFdn(fdn);
        inf.setFdn(fdn);
        return inf;
    }

    private void refreshInterfaceStatusFromDevice(Set<Interface> needLoadFromDevice) {
    }
}

