/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.dao;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.SerialResIDParser;
import com.huawei.vmf.adapter.common.fdn.SubInterfaceResIDParser;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IPortTranslatorFunctionExtPoint;
import com.huawei.vmf.adapter.framework.dao.CompareOperator;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.DefaultDao;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.dao.RelationMetaMgr;
import com.huawei.vmf.adapter.framework.dao.SQLHelper;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ethoam.model.EfmInterface;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.EthSubIf;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetIf;
import com.huawei.vmf.adapter.fservice.ifm.model.EthernetPort;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.ifm.view.InterfaceAndIpAddress;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.OpticalInfo;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TeLink;
import com.huawei.vmf.adapter.ifm.sap.QAsnGetSap;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class InterfaceDao
extends DefaultDao {
    private Logger logger = LoggerFactory.getLogger(InterfaceDao.class);
    private String BANK = "_";
    private String SUBIF = "SUBIF";
    private InterfaceFdnParser interfaceFdnFarser = new InterfaceFdnParser();

    protected InterfaceDao(SessionFactory sf, RelationMetaMgr relationMgr) {
        super(sf, relationMgr);
    }

    public static List<Integer> getDevIDListByFDN(QAsnUniResIDList lst) {
        ArrayList<Integer> devIDs = new ArrayList<Integer>();
        for (QAsnUniResID asnUniResID : lst) {
            if (!"NE".equals(StringUtil.globalString((byte[])asnUniResID.strMOC))) continue;
            devIDs.add(asnUniResID.neID);
        }
        return devIDs;
    }

    public void getBoardInfo(Collection<Interface> interfaces, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(interfaces)) {
            return;
        }
        HashMap<String, Board> boardMap = new HashMap<String, Board>();
        HashMap<String, SubCard> subCardMap = new HashMap<String, SubCard>();
        HashMap<String, Interface> ifmMap = new HashMap<String, Interface>();
        for (Interface mo : interfaces) {
            SerialResIDParser serialParser;
            PortUniResIDParser physicalParser;
            if (null == mo.getIfName()) continue;
            int type = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
            Board board = new Board();
            SubCard subCard = new SubCard();
            if (U2KInterfaceTypeMapping.getPhysicalInterfaceType().contains(type)) {
                PortUniResIDParser physicalParser2 = new PortUniResIDParser(mo.getDevID().intValue(), mo.getIfName());
                board.setDevID(Integer.valueOf(physicalParser2.getDevID()));
                board.setVrID(mo.getVrID());
                board.setChassisID(Integer.valueOf(physicalParser2.getFrameID()));
                board.setSlotID(Integer.valueOf(physicalParser2.getSlotID()));
                boardMap.put(mo.getDevID() + this.BANK + mo.getIfName(), board);
                subCard.setDevID(Integer.valueOf(physicalParser2.getDevID()));
                subCard.setVrID(mo.getVrID());
                subCard.setChassisID(Integer.valueOf(physicalParser2.getFrameID()));
                subCard.setSlotID(Integer.valueOf(physicalParser2.getSlotID()));
                subCard.setSubSlotID(physicalParser2.getSubSlotID());
                subCardMap.put(mo.getDevID() + this.BANK + mo.getIfName(), subCard);
                ifmMap.put(mo.getDevID() + this.BANK + mo.getIfName(), mo);
                continue;
            }
            if (65559 == type) {
                SubInterfaceResIDParser subIfmParser = new SubInterfaceResIDParser(mo.getDevID().intValue(), mo.getVrID().intValue(), mo.getIfName());
                if (null == subIfmParser.getPpUniResParser()) continue;
                physicalParser = subIfmParser.getPpUniResParser();
                board.setDevID(Integer.valueOf(physicalParser.getDevID()));
                board.setVrID(mo.getVrID());
                board.setChassisID(Integer.valueOf(physicalParser.getFrameID()));
                board.setSlotID(Integer.valueOf(physicalParser.getSlotID()));
                boardMap.put(mo.getDevID() + this.BANK + mo.getIfName(), board);
                subCard.setDevID(Integer.valueOf(physicalParser.getDevID()));
                subCard.setVrID(mo.getVrID());
                subCard.setChassisID(Integer.valueOf(physicalParser.getFrameID()));
                subCard.setSlotID(Integer.valueOf(physicalParser.getSlotID()));
                subCard.setSubSlotID(physicalParser.getSubSlotID());
                ifmMap.put(mo.getDevID() + this.BANK + mo.getIfName(), mo);
                continue;
            }
            if (65543 != type && 2050 != type && 2051 != type || null == (serialParser = new SerialResIDParser(mo.getDevID().intValue(), mo.getIfName())).getPpUniResParser()) continue;
            physicalParser = serialParser.getPpUniResParser();
            board.setDevID(Integer.valueOf(physicalParser.getDevID()));
            board.setVrID(mo.getVrID());
            board.setChassisID(Integer.valueOf(physicalParser.getFrameID()));
            board.setSlotID(Integer.valueOf(physicalParser.getSlotID()));
            boardMap.put(mo.getDevID() + this.BANK + mo.getIfName(), board);
            subCard.setDevID(Integer.valueOf(physicalParser.getDevID()));
            subCard.setVrID(mo.getVrID());
            subCard.setChassisID(Integer.valueOf(physicalParser.getFrameID()));
            subCard.setSlotID(Integer.valueOf(physicalParser.getSlotID()));
            subCard.setSubSlotID(physicalParser.getSubSlotID());
            subCardMap.put(mo.getDevID() + this.BANK + mo.getIfName(), subCard);
            ifmMap.put(mo.getDevID() + this.BANK + mo.getIfName(), mo);
        }
        HashSet<Board> boardIndex = new HashSet<Board>();
        if (CollectionUtils.isEmpty(boardMap)) {
            return;
        }
        for (Board mo : boardMap.values()) {
            boardIndex.add(mo);
        }
        Collection boardInfos = this.queryByKey(Board.class, boardIndex, false);
        if (!CollectionUtils.isEmpty(ifmMap) && !CollectionUtils.isEmpty((Collection)boardInfos)) {
            block2: for (String keyName : ifmMap.keySet()) {
                Interface inf = (Interface)ifmMap.get(keyName);
                Board boardInfo = (Board)boardMap.get(keyName);
                for (Board boardMo : boardInfos) {
                    if (boardInfo.getDevID().intValue() != boardMo.getDevID().intValue() || boardInfo.getChassisID().intValue() != boardMo.getChassisID().intValue() || boardInfo.getSlotID().intValue() != boardMo.getSlotID().intValue() || null == inf) continue;
                    inf.addKeyRefMo((VmfMO)boardMo);
                    continue block2;
                }
            }
        }
    }

    public void getEthInfos(Collection<Interface> interfaces, IAsnTranslationContext context) throws VMFException {
        Collection efmInfos;
        Collection mplsInfos;
        Collection ethPortInfos;
        Collection subInfos;
        if (CollectionUtils.isEmpty(interfaces)) {
            return;
        }
        HashMap<EthernetIf, Interface> interfaceMap = new HashMap<EthernetIf, Interface>(interfaces.size());
        HashMap<EthSubIf, Interface> subIfMap = new HashMap<EthSubIf, Interface>();
        HashMap<EthernetPort, Interface> portMap = new HashMap<EthernetPort, Interface>(interfaces.size());
        HashMap<TeLink, Interface> mplsMap = new HashMap<TeLink, Interface>(interfaces.size());
        HashMap<EfmInterface, Interface> efmMap = new HashMap<EfmInterface, Interface>(interfaces.size());
        HashSet<Integer> devIDs = new HashSet<Integer>();
        for (Interface ifn : interfaces) {
            devIDs.add(ifn.getDevID());
        }
        Map<String, Interface> fdnToInfMap = this.queryFdnToInfMap(new ArrayList<Integer>(devIDs));
        for (Interface interface1 : interfaces) {
            String pareIfFdn;
            Interface pareIF;
            if (1025 == interface1.getiQIfType()) {
                EthernetIf ethIf = new EthernetIf();
                ethIf.setDevID(interface1.getDevID());
                ethIf.setVrID(interface1.getVrID());
                ethIf.setIfName(interface1.getIfName());
                interfaceMap.put(ethIf, interface1);
                EthernetPort ethPort = new EthernetPort();
                ethPort.setDevID(interface1.getDevID());
                ethPort.setVrID(interface1.getVrID());
                ethPort.setPosition(interface1.getIfPosition());
                if (null != interface1.getIfPosition()) {
                    portMap.put(ethPort, interface1);
                }
                TeLink mplsTE = new TeLink();
                mplsTE.setDevID(interface1.getDevID());
                mplsTE.setVrID(interface1.getVrID());
                mplsTE.setInterfaceName(interface1.getIfName());
                mplsMap.put(mplsTE, interface1);
                EfmInterface efmIf = new EfmInterface();
                efmIf.setDevID(interface1.getDevID());
                efmIf.setVrID(interface1.getVrID());
                efmIf.setIfName(interface1.getIfName());
                efmMap.put(efmIf, interface1);
                continue;
            }
            if (65570 != interface1.getiQIfType()) continue;
            EthSubIf subIf = new EthSubIf();
            subIf.setDevID(interface1.getDevID());
            subIf.setVrID(interface1.getVrID());
            subIf.setIfName(interface1.getIfName());
            subIfMap.put(subIf, interface1);
            String subFDN = interface1.getFdn();
            if (StringUtil.isEmpty((String)subFDN) || subFDN.indexOf(this.SUBIF) <= 0 || StringUtil.isEmpty((String)(pareIF = this.interfaceFdnFarser.getIndexMo(pareIfFdn = subFDN.substring(0, interface1.getFdn().indexOf(this.SUBIF) - 1), fdnToInfMap)).getIfName())) continue;
            interface1.addKeyRefMo((VmfMO)pareIF);
        }
        Collection ethInfos = this.queryByKey(EthernetIf.class, interfaceMap.keySet(), false);
        if (!CollectionUtils.isEmpty((Collection)ethInfos)) {
            for (EthernetIf eth : ethInfos) {
                Interface inf = (Interface)interfaceMap.get(eth);
                if (null == inf) continue;
                inf.addKeyRefMo((VmfMO)eth);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(subInfos = this.queryByKey(EthSubIf.class, subIfMap.keySet(), false)))) {
            for (EthSubIf sub : subInfos) {
                Interface inf = (Interface)subIfMap.get(sub);
                if (null == inf) continue;
                inf.addKeyRefMo((VmfMO)sub);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(ethPortInfos = this.queryByKey(EthernetPort.class, portMap.keySet(), false)))) {
            for (EthernetPort ethPort : ethPortInfos) {
                Interface inf = (Interface)portMap.get(ethPort);
                if (null == inf) continue;
                inf.addKeyRefMo((VmfMO)ethPort);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(mplsInfos = this.queryByKey(TeLink.class, mplsMap.keySet(), false)))) {
            for (TeLink mplsTe : mplsInfos) {
                Interface inf = (Interface)mplsMap.get(mplsTe);
                if (null == inf) continue;
                inf.addKeyRefMo((VmfMO)mplsTe);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(efmInfos = this.queryByKey(EfmInterface.class, efmMap.keySet(), false)))) {
            for (EfmInterface efmInfo : efmInfos) {
                Interface inf = (Interface)efmMap.get(efmInfo);
                if (null == inf) continue;
                inf.addKeyRefMo((VmfMO)efmInfo);
            }
        }
    }

    public Map<String, Interface> queryFdnToInfMap(List<Integer> devIDs) {
        if (CollectionUtils.isEmpty(devIDs)) {
            return new HashMap<String, Interface>();
        }
        HashMap<String, Interface> interfaceMap = new HashMap<String, Interface>();
        try {
            Collection interfaces = this.queryByNeID(Interface.class, devIDs, false);
            if (!CollectionUtils.isEmpty((Collection)interfaces)) {
                for (Interface ifn : interfaces) {
                    interfaceMap.put(ifn.getFdn(), ifn);
                }
            }
        }
        catch (VMFException e) {
            this.logger.error("queryFdnToInfMap error.", (Throwable)e);
        }
        return interfaceMap;
    }

    public void getOptialInfos(Collection<Interface> interfaces, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(interfaces)) {
            return;
        }
        HashMap<OpticalInfo, Interface> optMap = new HashMap<OpticalInfo, Interface>(interfaces.size());
        for (Interface inf : interfaces) {
            if (CollectionUtils.isEmpty((Collection)inf.getKeyRefMos(Port.class))) continue;
            for (Port port : inf.getKeyRefMos(Port.class)) {
                OpticalInfo optInfo = new OpticalInfo();
                optInfo.setDevID(port.getDevID());
                optInfo.setVrID(port.getVrID());
                optInfo.setChassisID(port.getChassisID());
                optInfo.setSlotID(port.getSlotID());
                optInfo.setSubSlotID(port.getSubSlotID());
                optInfo.setParentRelPosition(port.getParentRelPosition());
                optInfo.setPosition(port.getEntPosition());
                optMap.put(optInfo, inf);
            }
        }
        if (!optMap.isEmpty()) {
            Collection optInfos = this.queryByKey(OpticalInfo.class, optMap.keySet(), false);
            for (OpticalInfo opt : optInfos) {
                Interface inf = (Interface)optMap.get(opt);
                if (inf == null) continue;
                inf.addKeyRefMo((VmfMO)opt);
            }
        }
    }

    public void getPortInfos(Collection<Interface> interfaces, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(interfaces)) {
            return;
        }
        Set phyTypes = U2KInterfaceTypeMapping.getPhysicalInterfaceType();
        ArrayList<Port> portIndex = new ArrayList<Port>(interfaces.size());
        HashMap<String, Interface> interfaceMap = new HashMap<String, Interface>(interfaces.size());
        for (Interface inf : interfaces) {
            if (!phyTypes.contains(inf.getiQIfType())) continue;
            Port port = new Port();
            port.setDevID(inf.getDevID());
            port.setName(inf.getIfName());
            interfaceMap.put(inf.getDevID() + "@" + inf.getIfName(), inf);
            portIndex.add(port);
        }
        if (!portIndex.isEmpty()) {
            Collection ports = this.queryByFields(Port.class, new String[]{"devID", "name"}, portIndex, false);
            for (Port port : ports) {
                Interface inf = (Interface)interfaceMap.get(port.getDevID() + "@" + port.getName());
                if (inf == null) continue;
                inf.addKeyRefMo((VmfMO)port);
            }
        }
    }

    public void getSerialInfos(Collection<Interface> interfaces, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(interfaces)) {
            return;
        }
        HashMap<TeLink, Interface> mplsMap = new HashMap<TeLink, Interface>(interfaces.size());
        for (Interface interface1 : interfaces) {
            if (65543 != interface1.getiQIfType()) continue;
            TeLink mplsTE = new TeLink();
            mplsTE.setDevID(interface1.getDevID());
            mplsTE.setVrID(interface1.getVrID());
            mplsTE.setInterfaceName(interface1.getIfName());
            mplsMap.put(mplsTE, interface1);
        }
        Collection mplsInfos = this.queryByKey(TeLink.class, mplsMap.keySet(), false);
        if (!CollectionUtils.isEmpty((Collection)mplsInfos)) {
            for (TeLink mplsTe : mplsInfos) {
                Interface inf = (Interface)mplsMap.get(mplsTe);
                if (inf == null) continue;
                inf.addKeyRefMo((VmfMO)mplsTe);
            }
        }
    }

    public void getTrunkInfos(Collection<Interface> interfaces, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(interfaces)) {
            return;
        }
        HashMap<TrunkIf, Interface> interfaceMap = new HashMap<TrunkIf, Interface>(interfaces.size());
        for (Interface interface1 : interfaces) {
            if (65539 != interface1.getiQIfType() && 65540 != interface1.getiQIfType()) continue;
            TrunkIf trunk = new TrunkIf();
            trunk.setDevID(interface1.getDevID());
            trunk.setVrID(interface1.getVrID());
            trunk.setIfName(interface1.getIfName());
            interfaceMap.put(trunk, interface1);
        }
        Collection trunks = this.queryByKey(TrunkIf.class, interfaceMap.keySet(), false);
        for (TrunkIf trunk : trunks) {
            Interface inf = (Interface)interfaceMap.get(trunk);
            if (inf == null) continue;
            inf.addKeyRefMo((VmfMO)trunk);
        }
    }

    public boolean loadIP(int filterBit) {
        return (0x8000 & filterBit) != 0;
    }

    public Collection<Interface> queryByFilterAndFdn(Collection<Interface> indexes, Set<Integer> includePhyType, boolean loadIpAddress) throws VMFException {
        if (indexes == null || indexes.isEmpty()) {
            return Collections.emptyList();
        }
        SQLHelper sql = SQLHelper.query(Interface.class, (SessionFactory)this.getSf()).initQueryByKey(Interface.class, indexes);
        sql.selectAll(Interface.class).where(Interface.class, "iQIfType", includePhyType);
        return this.executeQuery(Interface.class, sql, loadIpAddress, true);
    }

    public Collection<InterfaceAndIpAddress> queryByFilterAndFdn(List<InterfaceAndIpAddress> indexes, Set<Integer> includePhyType) throws VMFException {
        if (indexes == null || indexes.isEmpty()) {
            return Collections.emptyList();
        }
        SQLHelper sql = SQLHelper.query(InterfaceAndIpAddress.class, (SessionFactory)this.getSf()).initQueryByKey(InterfaceAndIpAddress.class, indexes);
        sql.selectAll(InterfaceAndIpAddress.class).where(InterfaceAndIpAddress.class, "ifPhyType", includePhyType);
        return this.executeQuery(InterfaceAndIpAddress.class, sql, false, true);
    }

    public Collection<Interface> queryByFilterAndNeID(Collection<Integer> neIDs, Set<Integer> includePhyType, boolean loadIpAddress) throws VMFException {
        if (neIDs == null || neIDs.isEmpty()) {
            return Collections.emptyList();
        }
        SQLHelper sql = SQLHelper.query(Interface.class, (SessionFactory)this.getSf()).initQueryByNeID(Interface.class, neIDs);
        sql.selectAll(Interface.class).where(Interface.class, "iQIfType", includePhyType);
        return this.executeQuery(Interface.class, sql, loadIpAddress, true);
    }

    public Collection<Interface> queryByFilterAndNeIDs(Collection<Integer> indexes, Set<Integer> includePhyType, boolean loadIpAddress) throws VMFException {
        if (indexes == null || indexes.isEmpty()) {
            return Collections.emptyList();
        }
        SQLHelper sql = SQLHelper.query(Interface.class, (SessionFactory)this.getSf()).initQueryByNeID(Interface.class, indexes);
        sql.selectAll(Interface.class).where(Interface.class, "iQIfType", includePhyType);
        return this.executeQuery(Interface.class, sql, loadIpAddress, true);
    }

    public Collection<Interface> queryInterface(Collection<Interface> mos, String[] colums) throws VMFException {
        if (CollectionUtils.isEmpty(mos)) {
            return Collections.emptyList();
        }
        SQLHelper sql = SQLHelper.query(Interface.class, (SessionFactory)this.getSf()).initQueryByKey(Interface.class, mos);
        for (String col : colums) {
            sql.select(Interface.class, col);
        }
        return this.executeQuery(Interface.class, sql, true, true);
    }

    public Collection<Interface> queryInterfaceByFdn(Collection<QAsnUniResID> qasnUniResIDs) throws VMFException {
        InterfaceFdnParser fdnPaser = new InterfaceFdnParser();
        ArrayList<Interface> conditions = new ArrayList<Interface>();
        for (QAsnUniResID qasnUniResID : qasnUniResIDs) {
            Interface mo = (Interface)fdnPaser.getIndexMo(StringUtil.globalString((byte[])qasnUniResID.strFDN));
            if (null == mo) continue;
            conditions.add(mo);
        }
        if (null == conditions || 0 == conditions.size()) {
            throw new VMFException(1107498879);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        return dao.queryByKey(Interface.class, conditions, true);
    }

    public Collection<InterfaceAndIpAddress> queryInterfaceByIp(Collection<InterfaceAndIpAddress> addresses) throws VMFException {
        if (addresses == null || addresses.isEmpty()) {
            return Collections.emptyList();
        }
        String[] filterNames = new String[]{"devID", "ipAddr"};
        Object[][] filterValues = SQLHelper.getPropertyValues(InterfaceAndIpAddress.class, (String[])filterNames, addresses);
        SQLHelper sql = SQLHelper.query(InterfaceAndIpAddress.class, (SessionFactory)this.getSf()).initQueryByField(InterfaceAndIpAddress.class, filterNames, filterValues).selectAll(InterfaceAndIpAddress.class);
        return this.executeQuery(InterfaceAndIpAddress.class, sql, false, false);
    }

    public Collection<Interface> queryPortDetailByFdn(Collection<Interface> indexes, Set<Integer> includeType, IAsnTranslationContext context, int filterBit) throws VMFException {
        Collection<Interface> rs = this.queryByFilterAndFdn(indexes, includeType, this.loadIP(filterBit));
        this.loadAdditionInfo(context, rs, filterBit);
        return rs;
    }

    public Collection<Interface> queryPortDetailByNeID(Collection<Integer> indexes, Set<Integer> includeType, IAsnTranslationContext context, int filterBit) throws VMFException {
        Collection<Interface> rs = this.queryByFilterAndNeIDs(indexes, includeType, this.loadIP(filterBit));
        if (context != null) {
            this.loadAdditionInfo(context, rs, filterBit);
        }
        return rs;
    }

    public Collection<Interface> queryInterfaceInfoByKey(Collection<Interface> ifmList, IAsnTranslationContext context, int filterBit) {
        Collection<Object> resIfms = new ArrayList<Interface>();
        if (CollectionUtils.isEmpty(ifmList)) {
            return resIfms;
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            resIfms = dao.queryByKey(Interface.class, ifmList, true);
            if (CollectionUtils.isEmpty(resIfms)) {
                resIfms = new ArrayList();
            }
            if (context != null) {
                this.loadAdditionInfo(context, resIfms, filterBit);
            }
            return resIfms;
        }
        catch (VMFException e) {
            InterfaceDao.getLogger().debug("query InterfaceDao by queryInterfaceInfoByKey is fail: " + (Object)((Object)e));
            return resIfms;
        }
    }

    public Collection<Interface> querySapByFdn(List<QAsnUniResID> indexes) throws VMFException {
        if (null == indexes || indexes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Interface> lstIndex = new ArrayList<Interface>();
        for (QAsnUniResID res : indexes) {
            lstIndex.add(this.interfaceFdnFarser.getIndexMo(StringUtil.globalString((byte[])res.strFDN)));
        }
        return this.queryByKey(Interface.class, lstIndex, false);
    }

    public Collection<Interface> querySubIfByMainIf(List<Interface> indexes) throws VMFException {
        if (CollectionUtils.isEmpty(indexes)) {
            return Collections.emptyList();
        }
        String[] keys = new String[]{"devID", "vrID", "ifName"};
        Object[][] values = SQLHelper.getIdentifierPropertyValues(Interface.class, indexes, (SessionFactory)this.getSf());
        int IFNAME_INDEX = 2;
        for (Object[] objects : values) {
            objects[2] = objects[2] + ".%";
        }
        CompareOperator[] operators = new CompareOperator[]{CompareOperator.EQ, CompareOperator.EQ, CompareOperator.LIKE};
        SQLHelper sql = SQLHelper.query(Interface.class, (SessionFactory)this.getSf());
        sql.selectAll(Interface.class).where(Interface.class, keys, operators, values, keys.length);
        Collection subIfMos = this.executeQuery(Interface.class, sql, false, true);
        QAsnGetSap sapQuery = new QAsnGetSap();
        return sapQuery.queryByInterface(subIfMos);
    }

    public void setRelationship(Class<?> parentType, Collection<?> parents, Class<?> childType, Collection<?> children) throws VMFException {
        super.setRelationship(parentType, parents, childType, children);
    }

    private void loadAdditionInfo(IAsnTranslationContext context, Collection<Interface> rs, int filterBit) throws VMFException {
        Object extPoitService;
        if (((0x800000 & filterBit) != 0 || (0x100000 & filterBit) != 0) && null == (extPoitService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class))) {
            this.getPortInfos(rs, context);
            this.getTrunkInfos(rs, context);
        }
        if (null != (extPoitService = ExtendPointServiceMgr.getInstance().getExtendPoitService(IPortTranslatorFunctionExtPoint.class))) {
            this.getPortInfos(rs, context);
            this.getEthInfos(rs, context);
            this.getOptialInfos(rs, context);
            this.getSerialInfos(rs, context);
            this.getBoardInfo(rs, context);
        }
    }
}

