/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.common;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_common.QAsnPortIndexList;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.InterfaceUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.SubInterfaceResIDParser;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.translation.asn.ethernet.IQAsnEthCtpTranslatorExtPoint;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IInterfaceUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.ifm.model.ChannelSet;
import com.huawei.vmf.adapter.fservice.ifm.model.CposChannel;
import com.huawei.vmf.adapter.fservice.ifm.model.CposPort;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1;
import com.huawei.vmf.adapter.fservice.ifm.model.E1t1Port;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.StmChannel;
import com.huawei.vmf.adapter.fservice.ifm.model.StmPort;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkIf;
import com.huawei.vmf.adapter.fservice.ifm.model.TrunkMemberIf;
import com.huawei.vmf.adapter.fservice.ifm.model.Vc12;
import com.huawei.vmf.adapter.fservice.ifm.model.Vc4;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.ifm.Activator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class InterfaceUtil {
    public static final int CHASSIS_ID = 0;
    public static final int MULTI_FRAME_TUPLE = 4;
    public static final int PORT_ID = 3;
    public static final int QUERY_ALL = Integer.MAX_VALUE;
    public static final int SLOT_ID = 1;
    public static final int SUBSLOT_ID = 2;
    private static final int ADMIN_VR = 0;
    private static final Pattern IF_POSITION_PATTERN = Pattern.compile("([\\d]*[/]?[\\d]+/[\\d]+/[\\d]+)");
    private static final Logger logger = LoggerFactory.getLogger(InterfaceUtil.class);

    public static Collection<Interface> filterSerialInterface(Collection<Interface> interfaces) {
        ArrayList<Interface> subInfs = new ArrayList<Interface>();
        for (Interface inf : interfaces) {
            int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)inf.getIfName());
            if (65543 == ifType) continue;
            subInfs.add(inf);
        }
        return subInfs;
    }

    public static Collection<Interface> filterSubInterface(Collection<Interface> interfaces) {
        ArrayList<Interface> subInfs = new ArrayList<Interface>();
        for (Interface inf : interfaces) {
            if (!InterfaceUtil.isMainInterface(inf.getIfName())) continue;
            subInfs.add(inf);
        }
        return subInfs;
    }

    public static Class getCesClass(Interface mo) {
        Class<CposPort> clazz = CposPort.class;
        int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        if (2049 == ifType) {
            clazz = CposPort.class;
        } else if (128 == ifType) {
            clazz = E1t1Port.class;
        } else if (65543 == ifType) {
            clazz = Interface.class;
        } else {
            logger.debug("InterfaceUtil getCesClass :interfaceType is unknow for " + mo.getIfName());
        }
        return clazz;
    }

    public static Class getCposOrE1ClassBySerial(Interface serialMo) {
        Class clazz = serialMo.getIfName().split("/").length == 4 ? CposPort.class : E1t1Port.class;
        return clazz;
    }

    public static String getDevTypeName(Integer devId) throws VMFException {
        IDeviceService deviceService = Activator.getService(IDeviceService.class);
        DevTypeInfo devTypeInfo = deviceService.getDevTypeAndVersion(devId.intValue());
        return devTypeInfo.getDevTypeName();
    }

    public static String getFdnTypeByFdn(String fdn) {
        if (null == fdn || fdn.isEmpty()) {
            return "";
        }
        if (fdn.indexOf("SUBIF=") > 0) {
            return "SUBIF";
        }
        if (fdn.indexOf("PP=") > 0) {
            return "PP";
        }
        if (fdn.indexOf("LP=") > 0) {
            return "LP";
        }
        return "";
    }

    public static void getIndexByFdn(Interface index, String fdn, String moType) {
        if ("PP".equals(moType)) {
            PortUniResIDParser parser = new PortUniResIDParser();
            parser.deserialize(fdn);
            index.setDevID(Integer.valueOf(parser.getDevID()));
            index.setIfName(parser.getCliName());
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            try {
                Collection interfaces = dao.queryByFields(Interface.class, new String[]{"devID", "ifName"}, Collections.singleton(index), true);
                Iterator it = interfaces.iterator();
                if (it.hasNext()) {
                    Interface inter = (Interface)it.next();
                    index.setVrID(inter.getVrID());
                    index.setIfAdminStatus(inter.getIfAdminStatus());
                    index.setIfOperStatus(inter.getIfOperStatus());
                }
            }
            catch (VMFException e) {
                logger.error("get PP interface by fields failed. interface = " + index);
            }
        } else if ("LP".equals(moType)) {
            InterfaceUniResIDParser parser = new InterfaceUniResIDParser();
            parser.deserialize(fdn);
            index.setDevID(Integer.valueOf(parser.getDevID()));
            index.setVrID(Integer.valueOf(parser.getVrID()));
            index.setIfName(parser.getIfName());
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            try {
                Collection interfaces = dao.queryByFields(Interface.class, new String[]{"devID", "ifName"}, Collections.singleton(index), true);
                Iterator it = interfaces.iterator();
                if (it.hasNext()) {
                    Interface inter = (Interface)it.next();
                    index.setIfAdminStatus(inter.getIfAdminStatus());
                    index.setIfOperStatus(inter.getIfOperStatus());
                }
            }
            catch (VMFException e) {
                logger.error("get LP interface by fields failed. interface = " + index);
            }
        } else {
            SubInterfaceResIDParser parser = new SubInterfaceResIDParser();
            parser.deserialize(fdn);
            InterfaceUtil.parseSubInterface(parser, index);
        }
    }

    public static Interface getIndexByFdn(QAsnUniResID uid) {
        return InterfaceUtil.getIndexByFdn(StringUtil.globalString((byte[])uid.strFDN), StringUtil.globalString((byte[])uid.strMOC));
    }

    public static Interface getIndexByFdn(String fdn) {
        return InterfaceUtil.getIndexByFdn(fdn, FDNUtil.getFdnType((String)fdn));
    }

    public static Interface getIndexByFdn(String fdn, String moType) {
        Interface index = new Interface();
        InterfaceUtil.getIndexByFdn(index, fdn, moType);
        return index;
    }

    public static Interface getIndexByPortIndex(QAsnPortIndex portIndex) {
        Interface index = new Interface();
        index.setDevID(Integer.valueOf(portIndex.neID));
        index.setVrID(Integer.valueOf(0));
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
        if (null != interfaceUtilExtPoint) {
            if (null == portIndex.cliname || new String(portIndex.cliname).isEmpty()) {
                index.setIfName(InterfaceUtil.getIfName(portIndex));
            } else {
                index.setIfName(StringUtil.globalString((byte[])portIndex.cliname));
            }
        } else {
            index.setIfName(StringUtil.globalString((byte[])portIndex.cliname));
        }
        return index;
    }

    public static String getInterfaceFdn(int devID, int vrID, String ifName) {
        String mocType = InterfaceUtil.getInterfaceFdnType(ifName);
        if ("" == mocType) {
            return mocType;
        }
        Object parser = null;
        parser = "PP".equals(mocType) ? new PortUniResIDParser(devID, ifName) : ("LP".equals(mocType) ? ("" == FDNUtil.getPostionFromIfName((String)ifName) ? new InterfaceUniResIDParser(devID, Integer.valueOf(vrID), ifName) : new PortUniResIDParser(devID, ifName, true)) : new SubInterfaceResIDParser(devID, vrID, ifName));
        return parser.serialize();
    }

    public static String getInterfaceFdn(Interface inf) {
        return InterfaceUtil.getInterfaceFdn(inf.getDevID(), inf.getVrID(), inf.getIfName());
    }

    public static String getInterfaceFdnType(Interface inf) {
        return InterfaceUtil.getInterfaceFdnType(inf.getIfName());
    }

    public static String getInterfaceFdnType(String ifName) {
        int type = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)ifName);
        if (0 == type) {
            return "";
        }
        if (U2KInterfaceTypeMapping.getPhysicalInterfaceType().contains(type)) {
            return "PP";
        }
        if (U2KInterfaceTypeMapping.getLogicalInterfaceType().contains(type)) {
            return "LP";
        }
        return "SUBIF";
    }

    public static String getParentInterfaceFdn(Interface inf) {
        String parentInterfaceName = inf.getIfParentIfName();
        if (parentInterfaceName == null) {
            return "";
        }
        return InterfaceUtil.getInterfaceFdn(inf.getDevID(), inf.getVrID(), parentInterfaceName);
    }

    public static List<Interface> getPortIndex(QAsnPortIndexList portIndexList) {
        ArrayList<Interface> rs = new ArrayList<Interface>(portIndexList.size());
        for (QAsnPortIndex asnUniResID : portIndexList) {
            rs.add(InterfaceUtil.getIndexByPortIndex(asnUniResID));
        }
        return rs;
    }

    public static HashMap<Interface, QAsnPortIndex> getPortIndexMap(QAsnPortIndexList portIndexList) {
        HashMap<Interface, QAsnPortIndex> map = new HashMap<Interface, QAsnPortIndex>();
        for (int index = 0; index < portIndexList.size(); ++index) {
            QAsnPortIndex asn = (QAsnPortIndex)portIndexList.get(index);
            map.put(InterfaceUtil.getIndexByPortIndex(asn), asn);
        }
        return map;
    }

    public static int getPortNum(int portID) {
        int portNum = portID & 0xFFFF;
        return portNum;
    }

    public static String getPositionFromInterfaceName(String ifName) {
        Matcher matcher = IF_POSITION_PATTERN.matcher(ifName);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static Class getStmOrE1ClassBySerial(Interface serialMo) {
        Class clazz = serialMo.getIfName().split("/").length == 3 ? StmPort.class : E1t1Port.class;
        return clazz;
    }

    public static String getStringFromSequenceOfInt(List src) {
        if (src != null) {
            Collections.sort(src);
            StringBuffer result = new StringBuffer();
            boolean bneedAddDelim = false;
            int start = 0;
            int end = 0;
            int startTemp = 0;
            int endTemp = 0;
            int endTempX = 0;
            int size = src.size();
            while (start != end || start != size) {
                endTempX = Integer.valueOf(src.get(++end - 1).toString());
                startTemp = Integer.valueOf(src.get(start).toString());
                if (end < src.size() && (endTemp = Integer.valueOf(src.get(end).toString()).intValue()) - endTempX == 1) continue;
                if (bneedAddDelim) {
                    result.append(",");
                }
                if (start == end - 1) {
                    result.append(startTemp);
                } else {
                    result.append(startTemp);
                    result.append("-");
                    result.append(endTempX);
                }
                bneedAddDelim = true;
                start = end;
            }
            return new String(result);
        }
        return "";
    }

    public static String getTrunkInterfaceFdn(TrunkIf trunk) {
        InterfaceUniResIDParser parser = new InterfaceUniResIDParser(trunk.getDevID().intValue(), trunk.getVrID(), trunk.getIfName());
        return parser.serialize();
    }

    public static String getTrunkMemberInterfaceFdn(TrunkMemberIf member) {
        PortUniResIDParser parser = null;
        int portType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)member.getMemberIfName());
        if (U2KInterfaceTypeMapping.getPhysicalInterfaceType().contains(portType)) {
            parser = new PortUniResIDParser(member.getDevID().intValue(), member.getMemberIfName());
        } else if (U2KInterfaceTypeMapping.getLogicalInterfaceType().contains(portType)) {
            parser = new InterfaceUniResIDParser(member.getDevID().intValue(), member.getVrID(), member.getMemberIfName());
        } else {
            logger.debug("InterfaceUtil getTrunkMemberInterfaceFdn : subIf isnot join into the trunk." + member.getMemberIfName());
        }
        return parser.serialize();
    }

    public static boolean isFrame(String timeSlotList) {
        return null != timeSlotList && !timeSlotList.equals("") && !timeSlotList.equals("0-31");
    }

    public static boolean isHasStmPortExtPoint() {
        Object stmPortTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnEthCtpTranslatorExtPoint.class);
        return null != stmPortTranslatorExtPoint;
    }

    public static boolean isLogicInterface(Interface inf) {
        Integer type = inf.getiQIfType();
        return U2KInterfaceTypeMapping.getLogicalInterfaceType().contains(type);
    }

    public static boolean isMainInterface(String ifName) {
        return !ifName.contains(".");
    }

    public static boolean isPhysicalInterface(Interface inf) {
        Integer type = inf.getiQIfType();
        return U2KInterfaceTypeMapping.getPhysicalInterfaceType().contains(type);
    }

    public static boolean isPhysicalMainType(Interface mo) {
        return InterfaceUtil.isPhysicalInterface(mo) && InterfaceUtil.isMainInterface(mo.getIfName());
    }

    public static boolean isPhysicalSubInteface(Interface inf) {
        return !InterfaceUtil.isPhysicalInterface(inf) && !InterfaceUtil.isLogicInterface(inf);
    }

    public static int isPropertyChanged(VmfMO mo, List<String> propertyNames, IAsnTranslationContext context) {
        IMOChangeRecord changeRecord;
        int maskChangFlag = 0;
        Context transactionContext = context.getTransactionContext();
        if (null != transactionContext && null != (changeRecord = transactionContext.getChangeRecord(mo.getClass())) && changeRecord.containsPropertyChanged((Object)mo, propertyNames)) {
            maskChangFlag = 1;
        }
        return maskChangFlag;
    }

    public static boolean isValid(Integer inter) {
        return null != inter && -1 != inter;
    }

    public static ArrayList parseSlot(String s) {
        if (s == null) {
            return new ArrayList();
        }
        char[] ch = s.toCharArray();
        int len = ch.length;
        if (len > 1 && (ch[len - 1] < '0' || ch[len - 1] > '9')) {
            return new ArrayList();
        }
        return InterfaceUtil.parseTimeSlot(s);
    }

    public static Port toPortIndex(Interface infIndex) {
        Port port = new Port();
        port.setDevID(infIndex.getDevID());
        String pos = infIndex.getIfPosition();
        if (null == pos) {
            return null;
        }
        String[] coordinate = pos.split("/");
        InterfaceUtil.setPosition(port, coordinate);
        return port;
    }

    public static Interface transCposOrE1ToSerial(VmfMO cposOrE1Mo) {
        Interface serialMo = cposOrE1Mo.getClass().equals(CposPort.class) ? InterfaceUtil.transCposToSerial(cposOrE1Mo) : InterfaceUtil.transE1ToSerial(cposOrE1Mo);
        return serialMo;
    }

    public static Interface transCposToSerial(VmfMO cpos1Mo) {
        Collection e1t1s = ((CposPort)cpos1Mo).getE1t1s();
        E1t1 e1t1 = (E1t1)e1t1s.iterator().next();
        Long e1t1Number = e1t1.getE1t1Number();
        Long setNumber = ((CposChannel)e1t1.getCposChannels().iterator().next()).getSetNumber();
        String serialIfname = "Serial" + ((CposPort)cpos1Mo).getPosition() + "/" + e1t1Number + ":" + setNumber;
        Interface serialInf = new Interface();
        serialInf.setDevID(cpos1Mo.getDevID());
        serialInf.setVrID(cpos1Mo.getVrID());
        serialInf.setIfName(serialIfname);
        return serialInf;
    }

    public static Interface transE1ToSerial(VmfMO e1Mo) {
        Collection channelSets = ((E1t1Port)e1Mo).getChannelSets();
        Long setNumber = ((ChannelSet)channelSets.iterator().next()).getSetNumber();
        String serialIfname = "Serial" + ((E1t1Port)e1Mo).getPosition() + ":" + setNumber;
        Interface serialInf = new Interface();
        serialInf.setDevID(e1Mo.getDevID());
        serialInf.setVrID(e1Mo.getVrID());
        serialInf.setIfName(serialIfname);
        return serialInf;
    }

    public static VmfMO transSerialToCposOrE1(Interface serialMo) {
        int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)serialMo.getIfName());
        if (65543 != ifType) {
            return null;
        }
        Class clazz = InterfaceUtil.getCposOrE1ClassBySerial(serialMo);
        if (null == clazz) {
            return null;
        }
        VmfMO cposOrE1 = clazz.equals(CposPort.class) ? InterfaceUtil.transSerialToCpos(serialMo) : InterfaceUtil.transSerialToE1(serialMo);
        return cposOrE1;
    }

    public static VmfMO transSerialToStmOrE1(Interface serialMo) {
        int ifType = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)serialMo.getIfName());
        if (65543 != ifType) {
            return null;
        }
        Class clazz = InterfaceUtil.getStmOrE1ClassBySerial(serialMo);
        if (null == clazz) {
            return null;
        }
        VmfMO cposOrE1 = clazz.equals(StmPort.class) ? InterfaceUtil.transSerialToStm(serialMo) : null;
        return cposOrE1;
    }

    protected static int intValue(Integer i, int defaultValue) {
        return null == i ? defaultValue : i;
    }

    private static boolean decodeChassisID(Port port, QAsnPortIndex asnPortIndex) {
        if (null == asnPortIndex.shelfID) {
            return true;
        }
        int chassisID = InterfaceUtil.intValue(asnPortIndex.shelfID, -1);
        if (Integer.MAX_VALUE == chassisID) {
            Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
            if (null != invUtilExtPoint) {
                chassisID = 1;
                port.setChassisID(Integer.valueOf(chassisID));
                return true;
            }
            return false;
        }
        if (chassisID >= 0) {
            port.setChassisID(Integer.valueOf(chassisID));
        }
        return true;
    }

    private static boolean decodePortID(Port port, QAsnPortIndex asnPortIndex) {
        int portID = asnPortIndex.portID;
        if (Integer.MAX_VALUE == portID) {
            return false;
        }
        if (portID >= 0) {
            port.setParentRelPosition(Integer.valueOf(InterfaceUtil.getPortNum(portID)));
        }
        return true;
    }

    private static boolean decodeSlotID(Port port, QAsnPortIndex asnPortIndex) {
        int slotID = asnPortIndex.slotID;
        if (Integer.MAX_VALUE == slotID) {
            return false;
        }
        if (slotID >= 0) {
            Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
            if (null != invUtilExtPoint && null != asnPortIndex.shelfID && Integer.MAX_VALUE == asnPortIndex.shelfID && Integer.MAX_VALUE == asnPortIndex.portID && slotID == 0) {
                return true;
            }
            port.setSlotID(Integer.valueOf(slotID));
        }
        return true;
    }

    private static boolean decodeSubSlotID(Port port, QAsnPortIndex asnPortIndex) {
        if (null == asnPortIndex.subSlotID) {
            return true;
        }
        int subSlotID = InterfaceUtil.intValue(asnPortIndex.subSlotID, -1);
        if (Integer.MAX_VALUE == subSlotID) {
            return false;
        }
        if (subSlotID >= 0) {
            Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
            if (null != interfaceUtilExtPoint && Integer.MAX_VALUE == asnPortIndex.portID && subSlotID == 0) {
                return true;
            }
            port.setSubSlotID(Integer.valueOf(subSlotID));
        } else {
            Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceUtilExtPoint.class);
            if (null != interfaceUtilExtPoint) {
                port.setSubSlotID(Integer.valueOf(subSlotID));
            }
        }
        return true;
    }

    private static String getIfName(QAsnPortIndex portIndex) {
        String ifName = "";
        Port index = new Port();
        index.setDevID(Integer.valueOf(portIndex.neID));
        boolean continueDecode = true;
        continueDecode = InterfaceUtil.decodeChassisID(index, portIndex);
        if (!continueDecode) {
            return ifName;
        }
        continueDecode = InterfaceUtil.decodeSlotID(index, portIndex);
        if (!continueDecode) {
            return ifName;
        }
        continueDecode = InterfaceUtil.decodeSubSlotID(index, portIndex);
        if (!continueDecode) {
            return ifName;
        }
        InterfaceUtil.decodePortID(index, portIndex);
        ArrayList<Port> portMos = new ArrayList<Port>();
        portMos.add(index);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> portClazz = ((Port)portMos.iterator().next()).getClass();
        Collection resPorts = null;
        try {
            resPorts = dao.queryByKey(portClazz, portMos, false);
            if (!CollectionUtils.isEmpty((Collection)resPorts)) {
                for (Port port : resPorts) {
                    Integer slotID = port.getSlotID();
                    Integer portID = port.getParentRelPosition();
                    if (null == slotID || slotID != portIndex.slotID || null == portID || portID != portIndex.portID) continue;
                    return port.getName();
                }
                ifName = ((Port)resPorts.iterator().next()).getName();
            }
        }
        catch (VMFException e) {
            logger.error("QAsnGetPortIpAndDescReq getIfName fail: " + (Object)((Object)e));
        }
        return ifName;
    }

    private static void parseSubInterface(SubInterfaceResIDParser parser, Interface index) {
        String parentIfName = null;
        index.setIfNumber(String.valueOf(parser.getSubIfNum()));
        if (parser.getPpUniResParser() != null) {
            parentIfName = parser.getPpUniResParser().getCliName();
            index.setDevID(Integer.valueOf(parser.getPpUniResParser().getDevID()));
            index.setIfParentIfName(parentIfName);
            index.setVrID(Integer.valueOf(0));
        } else if (parser.getLpUniResParser() != null) {
            parentIfName = parser.getLpUniResParser().getIfName();
            index.setDevID(Integer.valueOf(parser.getLpUniResParser().getDevID()));
            index.setVrID(Integer.valueOf(parser.getLpUniResParser().getVrID()));
            index.setIfParentIfName(parentIfName);
        }
        if (parentIfName != null) {
            index.setIfName(parentIfName + "." + index.getIfNumber());
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            try {
                Collection interfaces = dao.queryByFields(Interface.class, new String[]{"devID", "ifName"}, Collections.singleton(index), true);
                Iterator it = interfaces.iterator();
                if (it.hasNext()) {
                    Interface inter = (Interface)it.next();
                    index.setIfAdminStatus(inter.getIfAdminStatus());
                    index.setIfOperStatus(inter.getIfOperStatus());
                }
            }
            catch (VMFException e) {
                logger.error("get subinterface by fields failed. interface = " + index);
            }
        }
    }

    private static ArrayList parseTimeSlot(String s) {
        ArrayList<Integer> hs = new ArrayList<Integer>();
        int cur = -1;
        int last = -1;
        char[] ch = s.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                if (cur == -1) {
                    cur = 0;
                }
                cur = cur * 10 + (ch[i] - 48);
                continue;
            }
            if (ch[i] == ',') {
                if (last != -1 && cur != -1) {
                    int min;
                    int max = cur;
                    if (last > cur) {
                        min = cur;
                        for (max = last; max >= min; --max) {
                            hs.add(max);
                        }
                    } else {
                        for (min = last; min <= max; ++min) {
                            hs.add(min);
                        }
                    }
                } else if (cur != -1) {
                    hs.add(cur);
                } else {
                    return null;
                }
                last = -1;
                cur = -1;
                continue;
            }
            if (ch[i] == '-') {
                if (last != -1 || last == -1 && cur == -1) {
                    hs = null;
                    return null;
                }
                if (cur != -1) {
                    last = cur;
                }
                cur = -1;
                continue;
            }
            if (ch[i] == '[' || ch[i] == ']') continue;
            hs = null;
            return null;
        }
        if (last != -1 && cur != -1) {
            int min;
            int max = cur;
            if (last > cur) {
                min = cur;
                for (max = last; max >= min; --max) {
                    hs.add(max);
                }
            } else {
                for (min = last; min <= max; ++min) {
                    hs.add(min);
                }
            }
        } else if (cur != -1) {
            hs.add(cur);
        }
        return hs;
    }

    private static void setPosition(Port port, String[] coordinate) {
        if (4 == coordinate.length) {
            port.setChassisID(Integer.valueOf(Integer.parseInt(coordinate[0])));
            port.setSlotID(Integer.valueOf(Integer.parseInt(coordinate[1])));
            port.setSubSlotID(Integer.valueOf(Integer.parseInt(coordinate[2])));
            port.setParentRelPosition(Integer.valueOf(Integer.parseInt(coordinate[3])));
        } else {
            port.setChassisID(Integer.valueOf(1));
            port.setSlotID(Integer.valueOf(Integer.parseInt(coordinate[0])));
            port.setSubSlotID(Integer.valueOf(Integer.parseInt(coordinate[1])));
            port.setParentRelPosition(Integer.valueOf(Integer.parseInt(coordinate[2])));
        }
    }

    private static VmfMO transSerialToCpos(Interface serialMo) {
        try {
            String serialName = serialMo.getIfName();
            String postfix = serialName.split("Serial")[1];
            String ifNumber = postfix.split(":")[0];
            String setNumberStr = postfix.split(":")[1];
            if (setNumberStr.indexOf(".") != -1) {
                return null;
            }
            String postion = ifNumber.substring(0, ifNumber.lastIndexOf("/"));
            CposChannel cposChannelIndex = new CposChannel();
            cposChannelIndex.setDevID(serialMo.getDevID());
            cposChannelIndex.setVrID(serialMo.getVrID());
            cposChannelIndex.setPosition(postion);
            cposChannelIndex.setE1t1Number(Long.valueOf(ifNumber.split("/")[3]));
            cposChannelIndex.setSetNumber(Long.valueOf(setNumberStr));
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection cposChannels = dao.queryByKey(CposChannel.class, Arrays.asList(cposChannelIndex), false);
            if (CollectionUtils.isEmpty((Collection)cposChannels)) {
                return null;
            }
            CposChannel cposChannel = (CposChannel)cposChannels.iterator().next();
            CposPort cposPort = new CposPort();
            cposPort.setDevID(serialMo.getDevID());
            cposPort.setVrID(serialMo.getVrID());
            cposPort.setPosition(cposChannel.getPosition());
            E1t1 e1t1 = new E1t1();
            e1t1.setDevID(serialMo.getDevID());
            e1t1.setVrID(serialMo.getVrID());
            e1t1.setPosition(cposChannel.getPosition());
            e1t1.setE1t1Number(cposChannel.getE1t1Number());
            Collection e1t1s = dao.queryByKey(E1t1.class, Arrays.asList(e1t1), false);
            if (CollectionUtils.isEmpty((Collection)e1t1s)) {
                return null;
            }
            e1t1 = (E1t1)e1t1s.iterator().next();
            e1t1.addCposChannels(Arrays.asList(cposChannel));
            cposPort.addE1t1s(Arrays.asList(e1t1));
            return cposPort;
        }
        catch (VMFException e) {
            logger.error("transSerialToCpos error." + (Object)((Object)e));
            return null;
        }
    }

    private static VmfMO transSerialToE1(Interface serialMo) {
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            String serialName = serialMo.getIfName();
            String postfix = serialName.split("Serial")[1];
            String setNumberStr = postfix.split(":")[1];
            ChannelSet channelSetIndex = new ChannelSet();
            channelSetIndex.setDevID(serialMo.getDevID());
            channelSetIndex.setVrID(serialMo.getVrID());
            channelSetIndex.setPosition(postfix.split(":")[0]);
            channelSetIndex.setSetNumber(Long.valueOf(setNumberStr));
            Collection channelSets = dao.queryByKey(ChannelSet.class, Arrays.asList(channelSetIndex), false);
            if (CollectionUtils.isEmpty((Collection)channelSets)) {
                return null;
            }
            ChannelSet channelSet = (ChannelSet)channelSets.iterator().next();
            E1t1Port e1t1Port = new E1t1Port();
            e1t1Port.setDevID(serialMo.getDevID());
            e1t1Port.setVrID(serialMo.getVrID());
            e1t1Port.setPosition(channelSet.getPosition());
            Collection e1t1ports = dao.queryByKey(E1t1Port.class, Arrays.asList(e1t1Port), false);
            if (CollectionUtils.isEmpty((Collection)e1t1ports)) {
                return null;
            }
            e1t1Port = (E1t1Port)e1t1ports.iterator().next();
            e1t1Port.addChannelSets(Arrays.asList(channelSet));
            return e1t1Port;
        }
        catch (VMFException e) {
            logger.error("transSerialToE1 error." + (Object)((Object)e));
            return null;
        }
    }

    private static VmfMO transSerialToStm(Interface serialMo) {
        Collection stmChannels;
        String serialName = serialMo.getIfName();
        String postfix = serialName.split("Serial")[1];
        String postion = postfix.split(":")[0];
        String vc4Number = postfix.split(":")[1];
        String vc12Number = postfix.split(":")[2];
        String setNumber = postfix.split(":")[3];
        StmChannel stmChannel = new StmChannel();
        stmChannel.setDevID(serialMo.getDevID());
        stmChannel.setVrID(serialMo.getVrID());
        stmChannel.setPosition(postion);
        stmChannel.setVc4Number(Integer.valueOf(vc4Number));
        stmChannel.setVc12Number(Integer.valueOf(vc12Number));
        stmChannel.setSetNumber(Integer.valueOf(setNumber));
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            stmChannels = dao.queryByKey(StmChannel.class, Arrays.asList(stmChannel), false);
        }
        catch (VMFException e) {
            logger.error("transSerialToStm error.", (Throwable)e);
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)stmChannels)) {
            return null;
        }
        stmChannel.setTimeslotlist(((StmChannel)stmChannels.iterator().next()).getTimeslotlist());
        Vc12 vc12 = new Vc12();
        vc12.setDevID(serialMo.getDevID());
        vc12.setVrID(serialMo.getVrID());
        vc12.setPosition(postion);
        vc12.setVc4Number(Integer.valueOf(vc4Number));
        vc12.setVc12Number(Integer.valueOf(vc12Number));
        vc12.addChannelsets(Arrays.asList(stmChannel));
        Vc4 vc4 = new Vc4();
        vc4.setDevID(serialMo.getDevID());
        vc4.setVrID(serialMo.getVrID());
        vc4.setPosition(postion);
        vc4.setVc4Number(Integer.valueOf(vc4Number));
        vc4.addVc12s(Arrays.asList(vc12));
        StmPort stmPort = new StmPort();
        stmPort.setDevID(serialMo.getDevID());
        stmPort.setVrID(serialMo.getVrID());
        stmPort.setPosition(postion);
        stmPort.addVc4s(Arrays.asList(vc4));
        return stmPort;
    }
}

