/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm.common;

import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterDevMgr {
    public static final String EXCLUDE = "exclude";
    public static final String IF_DEV_CAP_DIR = ProcessInfoHelper.BUNDLE_PATH + File.separator + "com.huawei.vmf.adapter.ifm" + File.separator + "conf" + File.separator + "res.properties";
    public static final String SERIAL = "Serial";
    public static final String SUBINTERFACE = "subinterface";
    private static final AdapterDevMgr adapterDevMgr = null;
    private static Map<String, HashMap<String, Boolean>> devConfigMap = new HashMap<String, HashMap<String, Boolean>>();
    private static Logger logger = LoggerFactory.getLogger(AdapterDevMgr.class);

    private AdapterDevMgr() {
        try {
            AdapterDevMgr.init();
        }
        catch (IOException exp) {
            logger.debug("init exception.", (Throwable)exp);
        }
    }

    public static AdapterDevMgr getInstance() {
        if (null == adapterDevMgr) {
            return new AdapterDevMgr();
        }
        return adapterDevMgr;
    }

    public static void main(String[] args) {
        HashMap<String, Boolean> map = AdapterDevMgr.getInstance().getDevConfigByType("ptn59");
        System.out.println(map);
        System.out.println(adapterDevMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() throws IOException {
        File file = new File(IF_DEV_CAP_DIR);
        Properties properties = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            properties.load(stream);
        }
        catch (Exception e) {
            logger.debug("config file[{}] doesn't exsit.", (Object)IF_DEV_CAP_DIR);
        }
        finally {
            Set<Object> devTypes = properties.keySet();
            for (Object obj : devTypes) {
                HashMap<String, Boolean> devCap = new HashMap<String, Boolean>();
                String devType = String.valueOf(obj);
                String value = properties.getProperty(devType);
                if (value.contains(SUBINTERFACE)) {
                    devCap.put(SUBINTERFACE, Boolean.TRUE);
                }
                if (value.contains(SERIAL)) {
                    devCap.put(SERIAL, Boolean.TRUE);
                }
                devConfigMap.put(devType, devCap);
            }
            if (null != stream) {
                stream.close();
            }
        }
    }

    public HashMap<String, Boolean> getDevConfigByType(String devType) {
        return devConfigMap.get(devType);
    }
}

