/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.ifm;

import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.vmf.adapter.common.exception.ServiceNotAvailableException;
import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.common.EFunctionType;
import com.huawei.vmf.adapter.framework.model.MOAdditionalInfoMgr;
import com.huawei.vmf.adapter.framework.notify.INotifyListener;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.syncdata.INEUploadHandler;
import com.huawei.vmf.adapter.framework.syncdata.NEUploadHandlerHolder;
import com.huawei.vmf.adapter.framework.trapadmin.FaultConfiguration;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmGlobalService;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmInterface;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvc;
import com.huawei.vmf.adapter.fservice.ifm.model.AtmPvp;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.ifm.fault.LinkFault;
import com.huawei.vmf.adapter.ifm.notify.IfmDevDeleteChangeListener;
import com.huawei.vmf.adapter.ifm.notify.InterfaceChangeListener;
import com.huawei.vmf.adapter.ifm.task.IfmTask;
import java.util.Collection;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Activator
implements BundleActivator,
ApplicationContextAware {
    public static final Logger LOGGER = RunLogger.getLogger(Activator.class);
    private static ApplicationContext applicationContext;
    private static BundleContext context;
    private ServiceRegistration metaFacrotyRef;
    private ServiceRegistration translatorFacrotyRef;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static <T> T getService(Class<T> serviceType) throws ServiceNotAvailableException {
        if (applicationContext == null) {
            throw new ServiceNotAvailableException(serviceType);
        }
        Object serviceInstance = applicationContext.getBean(serviceType);
        if (serviceInstance == null) {
            throw new ServiceNotAvailableException(serviceType);
        }
        return (T)serviceInstance;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        applicationContext = ctx;
    }

    public void start(BundleContext bundleContext) throws Exception {
        MOAdditionalInfoMgr.getInstance().addFeatureTopMoClass(FeatureName.IFMATM, AtmInterface.class);
        MOAdditionalInfoMgr.getInstance().addFeatureTopMoClass(FeatureName.IFMATM, AtmPvc.class);
        MOAdditionalInfoMgr.getInstance().addFeatureTopMoClass(FeatureName.IFMATM, AtmPvp.class);
        MOAdditionalInfoMgr.getInstance().addFeatureTopMoClass(FeatureName.IFMATM, AtmGlobalService.class);
        context = bundleContext;
        this.registryQTask();
        this.registerMOListener();
        this.registerFaultListener();
        NEUploadHandlerHolder.getInstance().addListener((INEUploadHandler)new InterfaceChangeListener());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.unregistry();
        context = null;
    }

    private void registerFaultListener() {
        FaultConfiguration.getDefaultConfiguration().registerFaultListener(Activator.class.getPackage().getName(), (IFaultListener)new LinkFault());
    }

    private void registerMOListener() {
        MOChangePublisher.getInstance().registry((INotifyListener)new InterfaceChangeListener());
        MOChangePublisher.getInstance().registry((INotifyListener)new IfmDevDeleteChangeListener());
    }

    private void registryQTask() {
        ProcessInfo info = ProcessInfoHelper.getRuntimeProcessInfo();
        TaskDispatcherMgr mgr = TaskDispatcherMgr.getInstance((ProcessInfo)info);
        mgr.registerTask(IfmTask.class);
        MOAdditionalInfoMgr.getInstance().addMoSyncStatusInfo(Interface.class, EFunctionType.Q_TASK, (Collection)CommonUtil.genList((Object[])new String[]{"ifIndex", "ifMac", "ifAdminStatus", "ifOperStatus"}));
    }

    private void unregistry() {
        if (this.metaFacrotyRef != null) {
            this.metaFacrotyRef.unregister();
        }
        if (this.translatorFacrotyRef != null) {
            this.translatorFacrotyRef.unregister();
        }
    }
}

