/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.vpls.fdn;

import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.VsiUniResIDParser;
import com.huawei.vmf.adapter.fservice.service.AbstractFdnParser;
import com.huawei.vmf.adapter.fservice.vpls.fdn.IVplsVsiFdnParserExtPoint;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsInstance;
import com.huawei.vmf.adapter.fservice.vpls.model.VplsLdpInst;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.math.BigInteger;

public class VplsVsiFdnParser
extends AbstractFdnParser<VplsInstance> {
    @Override
    public String getFdn(VplsInstance mo) {
        Object vplsVsiFdnParserExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IVplsVsiFdnParserExtPoint.class);
        if (null != vplsVsiFdnParserExtPoit) {
            return ((IVplsVsiFdnParserExtPoint)vplsVsiFdnParserExtPoit).getFdn(mo);
        }
        VplsLdpInst inst = mo.getVplsLdpInst();
        long vsiId = inst == null || inst.getVsiId() == null ? -1L : inst.getVsiId().longValue();
        VsiUniResIDParser parser = new VsiUniResIDParser(mo.getDevID().intValue(), mo.getVrID().intValue(), vsiId, mo.getInstanceName());
        return parser.serialize();
    }

    @Override
    public VplsInstance getIndexMo(String fdn) {
        Object vplsVsiFdnParserExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IVplsVsiFdnParserExtPoint.class);
        if (null != vplsVsiFdnParserExtPoit) {
            return ((IVplsVsiFdnParserExtPoint)vplsVsiFdnParserExtPoit).getIndexMo(fdn);
        }
        VplsInstance vsi = new VplsInstance();
        String moType = FDNUtil.getFdnType((String)fdn);
        if ("VSI".equals(moType)) {
            VsiUniResIDParser parser = new VsiUniResIDParser();
            parser.deserialize(fdn);
            vsi.setDevID(parser.getDevID());
            vsi.setVrID(parser.getVrID());
            vsi.setInstanceName(parser.getVsiName());
            VplsLdpInst inst = new VplsLdpInst();
            inst.setDevID(vsi.getDevID());
            inst.setVrID(vsi.getVrID());
            inst.setInstanceName(vsi.getInstanceName());
            inst.setVplsPwLdpSignal(VplsLdpInst.VPLS_PW_LDP_SIGNAL_ENUM.PW_LDP_SIGNAL);
            inst.setVsiId(BigInteger.valueOf(parser.getVsiID()));
            vsi.setVplsLdpInst(inst);
        }
        return vsi;
    }

    @Override
    public Class<VplsInstance> getMoClass() {
        return VplsInstance.class;
    }
}

