/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.service;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.IFdnParser;
import org.slf4j.Logger;
import org.springframework.util.StringUtils;

public abstract class AbstractFdnParser<T extends VmfMO>
implements IFdnParser<T> {
    private Logger logger = RunLogger.getLogger(this.getClass());

    @Override
    public T getIndexMo(QAsnUniResID resID) {
        VmfMO mo;
        if (null == resID) {
            return null;
        }
        String fdn = StringUtil.globalString((byte[])resID.strFDN);
        if (StringUtils.hasText((String)fdn)) {
            Object indexMo = this.getIndexMo(fdn);
            indexMo.setFdn(fdn);
            return indexMo;
        }
        try {
            mo = (VmfMO)this.getMoClass().newInstance();
        }
        catch (Exception e) {
            this.getLogger().error("parse FDN, new MO error. moClass=" + this.getMoClass().getName());
            return null;
        }
        mo.setDevID(resID.neID);
        mo.setSerialNum(AsnUtil.strValue((byte[])resID.poSerialNum));
        return (T)mo;
    }

    @Override
    public QAsnUniResID getUniResID(T mo) {
        String fdn = this.getFdn(mo);
        QAsnUniResID asn = new QAsnUniResID();
        asn.strFDN = StringUtil.globalByte((String)fdn);
        asn.strMOC = null != fdn && !fdn.isEmpty() ? StringUtil.globalByte((String)FDNUtil.getFdnType((String)fdn)) : StringUtil.globalByte((String)fdn);
        asn.neID = mo.getDevID();
        asn.poSerialNum = AsnUtil.getBytes((String)((VmfMO)mo).getSerialNum());
        return asn;
    }

    @Override
    public void setUniResID(QAsnUniResID resID, T mo) {
        if (null == resID || null == mo) {
            return;
        }
        String fdn = this.getFdn(mo);
        resID.strFDN = StringUtil.globalByte((String)fdn);
        resID.strMOC = StringUtil.globalByte((String)FDNUtil.getFdnType((String)fdn));
        resID.neID = mo.getDevID();
        resID.poSerialNum = AsnUtil.getBytes((String)((VmfMO)mo).getSerialNum());
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

