/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.route.fdn;

import com.huawei.commextend.frameutil.uid.StrLinker;
import com.huawei.commextend.frameutil.uid.StrSpliter;
import com.huawei.commextend.frameutil.uid.StrUIDFactory;
import com.huawei.commextend.frameutil.uid.StrUIDParser;
import com.huawei.vmf.adapter.common.utilty.IpAddressUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.route.model.SrRoute;
import com.huawei.vmf.adapter.fservice.service.AbstractFdnParser;

public class SrRouteFdnParser
extends AbstractFdnParser<SrRoute> {
    public static final String DEFAULT_SR_IFNAME = "Invalid0";
    private static final String NEVRFADAPTER_ROUTE_STATICROUTE_MOC = "STATICROUTE";
    private static final String VRF_FDN_PREFIX = "VRF=";

    @Override
    public String getFdn(SrRoute mo) {
        StrUIDFactory ft = new StrUIDFactory();
        ft.append("NE", (long)mo.getDevID().intValue());
        if (mo.getVrID() > 0) {
            ft.append("VR", (long)mo.getVrID().intValue());
        }
        L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
        L3vpnInstance l3vpnMo = new L3vpnInstance();
        l3vpnMo.setDevID(mo.getDevID());
        l3vpnMo.setVrID(mo.getVrID());
        l3vpnMo.setVrfName(mo.getVrfName());
        String vrfFdn = parser.getFdn(l3vpnMo);
        int index = vrfFdn.indexOf(VRF_FDN_PREFIX);
        if (index != -1) {
            ft.append("VRF", vrfFdn.substring(index + VRF_FDN_PREFIX.length()));
        }
        StrLinker linker = new StrLinker();
        String outIf = mo.getIfName();
        if (outIf == null || DEFAULT_SR_IFNAME.equals(outIf)) {
            outIf = "";
        }
        linker.append(mo.getPrefix()).append(IpAddressUtil.intMask2DotMask((int)mo.getMaskLength().intValue())).append(mo.getNexthop()).append(0L).append(outIf);
        String staticRouteFdn = linker.getStr();
        ft.append(NEVRFADAPTER_ROUTE_STATICROUTE_MOC, staticRouteFdn);
        return ft.getStr();
    }

    @Override
    public SrRoute getIndexMo(String fdn) {
        String l3vpnFdn;
        L3vpnInstanceFdnParser l3vpnInstanceParser;
        L3vpnInstance moIndex;
        SrRoute mo = new SrRoute();
        StrUIDParser parser = new StrUIDParser();
        parser.parse(fdn);
        mo.setDevID((int)parser.intValue("NE"));
        mo.setVrID((int)parser.intValue("VR"));
        StrSpliter spliter = new StrSpliter();
        spliter.parse(parser.strValue(NEVRFADAPTER_ROUTE_STATICROUTE_MOC));
        if (spliter.next()) {
            mo.setPrefix(spliter.strValue());
        }
        if (spliter.next()) {
            mo.setMaskLength((long)IpAddressUtil.dotMask2Int((String)spliter.strValue()) + 0L);
        }
        if (spliter.next()) {
            mo.setNexthop(spliter.strValue());
        }
        if (spliter.next()) {
            spliter.longValue();
        }
        if (spliter.next()) {
            mo.setIfName(spliter.strValue());
            if (StringUtil.isEmpty((String)mo.getIfName())) {
                mo.setIfName(DEFAULT_SR_IFNAME);
            }
        }
        if ((moIndex = (l3vpnInstanceParser = new L3vpnInstanceFdnParser()).getIndexMo(l3vpnFdn = fdn.substring(0, fdn.indexOf(NEVRFADAPTER_ROUTE_STATICROUTE_MOC)))) != null) {
            mo.setVrfName(moIndex.getVrfName());
        }
        return mo;
    }

    @Override
    public Class<SrRoute> getMoClass() {
        return SrRoute.class;
    }
}

