/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.pwe3.fdn;

import com.huawei.vmf.adapter.common.fdn.PwswUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.IVpwsSwitchInstanceFdnParserExtPoint;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchInstance;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsSwitchPw;
import com.huawei.vmf.adapter.fservice.service.AbstractFdnParser;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class VpwsSwitchInstanceFdnParser
extends AbstractFdnParser<VpwsSwitchInstance> {
    private static final Logger LOGGER = RunLogger.getLogger(VpwsSwitchInstanceFdnParser.class);

    @Override
    public String getFdn(VpwsSwitchInstance mo) {
        Object vpwsSwitchInstanceFdnParserExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IVpwsSwitchInstanceFdnParserExtPoint.class);
        if (null != vpwsSwitchInstanceFdnParserExtPoint) {
            return ((IVpwsSwitchInstanceFdnParserExtPoint)vpwsSwitchInstanceFdnParserExtPoint).getFdn(mo);
        }
        PwswUniResIDParser parser = new PwswUniResIDParser();
        parser.setDevID(mo.getDevID().intValue());
        parser.setVrID(mo.getVrID().intValue());
        if (CollectionUtils.isEmpty(mo.getVpwsSwitchPws())) {
            LOGGER.error("mo.getVpwsSwitchPws() is empty.");
            return parser.serialize();
        }
        for (VpwsSwitchPw vpwsSwitchPw : mo.getVpwsSwitchPws()) {
            if (VpwsSwitchPw.PW_ROLE_ENUM.MULTI_HOP_ONE_SIDE_PRIMARY.equals(vpwsSwitchPw.getPwRole())) {
                parser.setLeftPwID(vpwsSwitchPw.getPwId());
                parser.setLeftPeerIP(vpwsSwitchPw.getPeerIp());
                continue;
            }
            if (!VpwsSwitchPw.PW_ROLE_ENUM.MULTI_HOP_OTHER_SIDE_PRIMARY.equals(vpwsSwitchPw.getPwRole())) continue;
            parser.setRightPwID(vpwsSwitchPw.getPwId());
            parser.setRightPeerIP(vpwsSwitchPw.getPeerIp());
        }
        parser.setPwType(mo.getEncapsulateType().intValue());
        return parser.serialize();
    }

    @Override
    public VpwsSwitchInstance getIndexMo(String fdn) {
        Object vpwsSwitchInstanceFdnParserExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IVpwsSwitchInstanceFdnParserExtPoint.class);
        if (null != vpwsSwitchInstanceFdnParserExtPoint) {
            return ((IVpwsSwitchInstanceFdnParserExtPoint)vpwsSwitchInstanceFdnParserExtPoint).getIndexMo(fdn);
        }
        VpwsSwitchInstance mo = new VpwsSwitchInstance();
        mo.setFdn(fdn);
        PwswUniResIDParser parser = new PwswUniResIDParser();
        parser.deserialize(fdn);
        mo.setDevID(parser.getDevID());
        mo.setVrID(parser.getVrID());
        mo.setInstanceType(VpwsSwitchInstance.INSTANCE_TYPE_ENUM.VPWS_SWITCH);
        mo.setEncapsulateType(parser.getPwType());
        ArrayList<VpwsSwitchPw> vpwsSwitchPwList = new ArrayList<VpwsSwitchPw>();
        VpwsSwitchPw vpwsSwitchPw = new VpwsSwitchPw();
        vpwsSwitchPw.setDevID(mo.getDevID());
        vpwsSwitchPw.setVrID(mo.getVrID());
        vpwsSwitchPw.setInstanceType(mo.getInstanceType());
        vpwsSwitchPw.setPwId(parser.getLeftPwID());
        vpwsSwitchPw.setPeerIp(parser.getLeftPeerIP());
        vpwsSwitchPw.setPwType(parser.getPwType());
        vpwsSwitchPw.setPwRole(VpwsSwitchPw.PW_ROLE_ENUM.MULTI_HOP_ONE_SIDE_PRIMARY);
        vpwsSwitchPwList.add(vpwsSwitchPw);
        vpwsSwitchPw = new VpwsSwitchPw();
        vpwsSwitchPw.setDevID(mo.getDevID());
        vpwsSwitchPw.setVrID(mo.getVrID());
        vpwsSwitchPw.setInstanceType(mo.getInstanceType());
        vpwsSwitchPw.setPwId(parser.getRightPwID());
        vpwsSwitchPw.setPeerIp(parser.getRightPeerIP());
        vpwsSwitchPw.setPwType(parser.getPwType());
        vpwsSwitchPw.setPwRole(VpwsSwitchPw.PW_ROLE_ENUM.MULTI_HOP_OTHER_SIDE_PRIMARY);
        vpwsSwitchPwList.add(vpwsSwitchPw);
        if (!CollectionUtils.isEmpty(vpwsSwitchPwList)) {
            mo.setVpwsSwitchPws(vpwsSwitchPwList);
        }
        return mo;
    }

    @Override
    public Class<VpwsSwitchInstance> getMoClass() {
        return VpwsSwitchInstance.class;
    }
}

