/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.pwe3.fdn;

import com.huawei.vmf.adapter.common.fdn.Pwe3UniResIDParser;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.fservice.pwe3.fdn.IVpwsInstanceFdnParserExtPoint;
import com.huawei.vmf.adapter.fservice.pwe3.model.L2vpnAc;
import com.huawei.vmf.adapter.fservice.pwe3.model.VpwsInstance;
import com.huawei.vmf.adapter.fservice.service.AbstractFdnParser;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class VpwsInstanceFdnParser
extends AbstractFdnParser<VpwsInstance> {
    private static final Logger LOGGER = RunLogger.getLogger(VpwsInstanceFdnParser.class);

    @Override
    public String getFdn(VpwsInstance mo) {
        Object vpwsInstanceFdnParserExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IVpwsInstanceFdnParserExtPoint.class);
        if (null != vpwsInstanceFdnParserExtPoint) {
            return ((IVpwsInstanceFdnParserExtPoint)vpwsInstanceFdnParserExtPoint).getFdn(mo);
        }
        Pwe3UniResIDParser parser = new Pwe3UniResIDParser();
        parser.setDevID(mo.getDevID().intValue());
        parser.setVrID(mo.getVrID().intValue());
        parser.setServiceType(mo.getServiceType());
        if (CollectionUtils.isEmpty(mo.getL2vpnAcs()) || mo.getL2vpnAcs().size() > 1) {
            LOGGER.equals("VpwsInstance has no L2vpnAc, or has more L2vpnAcs then 1.");
        } else {
            parser.setInterfaceName(mo.getL2vpnAcs().iterator().next().getInterfaceName());
        }
        return parser.serialize();
    }

    @Override
    public VpwsInstance getIndexMo(String fdn) {
        Object vpwsInstanceFdnParserExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IVpwsInstanceFdnParserExtPoint.class);
        if (null != vpwsInstanceFdnParserExtPoint) {
            return ((IVpwsInstanceFdnParserExtPoint)vpwsInstanceFdnParserExtPoint).getIndexMo(fdn);
        }
        VpwsInstance mo = new VpwsInstance();
        mo.setFdn(fdn);
        Pwe3UniResIDParser parser = new Pwe3UniResIDParser();
        parser.deserialize(fdn);
        mo.setDevID(parser.getDevID());
        mo.setVrID(parser.getVrID());
        mo.setServiceType(parser.getServiceType());
        L2vpnAc l2vpnAc = new L2vpnAc();
        l2vpnAc.setDevID(mo.getDevID());
        l2vpnAc.setVrID(mo.getVrID());
        l2vpnAc.setInterfaceName(parser.getInterfaceName());
        mo.setL2vpnAcs(new ArrayList<L2vpnAc>());
        mo.getL2vpnAcs().add(l2vpnAc);
        return mo;
    }

    @Override
    public Class<VpwsInstance> getMoClass() {
        return VpwsInstance.class;
    }
}

