/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.mpls.fdn;

import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.RsvpTeTunnelUniResIDParser;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.service.AbstractFdnParser;

public class ProGroupRSVPTeTunnelFdnParser
extends AbstractFdnParser<RsvpTeTunnel> {
    private Integer position;

    @Override
    public String getFdn(RsvpTeTunnel mo) {
        RsvpTeTunnelUniResIDParser parser = new RsvpTeTunnelUniResIDParser(mo.getDevID().intValue(), mo.getMplsTunnelEgressLSRId(), mo.getMplsTunnelIngressLSRId(), this.position.intValue(), this.transSignalProtocolToStr(mo.getSignalProtocol()), mo.getMplsTunnelIndex(), mo.getTunnelName(), mo.getVrID().intValue());
        return parser.serialize();
    }

    @Override
    public RsvpTeTunnel getIndexMo(String fdn) {
        RsvpTeTunnel tunnel = new RsvpTeTunnel();
        String moType = FDNUtil.getFdnType((String)fdn);
        if ("TUNNEL".equals(moType)) {
            RsvpTeTunnelUniResIDParser parser = new RsvpTeTunnelUniResIDParser();
            parser.deserialize(fdn);
            tunnel.setDevID(parser.getDevID());
            tunnel.setVrID(parser.getVrID());
            tunnel.setTunnelName(parser.getTunnelName());
            tunnel.setSignalProtocol(this.transSignalProtocolToInt(parser.getSignalProtocol()));
            tunnel.setMplsTunnelIndex(parser.getTunnelID());
            tunnel.setMplsTunnelEgressLSRId(parser.getEgressLSRId());
            tunnel.setMplsTunnelIngressLSRId(parser.getIngressLSRId());
        }
        return tunnel;
    }

    @Override
    public Class<RsvpTeTunnel> getMoClass() {
        return RsvpTeTunnel.class;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    private Integer transSignalProtocolToInt(String strSignalProtocol) {
        Integer intSignalProtocol = null;
        if (strSignalProtocol.equals("CRSTATIC")) {
            intSignalProtocol = RsvpTeTunnel.SIGNAL_PROTOCOL_ENUM.CRSTATIC;
        } else if (strSignalProtocol.equals("RSVPTE")) {
            intSignalProtocol = RsvpTeTunnel.SIGNAL_PROTOCOL_ENUM.RSVPTE;
        }
        return intSignalProtocol;
    }

    private String transSignalProtocolToStr(Integer intSignalProtocol) {
        String strSignalProtocol = null;
        if (RsvpTeTunnel.SIGNAL_PROTOCOL_ENUM.CRSTATIC.equals(intSignalProtocol)) {
            strSignalProtocol = "CRSTATIC";
        } else if (RsvpTeTunnel.SIGNAL_PROTOCOL_ENUM.RSVPTE.equals(intSignalProtocol)) {
            strSignalProtocol = "RSVPTE";
        }
        return strSignalProtocol;
    }
}

