/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.mpls.fdn;

import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.TunnelUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.fservice.mpls.fdn.StaticTunnelFdnParser;
import com.huawei.vmf.adapter.fservice.mpls.model.MplsOamTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.AbstractFdnParser;

public class MplsOamTunnelFdnParser
extends AbstractFdnParser<MplsOamTunnel> {
    private static final String TUNNEL = "Tunnel";

    @Override
    public String getFdn(MplsOamTunnel mo) {
        TunnelUniResIDParser parser = new TunnelUniResIDParser(mo.getDevID().intValue(), mo.getVrID().intValue(), mo.getTunnelName());
        if (null != mo.getTunnelType()) {
            parser.setProtocolType(mo.getTunnelType());
        }
        return parser.serialize();
    }

    @Override
    public MplsOamTunnel getIndexMo(String fdn) {
        MplsOamTunnel mo = new MplsOamTunnel();
        mo.setFdn(fdn);
        String moType = FDNUtil.getFdnType((String)fdn);
        if ("TUNNEL".equals(moType)) {
            TunnelUniResIDParser parser = new TunnelUniResIDParser();
            parser.deserialize(fdn);
            String tunnelName = parser.getTunnelName();
            if (StringUtil.isEmpty((String)tunnelName)) {
                StaticTunnelFdnParser tunnelFdnParser = new StaticTunnelFdnParser();
                StaticTunnel tunnel = (StaticTunnel)tunnelFdnParser.getIndexMo(fdn);
                mo.setTunnelName(this.calStaticTunnelName(tunnel.getIngressLsrId(), tunnel.getTunnelId(), tunnel.getEgressLsrId()));
            } else {
                mo.setTunnelName(parser.getTunnelName());
            }
            mo.setDevID(parser.getDevID());
            mo.setVrID(parser.getVrID());
            mo.setTunnelType(parser.getProtocolType());
        }
        return mo;
    }

    @Override
    public Class<MplsOamTunnel> getMoClass() {
        return MplsOamTunnel.class;
    }

    private String calStaticTunnelName(String ingressLsrId, Integer tunnelId, String egressLsrId) {
        if (StringUtil.isEmpty((String)ingressLsrId) || tunnelId == null || StringUtil.isEmpty((String)egressLsrId)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TUNNEL);
        sb.append(200000 + tunnelId);
        return sb.toString();
    }
}

