/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.lldp.model;

import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Date;
import java.util.regex.Pattern;

public class LldpSysInformation
extends VmfMO {
    public static final String CHASSIS_ID = "chassisId";
    public static final String CHASSIS_ID_SUBTYPE = "chassisIdSubtype";
    public static final String LLDP_UP_TIME = "lldpUpTime";
    public static final String MAN_ADDR = "manAddr";
    public static final String MAN_ADDR_IF_ID = "manAddrIfId";
    public static final String MAN_ADDR_IF_SUBTYPE = "manAddrIfSubtype";
    public static final String MAN_ADDR_LEN = "manAddrLen";
    public static final String MAN_ADDR_OID = "manAddrOid";
    public static final String MAN_ADDR_SUBTYPE = "manAddrSubtype";
    public static final String SYS_CAP_ENABLED = "sysCapEnabled";
    public static final String SYS_CAP_SUPPORTED = "sysCapSupported";
    public static final String SYS_DESC = "sysDesc";
    public static final String SYS_NAME = "sysName";
    private String chassisId;
    private Integer chassisIdSubtype;
    private Date lldpUpTime;
    private String manAddr;
    private Integer manAddrIfId;
    private Integer manAddrIfSubtype;
    private Integer manAddrLen;
    private String manAddrOid;
    private Integer manAddrSubtype;
    private String sysCapEnabled;
    private String sysCapSupported;
    private String sysDesc;
    private String sysName;

    private static String convertChassisID(String chassisID) {
        char[] charArray = chassisID.replaceAll("-", "").toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < charArray.length; ++i) {
            sb.append(charArray[i]);
            if (i % 2 != 1) continue;
            sb.append(":");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String getChassisId() {
        return this.chassisId;
    }

    public Integer getChassisIdSubtype() {
        return this.chassisIdSubtype;
    }

    @Override
    public FeatureName getFeatureName() {
        return FeatureName.LLDP;
    }

    public Date getLldpUpTime() {
        return this.lldpUpTime;
    }

    public String getManAddr() {
        return this.manAddr;
    }

    public Integer getManAddrIfId() {
        return this.manAddrIfId;
    }

    public Integer getManAddrIfSubtype() {
        return this.manAddrIfSubtype;
    }

    public Integer getManAddrLen() {
        return this.manAddrLen;
    }

    public String getManAddrOid() {
        return this.manAddrOid;
    }

    public Integer getManAddrSubtype() {
        return this.manAddrSubtype;
    }

    public String getSysCapEnabled() {
        return this.sysCapEnabled;
    }

    public String getSysCapSupported() {
        return this.sysCapSupported;
    }

    public String getSysDesc() {
        return this.sysDesc;
    }

    public String getSysName() {
        return this.sysName;
    }

    public void setChassisId(String chassisId) {
        this.chassisId = Pattern.compile("(\\d|[a-fA-F]){4}\\-(\\d|[a-fA-F]){4}\\-(\\d|[a-fA-F]){4}").matcher(chassisId).matches() ? LldpSysInformation.convertChassisID(chassisId) : chassisId;
    }

    public void setChassisIdSubtype(Integer chassisIdSubtype) {
        this.chassisIdSubtype = chassisIdSubtype;
    }

    public void setLldpUpTime(Date lldpUpTime) {
        this.lldpUpTime = lldpUpTime;
    }

    public void setManAddr(String manAddr) {
        this.manAddr = manAddr;
    }

    public void setManAddrIfId(Integer manAddrIfId) {
        this.manAddrIfId = manAddrIfId;
    }

    public void setManAddrIfSubtype(Integer manAddrIfSubtype) {
        this.manAddrIfSubtype = manAddrIfSubtype;
    }

    public void setManAddrLen(Integer manAddrLen) {
        this.manAddrLen = manAddrLen;
    }

    public void setManAddrOid(String manAddrOid) {
        this.manAddrOid = manAddrOid;
    }

    public void setManAddrSubtype(Integer manAddrSubtype) {
        this.manAddrSubtype = manAddrSubtype;
    }

    public void setSysCapEnabled(String sysCapEnabled) {
        this.sysCapEnabled = sysCapEnabled;
    }

    public void setSysCapSupported(String sysCapSupported) {
        this.sysCapSupported = sysCapSupported;
    }

    public void setSysDesc(String sysDesc) {
        this.sysDesc = sysDesc;
    }

    public void setSysName(String sysName) {
        this.sysName = sysName;
    }

    public static final class MAN_ADDR_SUBTYPE_ENUM {
        public static final Integer APPLE_TALK = 12;
        public static final Integer AS_NUMBER = 18;
        public static final Integer BANYAN_VINES = 14;
        public static final Integer BBN1822 = 5;
        public static final Integer DECNET_IV = 13;
        public static final Integer DISTINGUISHED_NAME = 17;
        public static final Integer DNS = 16;
        public static final Integer E163 = 7;
        public static final Integer E164 = 8;
        public static final Integer E164WITH_NSAP = 15;
        public static final Integer F69 = 9;
        public static final Integer FIBRE_CHANNEL_WWN = 23;
        public static final Integer FIBRE_CHANNEL_WWPN = 22;
        public static final Integer GWID = 24;
        public static final Integer HDLC = 4;
        public static final Integer IPV4 = 1;
        public static final Integer IPV6 = 2;
        public static final Integer IPX = 11;
        public static final Integer MAC = 6;
        public static final Integer NSAP = 3;
        public static final Integer OTHER = 0;
        public static final Integer X121 = 10;
        public static final Integer XTP_NATIVE_MODE_XTP = 21;
        public static final Integer XTP_OVER_IPV4 = 19;
        public static final Integer XTP_OVER_IPV6 = 20;
    }

    public static final class MAN_ADDR_IF_SUBTYPE_ENUM {
        public static final Integer IF_INDEX = 2;
        public static final Integer OTHER = 0;
        public static final Integer SYSTEM_PORT_NUMBER = 3;
        public static final Integer UNKNOWN = 1;
    }

    public static final class CHASSIS_ID_SUBTYPE_ENUM {
        public static final Integer CHASSIS_COMPONENT = 1;
        public static final Integer INTERFACE_ALIAS = 2;
        public static final Integer INTERFACE_NAME = 6;
        public static final Integer LOCAL = 7;
        public static final Integer MAC_ADDRESS = 4;
        public static final Integer NETWORK_ADDRESS = 5;
        public static final Integer OTHER = 0;
        public static final Integer PORT_COMPONENT = 3;
    }
}

