/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.lldp.model;

import com.huawei.vmf.adapter.fservice.lldp.model.ManagementAddress;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class LldpNeighbor
extends VmfMO {
    public static final String AGGREGATION_PORT_ID = "aggregationPortId";
    public static final String AUTO_NEG_ADVERTISED_CAP = "autoNegAdvertisedCap";
    public static final String AUTO_NEG_ENABLED = "autoNegEnabled";
    public static final String AUTO_NEG_SUPPORTED = "autoNegSupported";
    public static final String CHASSIS_ID = "chassisId";
    public static final String CHASSIS_ID_SUBTYPE = "chassisIdSubtype";
    public static final String DISCOVERED_TIME = "discoveredTime";
    public static final String EXPIRED_TIME = "expiredTime";
    public static final String IF_NAME = "ifName";
    public static final String IREM_DEV_ID = "iremDevID";
    public static final String LINK_AGGREGATION_ENABLED = "linkAggregationEnabled";
    public static final String LINK_AGGREGATION_SUPPORTED = "linkAggregationSupported";
    public static final String MANAGEMENT_ADDRESSS = "managementAddresss";
    public static final String MAXIMUM_FRAME_SIZE = "maximumFrameSize";
    public static final String NB_INDEX = "nbIndex";
    public static final String OPER_MAU_TYPE = "operMauType";
    public static final String PORT_DESCRIPTION = "portDescription";
    public static final String PORT_ID = "portId";
    public static final String PORT_ID_SUBTYPE = "portIdSubtype";
    public static final String PORT_VLAN_ID = "portVlanId";
    public static final String SYSTEM_CAPABILITIES_ENABLED = "systemCapabilitiesEnabled";
    public static final String SYSTEM_CAPABILITIES_SUPPORTED = "systemCapabilitiesSupported";
    public static final String SYSTEM_DESCRIPTION = "systemDescription";
    public static final String SYSTEM_NAME = "systemName";
    private Integer aggregationPortId;
    private String autoNegAdvertisedCap;
    private Integer autoNegEnabled;
    private Integer autoNegSupported;
    private String chassisId;
    private Integer chassisIdSubtype;
    private Date discoveredTime;
    private Integer expiredTime;
    private String ifName;
    private Integer iremDevID;
    private Integer linkAggregationEnabled;
    private Integer linkAggregationSupported;
    private Collection<ManagementAddress> managementAddresss;
    private Integer maximumFrameSize;
    private Long nbIndex;
    private Integer operMauType;
    private String portDescription;
    private String portId;
    private Integer portIdSubtype;
    private Integer portVlanId;
    private String systemCapabilitiesEnabled;
    private String systemCapabilitiesSupported;
    private String systemDescription;
    private String systemName;

    private static String convertChassisID(String chassisID) {
        char[] charArray = chassisID.replaceAll("-", "").toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < charArray.length; ++i) {
            sb.append(charArray[i]);
            if (i % 2 != 1) continue;
            sb.append(":");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public void addManagementAddresss(Collection<ManagementAddress> managementAddresss) {
        if (CollectionUtils.isEmpty(managementAddresss)) {
            return;
        }
        if (null == this.managementAddresss) {
            this.managementAddresss = new ArrayList<ManagementAddress>();
        }
        this.managementAddresss.addAll(managementAddresss);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LldpNeighbor other = (LldpNeighbor)obj;
        return ObjectUtils.equals((Object)this.ifName, (Object)other.ifName) && ObjectUtils.equals((Object)this.nbIndex, (Object)other.nbIndex);
    }

    public Integer getAggregationPortId() {
        return this.aggregationPortId;
    }

    public String getAutoNegAdvertisedCap() {
        return this.autoNegAdvertisedCap;
    }

    public Integer getAutoNegEnabled() {
        return this.autoNegEnabled;
    }

    public Integer getAutoNegSupported() {
        return this.autoNegSupported;
    }

    public String getChassisId() {
        return this.chassisId;
    }

    public Integer getChassisIdSubtype() {
        return this.chassisIdSubtype;
    }

    public Date getDiscoveredTime() {
        return this.discoveredTime;
    }

    public Integer getExpiredTime() {
        return this.expiredTime;
    }

    @Override
    public FeatureName getFeatureName() {
        return FeatureName.LLDP;
    }

    public String getIfName() {
        return this.ifName;
    }

    public Integer getIremDevID() {
        return this.iremDevID;
    }

    public Integer getLinkAggregationEnabled() {
        return this.linkAggregationEnabled;
    }

    public Integer getLinkAggregationSupported() {
        return this.linkAggregationSupported;
    }

    public Collection<ManagementAddress> getManagementAddresss() {
        return this.managementAddresss;
    }

    public Integer getMaximumFrameSize() {
        return this.maximumFrameSize;
    }

    public Long getNbIndex() {
        return this.nbIndex;
    }

    public Integer getOperMauType() {
        return this.operMauType;
    }

    public String getPortDescription() {
        return this.portDescription;
    }

    public String getPortId() {
        return this.portId;
    }

    public Integer getPortIdSubtype() {
        return this.portIdSubtype;
    }

    public Integer getPortVlanId() {
        return this.portVlanId;
    }

    public String getSystemCapabilitiesEnabled() {
        return this.systemCapabilitiesEnabled;
    }

    public String getSystemCapabilitiesSupported() {
        return this.systemCapabilitiesSupported;
    }

    public String getSystemDescription() {
        return this.systemDescription;
    }

    public String getSystemName() {
        return this.systemName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ifName == null ? 0 : this.ifName.hashCode());
        result = 31 * result + (this.nbIndex == null ? 0 : this.nbIndex.hashCode());
        return result;
    }

    public void setAggregationPortId(Integer aggregationPortId) {
        this.aggregationPortId = aggregationPortId;
    }

    public void setAutoNegAdvertisedCap(String autoNegAdvertisedCap) {
        this.autoNegAdvertisedCap = autoNegAdvertisedCap;
    }

    public void setAutoNegEnabled(Integer autoNegEnabled) {
        this.autoNegEnabled = autoNegEnabled;
    }

    public void setAutoNegSupported(Integer autoNegSupported) {
        this.autoNegSupported = autoNegSupported;
    }

    public void setChassisId(String chassisId) {
        this.chassisId = Pattern.compile("(\\d|[a-fA-F]){4}\\-(\\d|[a-fA-F]){4}\\-(\\d|[a-fA-F]){4}").matcher(chassisId).matches() ? LldpNeighbor.convertChassisID(chassisId) : chassisId;
    }

    public void setChassisIdSubtype(Integer chassisIdSubtype) {
        this.chassisIdSubtype = chassisIdSubtype;
    }

    public void setDiscoveredTime(Date discoveredTime) {
        this.discoveredTime = discoveredTime;
    }

    public void setExpiredTime(Integer expiredTime) {
        this.expiredTime = expiredTime;
    }

    public void setIfName(String ifName) {
        this.ifName = ifName;
    }

    public void setIremDevID(Integer iremDevID) {
        this.iremDevID = iremDevID;
    }

    public void setLinkAggregationEnabled(Integer linkAggregationEnabled) {
        this.linkAggregationEnabled = linkAggregationEnabled;
    }

    public void setLinkAggregationSupported(Integer linkAggregationSupported) {
        this.linkAggregationSupported = linkAggregationSupported;
    }

    public void setManagementAddresss(Collection<ManagementAddress> managementAddresss) {
        this.managementAddresss = managementAddresss;
    }

    public void setMaximumFrameSize(Integer maximumFrameSize) {
        this.maximumFrameSize = maximumFrameSize;
    }

    public void setNbIndex(Long nbIndex) {
        this.nbIndex = nbIndex;
    }

    public void setOperMauType(Integer operMauType) {
        this.operMauType = operMauType;
    }

    public void setPortDescription(String portDescription) {
        this.portDescription = portDescription;
    }

    public void setPortId(String portId) {
        this.portId = portId;
    }

    public void setPortIdSubtype(Integer portIdSubtype) {
        this.portIdSubtype = portIdSubtype;
    }

    public void setPortVlanId(Integer portVlanId) {
        this.portVlanId = portVlanId;
    }

    public void setSystemCapabilitiesEnabled(String systemCapabilitiesEnabled) {
        this.systemCapabilitiesEnabled = systemCapabilitiesEnabled;
    }

    public void setSystemCapabilitiesSupported(String systemCapabilitiesSupported) {
        this.systemCapabilitiesSupported = systemCapabilitiesSupported;
    }

    public void setSystemDescription(String systemDescription) {
        this.systemDescription = systemDescription;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public static final class PORT_ID_SUBTYPE_ENUM {
        public static final Integer AGENT_CIRCUIT_ID = 6;
        public static final Integer INTERFACE_ALIAS = 1;
        public static final Integer INTERFACE_NAME = 5;
        public static final Integer LOCAL = 7;
        public static final Integer MAC_ADDRESS = 3;
        public static final Integer NETWORK_ADDRESS = 4;
        public static final Integer OTHER = 0;
        public static final Integer PORT_COMPONENT = 2;
    }

    public static final class OPER_MAU_TYPE_ENUM {
        public static final Integer DOT3_MAU_TYPE_AUI = 17;
        public static final Integer DOT3_MAU_TYPE_FOIRL = 19;
        public static final Integer DOT3_MAU_TYPE10_BASE_FB = 23;
        public static final Integer DOT3_MAU_TYPE10_BASE_FL = 24;
        public static final Integer DOT3_MAU_TYPE10_BASE_FLFD = 29;
        public static final Integer DOT3_MAU_TYPE10_BASE_FLHD = 28;
        public static final Integer DOT3_MAU_TYPE10_BASE_FP = 22;
        public static final Integer DOT3_MAU_TYPE10_BASE_T = 21;
        public static final Integer DOT3_MAU_TYPE10_BASE_TFD = 27;
        public static final Integer DOT3_MAU_TYPE10_BASE_THD = 26;
        public static final Integer DOT3_MAU_TYPE10_BASE2 = 20;
        public static final Integer DOT3_MAU_TYPE10_BASE5 = 18;
        public static final Integer DOT3_MAU_TYPE10_BROAD36 = 25;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_ER = 9;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_EW = 13;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_LR = 10;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_LW = 14;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_LX4 = 7;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_R = 8;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_SR = 11;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_SW = 15;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_W = 12;
        public static final Integer DOT3_MAU_TYPE10_GIG_BASE_X = 6;
        public static final Integer DOT3_MAU_TYPE100_BASE_FXFD = 34;
        public static final Integer DOT3_MAU_TYPE100_BASE_FXHD = 33;
        public static final Integer DOT3_MAU_TYPE100_BASE_T2_FD = 36;
        public static final Integer DOT3_MAU_TYPE100_BASE_T2_HD = 35;
        public static final Integer DOT3_MAU_TYPE100_BASE_T4 = 30;
        public static final Integer DOT3_MAU_TYPE100_BASE_TXFD = 32;
        public static final Integer DOT3_MAU_TYPE100_BASE_TXHD = 31;
        public static final Integer DOT3_MAU_TYPE1000_BASE_CXFD = 3;
        public static final Integer DOT3_MAU_TYPE1000_BASE_CXHD = 2;
        public static final Integer DOT3_MAU_TYPE1000_BASE_LXFD = 40;
        public static final Integer DOT3_MAU_TYPE1000_BASE_LXHD = 39;
        public static final Integer DOT3_MAU_TYPE1000_BASE_SXFD = 1;
        public static final Integer DOT3_MAU_TYPE1000_BASE_SXHD = 0;
        public static final Integer DOT3_MAU_TYPE1000_BASE_TFD = 5;
        public static final Integer DOT3_MAU_TYPE1000_BASE_THD = 4;
        public static final Integer DOT3_MAU_TYPE1000_BASE_XFD = 38;
        public static final Integer DOT3_MAU_TYPE1000_BASE_XHD = 37;
        public static final Integer UNKNOWN = 16;
    }

    public static final class LINK_AGGREGATION_SUPPORTED_ENUM {
        public static final Integer NO = 0;
        public static final Integer YES = 1;
    }

    public static final class LINK_AGGREGATION_ENABLED_ENUM {
        public static final Integer NO = 0;
        public static final Integer YES = 1;
    }

    public static final class CHASSIS_ID_SUBTYPE_ENUM {
        public static final Integer CHASSIS_COMPONENT = 1;
        public static final Integer INTERFACE_ALIAS = 2;
        public static final Integer INTERFACE_NAME = 6;
        public static final Integer LOCAL = 7;
        public static final Integer MAC_ADDRESS = 4;
        public static final Integer NETWORK_ADDRESS = 5;
        public static final Integer OTHER = 0;
        public static final Integer PORT_COMPONENT = 3;
    }

    public static final class AUTO_NEG_SUPPORTED_ENUM {
        public static final Integer NO = 0;
        public static final Integer YES = 1;
    }

    public static final class AUTO_NEG_ENABLED_ENUM {
        public static final Integer NO = 0;
        public static final Integer YES = 1;
    }
}

