/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.inventory.model;

import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import org.springframework.util.ObjectUtils;

public class InnerLink
extends VmfMO {
    public static final String ALARM_STATE = "alarmState";
    public static final String LEFT_CHASSIS_TYPE = "leftChassisType";
    public static final String LINK_TYPE = "linkType";
    public static final String OPER_STATUS = "operStatus";
    public static final String RIGHT_CHASSIS_TYPE = "rightChassisType";
    private Integer alarmState;
    private String leftChassisPosition;
    private Integer leftChassisType;
    private String linkName;
    private Integer linkType;
    private Integer operStatus;
    private String rightChassisPosition;
    private Integer rightChassisType;

    public InnerLink() {
    }

    public InnerLink(InnerLink mo) {
        if (mo == null) {
            return;
        }
        this.linkName = mo.getLinkName();
        this.linkType = mo.getLinkType();
        this.leftChassisPosition = mo.getLeftChassisPosition();
        this.leftChassisType = mo.getLeftChassisType();
        this.rightChassisPosition = mo.getRightChassisPosition();
        this.rightChassisType = mo.getRightChassisType();
        this.alarmState = mo.getAlarmState();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InnerLink other = (InnerLink)obj;
        return ObjectUtils.nullSafeEquals((Object)this.linkName, (Object)other.linkName);
    }

    public Integer getAlarmState() {
        return this.alarmState;
    }

    @Override
    public FeatureName getFeatureName() {
        return FeatureName.DEVM;
    }

    public String getInnerLinkDN() {
        StringBuffer linkIDBuffer = new StringBuffer();
        linkIDBuffer.append("PHY:");
        linkIDBuffer.append(this.getDevID());
        linkIDBuffer.append(':');
        linkIDBuffer.append(this.getLinkType());
        linkIDBuffer.append(':');
        linkIDBuffer.append(this.getLeftChassisPosition());
        linkIDBuffer.append(':');
        linkIDBuffer.append(this.getRightChassisPosition());
        return linkIDBuffer.toString();
    }

    public String getLeftChassisPosition() {
        return this.leftChassisPosition;
    }

    public Integer getLeftChassisType() {
        return this.leftChassisType;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public Integer getLinkType() {
        return this.linkType;
    }

    public Integer getOperStatus() {
        return this.operStatus;
    }

    public String getRightChassisPosition() {
        return this.rightChassisPosition;
    }

    public Integer getRightChassisType() {
        return this.rightChassisType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.linkName == null ? 0 : this.linkName.hashCode());
        return result;
    }

    public void setAlarmState(Integer alarmState) {
        this.alarmState = alarmState;
    }

    public void setLeftChassisPosition(String leftChassisPosition) {
        this.leftChassisPosition = leftChassisPosition;
    }

    public void setLeftChassisType(Integer leftChassisType) {
        this.leftChassisType = leftChassisType;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public void setLinkType(Integer linkType) {
        this.linkType = linkType;
    }

    public void setOperStatus(Integer operStatus) {
        this.operStatus = operStatus;
    }

    public void setRightChassisPosition(String rightChassisPosition) {
        this.rightChassisPosition = rightChassisPosition;
    }

    public void setRightChassisType(Integer rightChassisType) {
        this.rightChassisType = rightChassisType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InnerLink [devID=");
        builder.append(this.getDevID());
        builder.append(", linkName=");
        builder.append(this.linkName);
        builder.append(", linkType=");
        builder.append(this.linkType);
        builder.append(", leftChassisPosition=");
        builder.append(this.leftChassisPosition);
        builder.append(", leftChassisType=");
        builder.append(this.leftChassisType);
        builder.append(", rightChassisPosition=");
        builder.append(this.rightChassisPosition);
        builder.append(", rightChassisType=");
        builder.append(this.rightChassisType);
        builder.append(", operState=");
        builder.append(this.getOperStatus());
        builder.append(", alarmState=");
        builder.append(this.alarmState);
        builder.append("]");
        return builder.toString();
    }

    public static final class RIGHT_CHASSIS_TYPE_ENUM {
        public static final Integer CENTRAL_CHASSIS = 1;
        public static final Integer LINE_CHASSIS = 2;
        public static final Integer OTHER = 0;
    }

    public static final class OPER_STATE_ENUM {
        public static final Integer FAULT = 2;
        public static final Integer NORMAL = 0;
        public static final Integer PARTIAL_FAULT = 1;
    }

    public static final class LINK_TYPE_ENUM {
        public static final Integer CONTROL_CHANNEL = 1;
        public static final Integer FORWARD_CHANNEL = 3;
        public static final Integer MONITOR_CHANNEL = 2;
        public static final Integer OTHER = 0;
    }

    public static final class LEFT_CHASSIS_TYPE_ENUM {
        public static final Integer CENTRAL_CHASSIS = 1;
        public static final Integer LINE_CHASSIS = 2;
        public static final Integer OTHER = 0;
    }

    public static final class ALARM_STATE_ENUM {
        public static final Integer FAULT = 2;
        public static final Integer NORMAL = 0;
        public static final Integer PARTIAL_FAULT = 1;
    }
}

