/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.ifm.fdn;

import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.LagUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.NEUniResIDParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Lag;
import com.huawei.vmf.adapter.fservice.service.AbstractFdnParser;

public class LagFdnParser
extends AbstractFdnParser<Lag> {
    private static final int ADMIN_VR = 0;

    @Override
    public String getFdn(Lag mo) {
        if (null == mo.getDevID() || null == mo.getLagID()) {
            this.getLogger().debug("LagFdnParser getFdn is failed! DevID is null or lagID is null");
            return null;
        }
        LagUniResIDParser lagParser = new LagUniResIDParser(mo.getDevID().intValue(), Integer.valueOf(65539), mo.getLagID().intValue());
        return lagParser.serialize();
    }

    @Override
    public Lag getIndexMo(String fdn) {
        if (fdn == null || fdn.equals("")) {
            return null;
        }
        Lag index = new Lag();
        String moType = FDNUtil.getFdnType((String)fdn);
        index.setFdn(fdn);
        if ("NE".equals(moType)) {
            NEUniResIDParser parser = new NEUniResIDParser();
            parser.deserialize(fdn);
            index.setDevID(parser.getDevID());
            index.setVrID(0);
        } else if ("LP".equals(moType)) {
            LagUniResIDParser parser = new LagUniResIDParser();
            parser.deserialize(fdn);
            index.setDevID(parser.getDevID());
            index.setVrID(0);
            index.setLagID((int)parser.getPortID());
        } else {
            return null;
        }
        return index;
    }

    @Override
    public Class<Lag> getMoClass() {
        return Lag.class;
    }
}

