/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.fservice.ifm.fdn;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_common.QAsnUniResIDList;
import com.huawei.vmf.adapter.common.fdn.FDNUtil;
import com.huawei.vmf.adapter.common.fdn.InterfaceUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.NEUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.SubInterfaceResIDParser;
import com.huawei.vmf.adapter.common.global.U2KInterfaceTypeMapping;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.fservice.ifm.fdn.IInterfaceFdnParserExtPoit;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.service.AbstractFdnParser;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class InterfaceFdnParser
extends AbstractFdnParser<Interface> {
    private static final int ADMIN_VR = 0;
    private static final Pattern IF_POSITION_PATTERN = Pattern.compile("([\\d]*[/]?[\\d]+/[\\d]+/[\\d]+)");

    public List<Integer> getDevIDList(QAsnUniResIDList fdnLst) {
        ArrayList<Integer> devIDs = new ArrayList<Integer>();
        for (QAsnUniResID asnUniResID : fdnLst) {
            if (devIDs.contains(asnUniResID.neID)) continue;
            devIDs.add(asnUniResID.neID);
        }
        return devIDs;
    }

    @Override
    public String getFdn(Interface mo) {
        Object interfaceFdnParserExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceFdnParserExtPoit.class);
        if (null != interfaceFdnParserExtPoit) {
            return ((IInterfaceFdnParserExtPoit)interfaceFdnParserExtPoit).getFdn(mo);
        }
        Object parser = null;
        int type = U2KInterfaceTypeMapping.getInterfaceTypeFromIfName((String)mo.getIfName());
        parser = U2KInterfaceTypeMapping.getPhysicalInterfaceType().contains(type) ? new PortUniResIDParser(mo.getDevID().intValue(), mo.getIfName()) : (U2KInterfaceTypeMapping.getLogicalInterfaceType().contains(type) ? new InterfaceUniResIDParser(mo.getDevID().intValue(), mo.getVrID(), mo.getIfName()) : new SubInterfaceResIDParser(mo.getDevID().intValue(), mo.getVrID().intValue(), mo.getIfName()));
        return parser.serialize();
    }

    public Interface getIndexMo(String fdn, Map<String, Interface> fdnToInfMap) {
        if (fdn == null || fdn.equals("")) {
            return null;
        }
        Object interfaceFdnParserExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceFdnParserExtPoit.class);
        if (null != interfaceFdnParserExtPoit) {
            return ((IInterfaceFdnParserExtPoit)interfaceFdnParserExtPoit).getIndexMo(fdn, fdnToInfMap);
        }
        return this.getIndexMo(fdn);
    }

    @Override
    public Interface getIndexMo(String fdn) {
        if (fdn == null || fdn.equals("")) {
            return null;
        }
        Object interfaceFdnParserExtPoit = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInterfaceFdnParserExtPoit.class);
        if (null != interfaceFdnParserExtPoit) {
            return ((IInterfaceFdnParserExtPoit)interfaceFdnParserExtPoit).getIndexMo(fdn);
        }
        Interface index = new Interface();
        String moType = FDNUtil.getFdnType((String)fdn);
        index.setFdn(fdn);
        if ("NE".equals(moType)) {
            NEUniResIDParser parser = new NEUniResIDParser();
            parser.deserialize(fdn);
            index.setDevID(parser.getDevID());
            index.setVrID(0);
        } else if ("PP".equals(moType)) {
            PortUniResIDParser parser = new PortUniResIDParser();
            parser.deserialize(fdn);
            index.setDevID(parser.getDevID());
            index.setVrID(0);
            index.setIfName(parser.getCliName());
        } else if ("LP".equals(moType)) {
            InterfaceUniResIDParser parser = new InterfaceUniResIDParser();
            parser.deserialize(fdn);
            index.setDevID(parser.getDevID());
            index.setVrID(parser.getVrID());
            index.setIfName(parser.getIfName());
        } else {
            SubInterfaceResIDParser parser = new SubInterfaceResIDParser();
            parser.deserialize(fdn);
            this.parseSubInterface(parser, index);
        }
        return index;
    }

    public List<Interface> getIndexMos(Collection<QAsnUniResID> fdns) {
        ArrayList<Interface> filterMos = new ArrayList<Interface>();
        for (QAsnUniResID asn : fdns) {
            Interface mo = this.getIndexMo(StringUtil.globalString((byte[])asn.strFDN));
            if (null == mo) continue;
            filterMos.add(mo);
        }
        return filterMos;
    }

    @Override
    public Class<Interface> getMoClass() {
        return Interface.class;
    }

    private void parseSubInterface(SubInterfaceResIDParser parser, Interface index) {
        String parentIfName = null;
        index.setIfNumber(String.valueOf(parser.getSubIfNum()));
        if (parser.getPpUniResParser() != null) {
            parentIfName = parser.getPpUniResParser().getCliName();
            index.setDevID(parser.getPpUniResParser().getDevID());
            index.setIfParentIfName(parentIfName);
            index.setVrID(0);
        } else if (parser.getLpUniResParser() != null) {
            parentIfName = parser.getLpUniResParser().getIfName();
            index.setDevID(parser.getLpUniResParser().getDevID());
            index.setVrID(parser.getLpUniResParser().getVrID());
            index.setIfParentIfName(parentIfName);
        }
        if (parentIfName != null) {
            index.setIfName(parentIfName + "." + index.getIfNumber());
        }
    }
}

