/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartSPRingTracertReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartSPRingTracertRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.RingUniResIDParser;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.translation.asn.QAsnSPRingTracertParaTranslator;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartRingTrace;

public class StartSPRingTracertTask
extends AbstractQTask<QAsnStartSPRingTracertReq, QAsnStartSPRingTracertRsp> {
    protected void executeTask(QAsnStartSPRingTracertReq req, QAsnStartSPRingTracertRsp rsp, Task task) {
        IAsnTranslationContext asnTransContext = DiagCommon.getInstance().getContext();
        int iResID = DiagCommon.getInstance().assignResID();
        String testName = DiagnoseUtil.combineTestName(iResID);
        StartRingTrace startRingTraceMo = this.setStartRingTrace(req, asnTransContext, testName);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID, startRingTraceMo);
        DiagSchedulerMsg oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
        DiagSchedulerCache.getInstance().push(oDiagMsg);
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartRingTrace setStartRingTrace(QAsnStartSPRingTracertReq req, IAsnTranslationContext asnTransContext, String testName) {
        StartRingTrace startRingTraceMo = new StartRingTrace();
        startRingTraceMo.setTestName(testName);
        startRingTraceMo.setDevID(Integer.valueOf(req.oRingKey.neID));
        if (!new String(req.oRingKey.strFDN).isEmpty()) {
            startRingTraceMo.setFdn(new String(req.oRingKey.strFDN));
            RingUniResIDParser ringIdParser = new RingUniResIDParser();
            ringIdParser.deserialize(new String(req.oRingKey.strFDN));
            startRingTraceMo.setRingId(Integer.valueOf(ringIdParser.getRingID()));
        }
        QAsnSPRingTracertParaTranslator translator = new QAsnSPRingTracertParaTranslator();
        try {
            translator.decode(req.param, startRingTraceMo, asnTransContext);
        }
        catch (VMFException e) {
            this.getLogger().error("StartRingTrace setStartRingTrace() is error.", (Throwable)e);
        }
        return startRingTraceMo;
    }

    private TestCaseInfo push(QAsnStartSPRingTracertReq req, Task task, int iResID, StartRingTrace startRingTraceMo) {
        TestCaseInfo testCaseInfo = new TestCaseInfo();
        testCaseInfo.setTask(task);
        testCaseInfo.setDevID(req.oRingKey.neID);
        testCaseInfo.setFdn(new String(req.oRingKey.strFDN));
        testCaseInfo.setSessionID(new String(req.sessionID));
        testCaseInfo.setTestName("NEDiag" + iResID);
        testCaseInfo.setResID(iResID);
        testCaseInfo.setTestType(1010);
        int iPacketCount = 3;
        if (null != req.param.poEchoRequest && -1 != req.param.poEchoRequest) {
            iPacketCount = req.param.poEchoRequest;
        }
        testCaseInfo.setProbeCount(iPacketCount);
        testCaseInfo.setiTimeOut(DiagCommon.getInstance().getTraceTimeOut(1, req.param.ttl, iPacketCount, req.param.replyTimeOut));
        testCaseInfo.setGetFirstTime(DiagCommon.getInstance().getTraceResultTime(iPacketCount, req.param.replyTimeOut));
        testCaseInfo.setGetIntevalTime(DiagCommon.getInstance().getTraceResultTime(iPacketCount, req.param.replyTimeOut));
        testCaseInfo.setMoRingTrace(startRingTraceMo);
        return testCaseInfo;
    }
}

