/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartSPRingPingReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartSPRingPingRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.RingUniResIDParser;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.translation.asn.QAsnSPRingPingParaTranslator;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartRingPing;

public class StartSPRingPingTask
extends AbstractQTask<QAsnStartSPRingPingReq, QAsnStartSPRingPingRsp> {
    protected void executeTask(QAsnStartSPRingPingReq req, QAsnStartSPRingPingRsp rsp, Task task) {
        IAsnTranslationContext asnTranslationCtx = DiagCommon.getInstance().getContext();
        int iResID = DiagCommon.getInstance().assignResID();
        String testName = DiagnoseUtil.combineTestName(iResID);
        StartRingPing startRingPingMo = this.setStartRingPing(req, asnTranslationCtx, testName);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID, startRingPingMo);
        DiagSchedulerMsg oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
        DiagSchedulerCache.getInstance().push(oDiagMsg);
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartRingPing setStartRingPing(QAsnStartSPRingPingReq req, IAsnTranslationContext asnTranslationCtx, String testName) {
        StartRingPing startRingPingMo = new StartRingPing();
        startRingPingMo.setTestName(testName);
        startRingPingMo.setDevID(Integer.valueOf(req.oRingKey.neID));
        if (!new String(req.oRingKey.strFDN).isEmpty()) {
            startRingPingMo.setFdn(new String(req.oRingKey.strFDN));
            RingUniResIDParser ringIdParser = new RingUniResIDParser();
            ringIdParser.deserialize(new String(req.oRingKey.strFDN));
            startRingPingMo.setRingId(Long.valueOf(ringIdParser.getRingID()));
        }
        QAsnSPRingPingParaTranslator translator = new QAsnSPRingPingParaTranslator();
        try {
            translator.decode(req.param, startRingPingMo, asnTranslationCtx);
        }
        catch (VMFException e) {
            this.getLogger().error("decode startRingPing failed", (Object[])e.getStackTrace());
        }
        return startRingPingMo;
    }

    private TestCaseInfo push(QAsnStartSPRingPingReq req, Task task, int iResID, StartRingPing startRingPingMo) {
        TestCaseInfo testCaseInfo = new TestCaseInfo();
        testCaseInfo.setTask(task);
        testCaseInfo.setDevID(req.oRingKey.neID);
        testCaseInfo.setProbeCount(req.param.echoRequest);
        testCaseInfo.setFdn(new String(req.oRingKey.strFDN));
        testCaseInfo.setSessionID(new String(req.sessionID));
        testCaseInfo.setTestName("NEDiag" + iResID);
        testCaseInfo.setResID(iResID);
        testCaseInfo.setTestType(1009);
        testCaseInfo.setiTimeOut(DiagCommon.getInstance().getPingTimeOut(req.param.echoRequest, req.param.sendDistant, req.param.replyTimeOut));
        testCaseInfo.setGetFirstTime(DiagCommon.getInstance().getFirstPingResultTime(req.param.echoRequest, req.param.sendDistant));
        testCaseInfo.setGetIntevalTime(DiagCommon.getInstance().getPingResultInterval(req.param.replyTimeOut));
        testCaseInfo.setMoRingPing(startRingPingMo);
        return testCaseInfo;
    }
}

