/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartPwe3PwTracertReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartPwe3PwTracertRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.PwUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.VplsPwUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.IpAddressUtil;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagNoReplyScheduleCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.translation.asn.QAsnPwTracertConfInfoTranslator;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartPwe3Trace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartVplsTrace;
import java.net.UnknownHostException;

public class StartPwe3PwTracertTask
extends AbstractQTask<QAsnStartPwe3PwTracertReq, QAsnStartPwe3PwTracertRsp> {
    protected void executeTask(QAsnStartPwe3PwTracertReq req, QAsnStartPwe3PwTracertRsp rsp, Task task) {
        IAsnTranslationContext asnTranslationCtx = DiagCommon.getInstance().getContext();
        VplsPwUniResIDParser vplsParser = new VplsPwUniResIDParser();
        vplsParser.deserialize(new String(req.pwTracertConf.pwKey.strFDN));
        if (vplsParser.getVsiName().isEmpty()) {
            this.decodeStartPwe3Trace(req, rsp, asnTranslationCtx, task);
        } else {
            this.decodeStartVplsTrace(req, rsp, asnTranslationCtx, vplsParser, task);
        }
    }

    private void decodeStartPwe3Trace(QAsnStartPwe3PwTracertReq req, QAsnStartPwe3PwTracertRsp rsp, IAsnTranslationContext asnTranslationContext, Task task) {
        int iResID = DiagCommon.getInstance().assignResID();
        StartPwe3Trace startPwe3TraceMo = this.setStartPwe3Trace(req, asnTranslationContext, iResID);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID);
        testCaseInfo.setMoPwe3Trace(startPwe3TraceMo);
        testCaseInfo.setTestType(15);
        DiagSchedulerMsg oDiagMsg = null;
        if (null != req.pwTracertConf.tracertParam.replyType && 1 == req.pwTracertConf.tracertParam.replyType) {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, true);
            DiagNoReplyScheduleCache.getInstance().push(oDiagMsg);
        } else {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
            DiagSchedulerCache.getInstance().push(oDiagMsg);
        }
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartPwe3Trace setStartPwe3Trace(QAsnStartPwe3PwTracertReq req, IAsnTranslationContext asnTranslationContext, int iResID) {
        StartPwe3Trace startPwe3TraceMo = new StartPwe3Trace();
        startPwe3TraceMo.setTestName(DiagnoseUtil.combineTestName(iResID));
        startPwe3TraceMo.setDevID(Integer.valueOf(req.pwTracertConf.pwKey.neID));
        startPwe3TraceMo.setFdn(new String(req.pwTracertConf.pwKey.strFDN));
        if (null != req.pwTracertConf.pwKey.poSerialNum) {
            startPwe3TraceMo.setSerialNum(new String(req.pwTracertConf.pwKey.poSerialNum));
        }
        PwUniResIDParser pwParser = new PwUniResIDParser();
        pwParser.deserialize(new String(req.pwTracertConf.pwKey.strFDN));
        startPwe3TraceMo.setPwId(pwParser.getPwID());
        startPwe3TraceMo.setPwType(Integer.valueOf(pwParser.getPwType()));
        if (null != req.pwTracertConf.tracertParam.replyType) {
            startPwe3TraceMo.setReplyMode(req.pwTracertConf.tracertParam.replyType);
            if (StartPwe3Trace.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.pwTracertConf.tracertParam.replyType.intValue()) {
                startPwe3TraceMo.setTestIndex(Long.valueOf(iResID));
            }
        }
        QAsnPwTracertConfInfoTranslator translator = new QAsnPwTracertConfInfoTranslator();
        try {
            translator.decode(req.pwTracertConf, startPwe3TraceMo, asnTranslationContext);
        }
        catch (VMFException e) {
            this.getLogger().error("startPwe3Trace execute failed", (Throwable)e);
        }
        return startPwe3TraceMo;
    }

    private TestCaseInfo push(QAsnStartPwe3PwTracertReq req, Task task, int iResID) {
        TestCaseInfo testCaseInfo = new TestCaseInfo();
        testCaseInfo.setTask(task);
        testCaseInfo.setDevID(req.pwTracertConf.neID);
        int iProbeCount = 3;
        if (-1 != req.pwTracertConf.tracertParam.echoRequest) {
            iProbeCount = req.pwTracertConf.tracertParam.echoRequest;
        }
        testCaseInfo.setProbeCount(iProbeCount);
        testCaseInfo.setFdn(new String(req.pwTracertConf.pwKey.strFDN));
        testCaseInfo.setSessionID(new String(req.sessionID));
        testCaseInfo.setTestName(DiagnoseUtil.combineTestName(iResID));
        testCaseInfo.setResID(iResID);
        testCaseInfo.setKeyID(String.valueOf(iResID));
        testCaseInfo.setPingOrTraceType(2);
        testCaseInfo.setMaxTtl(req.pwTracertConf.tracertParam.maxTtl);
        testCaseInfo.setDestIP(new String(req.pwTracertConf.tracertParam.destination));
        if (null != req.pwTracertConf.tracertParam.replyType && StartPwe3Trace.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.pwTracertConf.tracertParam.replyType.intValue()) {
            testCaseInfo.setiTimeOut(DiagCommon.getInstance().getNoReplyTraceTimeOut(req.pwTracertConf.tracertParam.firstTtl, req.pwTracertConf.tracertParam.maxTtl, iProbeCount, req.pwTracertConf.tracertParam.replyTimeOut));
            try {
                Long iDestLsrID = IpAddressUtil.ipAsLong((String)new String(req.pwTracertConf.tracertParam.destination));
                testCaseInfo.setDestLsrID(iDestLsrID);
            }
            catch (UnknownHostException e) {
                this.getLogger().error("The DestLsrID is illegal", (Throwable)e);
            }
        } else {
            testCaseInfo.setiTimeOut(DiagCommon.getInstance().getTraceTimeOut(req.pwTracertConf.tracertParam.firstTtl, req.pwTracertConf.tracertParam.maxTtl, iProbeCount, req.pwTracertConf.tracertParam.replyTimeOut));
        }
        testCaseInfo.setGetIntevalTime(DiagCommon.getInstance().getPingResultInterval(req.pwTracertConf.tracertParam.replyTimeOut));
        return testCaseInfo;
    }

    private void decodeStartVplsTrace(QAsnStartPwe3PwTracertReq req, QAsnStartPwe3PwTracertRsp rsp, IAsnTranslationContext asnTranslationContext, VplsPwUniResIDParser vplsParser, Task task) {
        int iResID = DiagCommon.getInstance().assignResID();
        String testName = DiagnoseUtil.combineTestName(iResID);
        StartVplsTrace startVplsTraceMo = this.setStartVplsTrace(req, asnTranslationContext, vplsParser, testName);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID);
        testCaseInfo.setMoVplsTrace(startVplsTraceMo);
        DiagSchedulerMsg oDiagMsg = null;
        if (null != req.pwTracertConf.tracertParam.replyType && 1 == req.pwTracertConf.tracertParam.replyType) {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, true);
            DiagNoReplyScheduleCache.getInstance().push(oDiagMsg);
        } else {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
            DiagSchedulerCache.getInstance().push(oDiagMsg);
        }
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartVplsTrace setStartVplsTrace(QAsnStartPwe3PwTracertReq req, IAsnTranslationContext asnTranslationContext, VplsPwUniResIDParser vplsParser, String testName) {
        StartVplsTrace startVplsTraceMo = new StartVplsTrace();
        startVplsTraceMo.setDevID(Integer.valueOf(req.pwTracertConf.pwKey.neID));
        startVplsTraceMo.setFdn(new String(req.pwTracertConf.pwKey.strFDN));
        if (null != req.pwTracertConf.pwKey.poSerialNum) {
            startVplsTraceMo.setSerialNum(new String(req.pwTracertConf.pwKey.poSerialNum));
        }
        startVplsTraceMo.setTestName(testName);
        if (null != req.pwTracertConf.tracertParam.replyType) {
            startVplsTraceMo.setReplyMode(req.pwTracertConf.tracertParam.replyType);
        }
        QAsnPwTracertConfInfoTranslator translator = new QAsnPwTracertConfInfoTranslator();
        try {
            translator.decodeStartVplsTrace(req.pwTracertConf, startVplsTraceMo, asnTranslationContext);
        }
        catch (VMFException e) {
            this.getLogger().error("startVplsTrace execute failed", (Throwable)e);
        }
        return startVplsTraceMo;
    }
}

