/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartPwe3PwPingReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartPwe3PwPingRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.VplsPwUniResIDParser;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagNoReplyScheduleCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.translation.asn.QAsnPwPingConfInfoTranslator;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartPwe3Ping;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartVplsPing;

public class StartPwe3PwPingTask
extends AbstractQTask<QAsnStartPwe3PwPingReq, QAsnStartPwe3PwPingRsp> {
    protected void executeTask(QAsnStartPwe3PwPingReq req, QAsnStartPwe3PwPingRsp rsp, Task task) {
        IAsnTranslationContext asnTranslationCtx = DiagCommon.getInstance().getContext();
        VplsPwUniResIDParser vplsParser = new VplsPwUniResIDParser();
        vplsParser.deserialize(new String(req.pwPingConf.pwKey.strFDN));
        if (vplsParser.getVsiName().isEmpty()) {
            this.executePwe3Ping(req, rsp, asnTranslationCtx, task);
        } else {
            this.executeVplsPing(req, rsp, vplsParser, asnTranslationCtx, task);
        }
    }

    private void executePwe3Ping(QAsnStartPwe3PwPingReq req, QAsnStartPwe3PwPingRsp rsp, IAsnTranslationContext asnTranslationCtx, Task task) {
        int iResID = DiagCommon.getInstance().assignResID();
        StartPwe3Ping pwe3PingMo = this.setStartPwe3Ping(req, asnTranslationCtx, iResID);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID);
        testCaseInfo.setMoPwe3Ping(pwe3PingMo);
        testCaseInfo.setTestType(14);
        DiagSchedulerMsg oDiagMsg = null;
        if (null != req.pwPingConf.pingParam.replyType && 1 == req.pwPingConf.pingParam.replyType) {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, true);
            DiagNoReplyScheduleCache.getInstance().push(oDiagMsg);
        } else {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
            DiagSchedulerCache.getInstance().push(oDiagMsg);
        }
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartPwe3Ping setStartPwe3Ping(QAsnStartPwe3PwPingReq req, IAsnTranslationContext asnTranslationCtx, int iResID) {
        StartPwe3Ping pwe3PingMo = new StartPwe3Ping();
        pwe3PingMo.setDevID(Integer.valueOf(req.pwPingConf.pwKey.neID));
        pwe3PingMo.setFdn(new String(req.pwPingConf.pwKey.strFDN));
        pwe3PingMo.setTestName(DiagnoseUtil.combineTestName(iResID));
        pwe3PingMo.setPeerIpAddr(new String(req.pwPingConf.pingParam.destination));
        if (null != req.pwPingConf.poPeerPwID) {
            pwe3PingMo.setPwId(Long.valueOf(req.pwPingConf.poPeerPwID.intValue()));
        }
        if (null != req.poPwe3PingConfInfo && null != req.poPwe3PingConfInfo.postrPWE3RemoteVcId) {
            pwe3PingMo.setRemotePwId(Long.valueOf(new String(req.poPwe3PingConfInfo.postrPWE3RemoteVcId)));
        }
        if (null != req.pwPingConf.pingParam.replyType) {
            pwe3PingMo.setReplyMode(req.pwPingConf.pingParam.replyType);
            if (StartPwe3Ping.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.pwPingConf.pingParam.replyType.intValue()) {
                pwe3PingMo.setTestIndex(Long.valueOf(iResID));
            }
        }
        QAsnPwPingConfInfoTranslator translator = new QAsnPwPingConfInfoTranslator();
        try {
            translator.decode(req.pwPingConf, pwe3PingMo, asnTranslationCtx);
        }
        catch (VMFException e) {
            this.getLogger().error("StartPwe3Ping execute failed", (Throwable)e);
        }
        return pwe3PingMo;
    }

    private TestCaseInfo push(QAsnStartPwe3PwPingReq req, Task task, int iResID) {
        TestCaseInfo testCaseInfo = new TestCaseInfo();
        testCaseInfo.setTask(task);
        testCaseInfo.setDevID(req.pwPingConf.pwKey.neID);
        testCaseInfo.setProbeCount(req.pwPingConf.pingParam.echoRequest);
        testCaseInfo.setFdn(new String(req.pwPingConf.pwKey.strFDN));
        testCaseInfo.setSessionID(new String(req.sessionID));
        testCaseInfo.setTestName(DiagnoseUtil.combineTestName(iResID));
        testCaseInfo.setResID(iResID);
        testCaseInfo.setKeyID(String.valueOf(iResID));
        testCaseInfo.setPingOrTraceType(1);
        if (null != req.pwPingConf.pingParam.replyType && StartPwe3Ping.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.pwPingConf.pingParam.replyType.intValue()) {
            testCaseInfo.setiTimeOut(DiagCommon.getInstance().getNoReplyPingTimeOut(req.pwPingConf.pingParam.echoRequest, req.pwPingConf.pingParam.sendDistant, req.pwPingConf.pingParam.replyTimeOut));
        } else {
            testCaseInfo.setiTimeOut(DiagCommon.getInstance().getPingTimeOut(req.pwPingConf.pingParam.echoRequest, req.pwPingConf.pingParam.sendDistant, req.pwPingConf.pingParam.replyTimeOut));
        }
        testCaseInfo.setGetFirstTime(DiagCommon.getInstance().getFirstPingResultTime(req.pwPingConf.pingParam.echoRequest, req.pwPingConf.pingParam.sendDistant));
        testCaseInfo.setGetIntevalTime(DiagCommon.getInstance().getPingResultInterval(req.pwPingConf.pingParam.replyTimeOut));
        return testCaseInfo;
    }

    private void executeVplsPing(QAsnStartPwe3PwPingReq req, QAsnStartPwe3PwPingRsp rsp, VplsPwUniResIDParser vplsParser, IAsnTranslationContext asnTranslationCtx, Task task) {
        int iResID = DiagCommon.getInstance().assignResID();
        String testName = DiagnoseUtil.combineTestName(iResID);
        StartVplsPing startVplsPingMo = this.setStartVplsPing(req, vplsParser, asnTranslationCtx, testName);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID);
        testCaseInfo.setMoVplsPing(startVplsPingMo);
        testCaseInfo.setTestType(32);
        DiagSchedulerMsg oDiagMsg = null;
        if (null != req.pwPingConf.pingParam.replyType && 1 == req.pwPingConf.pingParam.replyType) {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, true);
            DiagNoReplyScheduleCache.getInstance().push(oDiagMsg);
        } else {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
            DiagSchedulerCache.getInstance().push(oDiagMsg);
        }
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartVplsPing setStartVplsPing(QAsnStartPwe3PwPingReq req, VplsPwUniResIDParser vplsParser, IAsnTranslationContext asnTranslationCtx, String testName) {
        StartVplsPing startVplsPingMo = new StartVplsPing();
        startVplsPingMo.setTestName(testName);
        startVplsPingMo.setDevID(Integer.valueOf(req.pwPingConf.pwKey.neID));
        startVplsPingMo.setFdn(new String(req.pwPingConf.pwKey.strFDN));
        if (null != req.pwPingConf.pingParam.replyType) {
            startVplsPingMo.setReplyMode(req.pwPingConf.pingParam.replyType);
        }
        QAsnPwPingConfInfoTranslator translator = new QAsnPwPingConfInfoTranslator();
        try {
            translator.decodeVplsPing(req.pwPingConf, startVplsPingMo, asnTranslationCtx);
        }
        catch (VMFException e) {
            this.getLogger().error("StartVplsPing execute failed", (Throwable)e);
        }
        return startVplsPingMo;
    }
}

