/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_8021ag_model.QAsnTMErrorResult;
import com.huawei.network.qasn.m_q_ip_8021ag_model.QAsnTMPara;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnStartTMReq;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnStartTMRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.Pwe3UniResIDParser;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.transaction.NestingContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.AutoTest;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class StartPwe3AutoTestTask
extends AbstractQTask<QAsnStartTMReq, QAsnStartTMRsp> {
    protected void executeTask(QAsnStartTMReq req, QAsnStartTMRsp rsp, Task task) {
        rsp.oRetrun = new QAsnErrInfoReturn();
        rsp.oRetrun.result = 0;
        if (null == req || CollectionUtils.isEmpty((Collection)req.lstPara)) {
            this.getLogger().info("StartTMAutoTestTask----->executeTask error, req is empty");
            return;
        }
        Context context = new Context();
        for (Object obj : req.lstPara) {
            QAsnTMPara qAsnTMPara = (QAsnTMPara)obj;
            if (null == qAsnTMPara || null == qAsnTMPara.oSrvIndex || null == qAsnTMPara.oSinkSapKey || 0 != qAsnTMPara.oSrcSapKey.strFDN.length) continue;
            QAsnTMErrorResult errorResult = new QAsnTMErrorResult();
            errorResult.oSrvIndex = qAsnTMPara.oSrvIndex;
            errorResult.oReturn.result = 0;
            ErrorInfo errInfo = this.configPwe3TM(qAsnTMPara, context);
            if (null != errInfo && 0 != errInfo.getErrorCode() && 0 == errorResult.oReturn.result) {
                errorResult.oReturn.result = errInfo.getErrorCode();
                errorResult.oReturn.errList = new QAsnErrInfoList();
                QAsnErrInfo qErrInfo = new QAsnErrInfo();
                qErrInfo.errCode = errInfo.getErrorCode();
                qErrInfo.strOperDesc = null == errInfo.getErrorMessage() ? "".getBytes() : errInfo.getErrorMessage().getBytes();
                errorResult.oReturn.errList.add((Object)qErrInfo);
                rsp.oRetrun.result = 1107499878;
            }
            rsp.lstTMResult.add((Object)errorResult);
        }
    }

    private ErrorInfo configPwe3TM(QAsnTMPara qAsnTMPara, Context context) {
        AutoTest autoTest = new AutoTest();
        Pwe3UniResIDParser parser = new Pwe3UniResIDParser();
        parser.deserialize(StringUtil.globalString((byte[])qAsnTMPara.oSrvIndex.strFDN));
        autoTest.setDevID(Integer.valueOf(parser.getDevID()));
        autoTest.setServiceName(parser.getIfID());
        autoTest.setServiceType(AutoTest.SERVICE_TYPE_ENUM.VLL);
        String testName = autoTest.getServiceType() + "|" + autoTest.getServiceName();
        autoTest.setTestName(testName);
        String ifName = DiagnoseUtil.getIfName(StringUtil.globalString((byte[])qAsnTMPara.oSinkSapKey.strFDN));
        autoTest.setIfName(ifName);
        IMOChangeRecord recorder = context.addChangeRecord(autoTest.getClass());
        recorder.addCreate((Object)autoTest);
        NestingContext nestingContext = new NestingContext(autoTest.getDevID().intValue(), false);
        nestingContext.setTotalContext(context);
        nestingContext.setConfigDev(true);
        nestingContext.addFeatureMoTypeFirst(FeatureName.DGNTL, AutoTest.class);
        nestingContext.addChangeRecord(AutoTest.class).addCreate((Object)autoTest);
        DefaultMOService moService = new DefaultMOService();
        try {
            moService.addDeployJob(nestingContext);
            moService.deploy();
        }
        catch (VMFException e) {
            this.getLogger().error("StartPwe3AutoTestTask configPwe3TM(), deploy AutoTest failed. nestingContext = " + nestingContext, (Throwable)e);
        }
        return moService.getErrorInfo((VmfMO)autoTest);
    }

    private void addChangeMo(AutoTest autoTest, NestingContext nestingContext, EOperationType operType) {
        Class<?> moClazz = autoTest.getClass();
        Context totalContext = nestingContext.getTotalContext();
        IMOChangeRecord totalDevChangeRecord = totalContext.getChangeRecord(moClazz);
        IMOChangeRecord newDevChangeRecord = nestingContext.addChangeRecord(moClazz);
        if (totalDevChangeRecord.isCreated((Object)autoTest)) {
            newDevChangeRecord.addCreate((Object)autoTest);
        }
    }
}

