/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartLspTracertReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartLspTracertRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.TunnelUniResIDForPtnParser;
import com.huawei.vmf.adapter.common.utilty.IpAddressUtil;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagNoReplyScheduleCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.translation.asn.QAsnTracertParamTranslator;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartLspTrace;
import java.net.UnknownHostException;

public class StartLspTracertTask
extends AbstractQTask<QAsnStartLspTracertReq, QAsnStartLspTracertRsp> {
    protected void executeTask(QAsnStartLspTracertReq req, QAsnStartLspTracertRsp rsp, Task task) {
        IAsnTranslationContext asnTransContext = DiagCommon.getInstance().getContext();
        int iResID = DiagCommon.getInstance().assignResID();
        StartLspTrace startLspTraceMo = this.setStartLspTrace(req, asnTransContext, iResID);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID, startLspTraceMo);
        DiagSchedulerMsg oDiagMsg = null;
        if (null != req.param.replyType && req.param.replyType == 1) {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, true);
            DiagNoReplyScheduleCache.getInstance().push(oDiagMsg);
        } else {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
            DiagSchedulerCache.getInstance().push(oDiagMsg);
        }
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartLspTrace setStartLspTrace(QAsnStartLspTracertReq req, IAsnTranslationContext asnTransContext, int iResID) {
        StartLspTrace startLspTraceMo = new StartLspTrace();
        startLspTraceMo.setDevID(Integer.valueOf(req.oTunnelKey.neID));
        startLspTraceMo.setTestName(DiagnoseUtil.combineTestName(iResID));
        if (!new String(req.oTunnelKey.strFDN).isEmpty()) {
            startLspTraceMo.setFdn(new String(req.oTunnelKey.strFDN));
            StartLspTracertTask.decodeTunnelFdn(new String(req.oTunnelKey.strFDN), startLspTraceMo);
        }
        if (null != req.param.replyType) {
            startLspTraceMo.setReplyMode(req.param.replyType);
            if (StartLspTrace.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.param.replyType.intValue()) {
                startLspTraceMo.setTestIndex(Long.valueOf(iResID));
            }
        }
        QAsnTracertParamTranslator translator = new QAsnTracertParamTranslator();
        try {
            translator.decodeStartLspTrace(req.param, startLspTraceMo, asnTransContext);
        }
        catch (VMFException e) {
            this.getLogger().error("startLspTrace execute failed", (Throwable)e);
        }
        return startLspTraceMo;
    }

    public static void decodeTunnelFdn(String strFDN, StartLspTrace startLspTraceMo) {
        TunnelUniResIDForPtnParser tunnelRes = new TunnelUniResIDForPtnParser();
        tunnelRes.deserialize(strFDN);
        StringBuilder tunnelName = new StringBuilder();
        tunnelName.append("Tunnel");
        tunnelName.append(200000 + tunnelRes.getTunnelID());
        startLspTraceMo.setTunnelName(tunnelName.toString());
    }

    private TestCaseInfo push(QAsnStartLspTracertReq req, Task task, int iResID, StartLspTrace startLspTraceMo) {
        TestCaseInfo testCaseInfo = new TestCaseInfo();
        testCaseInfo.setTask(task);
        testCaseInfo.setDevID(req.oTunnelKey.neID);
        int iProbeCount = 3;
        if (-1 != req.param.echoRequest) {
            iProbeCount = req.param.echoRequest;
        }
        if (null != req.param.replyType && StartLspTrace.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.param.replyType.intValue()) {
            iProbeCount = 1;
        }
        testCaseInfo.setProbeCount(iProbeCount);
        testCaseInfo.setFdn(new String(req.oTunnelKey.strFDN));
        testCaseInfo.setSessionID(new String(req.sessionID));
        testCaseInfo.setTestName(DiagnoseUtil.combineTestName(iResID));
        testCaseInfo.setResID(iResID);
        testCaseInfo.setTestType(10);
        testCaseInfo.setKeyID(String.valueOf(iResID));
        testCaseInfo.setPingOrTraceType(2);
        testCaseInfo.setMaxTtl(req.param.maxTtl);
        testCaseInfo.setDestIP(new String(req.param.destination));
        if (null != req.param.replyType && StartLspTrace.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.param.replyType.intValue()) {
            testCaseInfo.setiTimeOut(DiagCommon.getInstance().getNoReplyTraceTimeOut(req.param.firstTtl, req.param.maxTtl, iProbeCount, req.param.replyTimeOut));
            try {
                Long iDestLsrID = IpAddressUtil.ipAsLong((String)new String(req.param.destination));
                testCaseInfo.setDestLsrID(iDestLsrID);
            }
            catch (UnknownHostException e) {
                this.getLogger().error("The DestLsrID is illegal", (Throwable)e);
            }
        } else {
            testCaseInfo.setiTimeOut(DiagCommon.getInstance().getTraceTimeOut(req.param.firstTtl, req.param.maxTtl, iProbeCount, req.param.replyTimeOut));
        }
        testCaseInfo.setGetIntevalTime(DiagCommon.getInstance().getPingResultInterval(req.param.replyTimeOut));
        testCaseInfo.setMoLspTrace(startLspTraceMo);
        return testCaseInfo;
    }
}

