/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartLspPingReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartLspPingRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.TunnelUniResIDForPtnParser;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagNoReplyScheduleCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.translation.asn.QAsnPingParamTranslator;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartLspPing;

public class StartLspPingTask
extends AbstractQTask<QAsnStartLspPingReq, QAsnStartLspPingRsp> {
    protected void executeTask(QAsnStartLspPingReq req, QAsnStartLspPingRsp rsp, Task task) {
        IAsnTranslationContext asnTranslationCtx = DiagCommon.getInstance().getContext();
        int iResID = DiagCommon.getInstance().assignResID();
        StartLspPing startLspPingMo = this.setStartLspPing(req, asnTranslationCtx, iResID);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID, startLspPingMo);
        DiagSchedulerMsg oDiagMsg = null;
        if (null != req.param.replyType && req.param.replyType == 1) {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, true);
            DiagNoReplyScheduleCache.getInstance().push(oDiagMsg);
        } else {
            oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
            DiagSchedulerCache.getInstance().push(oDiagMsg);
        }
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartLspPing setStartLspPing(QAsnStartLspPingReq req, IAsnTranslationContext asnTranslationCtx, int iResID) {
        StartLspPing startLspPingMo = new StartLspPing();
        startLspPingMo.setDevID(Integer.valueOf(req.oTunnelKey.neID));
        startLspPingMo.setTestName(DiagnoseUtil.combineTestName(iResID));
        if (!new String(req.oTunnelKey.strFDN).isEmpty()) {
            startLspPingMo.setFdn(new String(req.oTunnelKey.strFDN));
            StartLspPingTask.decodeTunnelFdn(new String(req.oTunnelKey.strFDN), startLspPingMo);
        }
        if (null != req.param.replyType) {
            startLspPingMo.setReplyMode(req.param.replyType);
            if (StartLspPing.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.param.replyType.intValue()) {
                startLspPingMo.setTestIndex(Long.valueOf(iResID));
            }
        }
        QAsnPingParamTranslator translator = new QAsnPingParamTranslator();
        try {
            translator.decodeLspPing(req.param, startLspPingMo, asnTranslationCtx);
        }
        catch (VMFException e) {
            this.getLogger().error("StartLspPing execute failed", (Object)e.getMessage());
        }
        return startLspPingMo;
    }

    public static void decodeTunnelFdn(String strFDN, StartLspPing startLspPingMo) {
        TunnelUniResIDForPtnParser tunnelRes = new TunnelUniResIDForPtnParser();
        tunnelRes.deserialize(strFDN);
        StringBuilder tunnelName = new StringBuilder();
        tunnelName.append("Tunnel");
        tunnelName.append(200000 + tunnelRes.getTunnelID());
        startLspPingMo.setTunnelName(tunnelName.toString());
    }

    private TestCaseInfo push(QAsnStartLspPingReq req, Task task, int iResID, StartLspPing startLspPingMo) {
        TestCaseInfo testCaseInfo = new TestCaseInfo();
        testCaseInfo.setTask(task);
        testCaseInfo.setTestName(DiagnoseUtil.combineTestName(iResID));
        testCaseInfo.setDevID(req.oTunnelKey.neID);
        testCaseInfo.setProbeCount(req.param.echoRequest);
        testCaseInfo.setResID(iResID);
        testCaseInfo.setSessionID(new String(req.sessionID));
        testCaseInfo.setFdn(new String(req.oTunnelKey.strFDN));
        testCaseInfo.setTestType(9);
        testCaseInfo.setKeyID(String.valueOf(iResID));
        testCaseInfo.setPingOrTraceType(1);
        if (null != req.param.replyType && StartLspPing.REPLY_MODE_ENUM.NO_REPLY.intValue() == req.param.replyType.intValue()) {
            testCaseInfo.setiTimeOut(DiagCommon.getInstance().getNoReplyPingTimeOut(req.param.echoRequest, req.param.sendDistant, req.param.replyTimeOut));
        } else {
            testCaseInfo.setiTimeOut(DiagCommon.getInstance().getPingTimeOut(req.param.echoRequest, req.param.sendDistant, req.param.replyTimeOut));
        }
        testCaseInfo.setGetFirstTime(DiagCommon.getInstance().getFirstPingResultTime(req.param.echoRequest, req.param.sendDistant));
        testCaseInfo.setGetIntevalTime(DiagCommon.getInstance().getPingResultInterval(req.param.replyTimeOut));
        testCaseInfo.setMoLspPing(startLspPingMo);
        return testCaseInfo;
    }
}

