/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartL3vpnTracertReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartL3vpnTracertRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.L3vpnUniResIDParser;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.translation.asn.QAsnTracertParamTranslator;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartIpTrace;

public class StartL3vpnTracertTask
extends AbstractQTask<QAsnStartL3vpnTracertReq, QAsnStartL3vpnTracertRsp> {
    protected void executeTask(QAsnStartL3vpnTracertReq req, QAsnStartL3vpnTracertRsp rsp, Task task) {
        IAsnTranslationContext transContext = DiagCommon.getInstance().getContext();
        int iResID = DiagCommon.getInstance().assignResID();
        String testName = DiagnoseUtil.combineTestName(iResID);
        StartIpTrace startIpTraceMo = this.setStartIpTraceMo(req, transContext, testName);
        TestCaseInfo testCaseInfo = this.push(req, task, iResID, startIpTraceMo);
        DiagSchedulerMsg oDiagMsg = new DiagSchedulerMsg(testCaseInfo.getDevID(), testCaseInfo, false);
        DiagSchedulerCache.getInstance().push(oDiagMsg);
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartIpTrace setStartIpTraceMo(QAsnStartL3vpnTracertReq req, IAsnTranslationContext TransContext, String testName) {
        StartIpTrace startIpTraceMo = new StartIpTrace();
        startIpTraceMo.setTestName(testName);
        this.decodeKeyProperity(req, startIpTraceMo);
        QAsnTracertParamTranslator translator = new QAsnTracertParamTranslator();
        try {
            translator.decode(req.param, startIpTraceMo, TransContext);
        }
        catch (VMFException e) {
            this.getLogger().error("startIpTrace execute failed", (Object)e.getMessage());
        }
        return startIpTraceMo;
    }

    private void decodeKeyProperity(QAsnStartL3vpnTracertReq req, StartIpTrace startIpTraceMo) {
        startIpTraceMo.setDevID(Integer.valueOf(req.vrfKey.neID));
        if (null != req.vrfKey.poSerialNum) {
            startIpTraceMo.setSerialNum(new String(req.vrfKey.poSerialNum));
        }
        if (!new String(req.vrfKey.strFDN).isEmpty()) {
            startIpTraceMo.setFdn(new String(req.vrfKey.strFDN));
            L3vpnUniResIDParser l3vpnVrfParse = new L3vpnUniResIDParser();
            l3vpnVrfParse.deserialize(new String(req.vrfKey.strFDN));
            if (null != l3vpnVrfParse.getVrfName() && !l3vpnVrfParse.getVrfName().isEmpty()) {
                startIpTraceMo.setVrfName(l3vpnVrfParse.getVrfName());
            }
            if (null != l3vpnVrfParse.getVrfID() && !l3vpnVrfParse.getVrfID().isEmpty()) {
                startIpTraceMo.setVrfName(l3vpnVrfParse.getVrfID());
            }
        }
    }

    private TestCaseInfo push(QAsnStartL3vpnTracertReq req, Task task, int iResID, StartIpTrace startIpTraceMo) {
        TestCaseInfo testCaseInfo = new TestCaseInfo();
        testCaseInfo.setTask(task);
        testCaseInfo.setTestName("NEDiag" + iResID);
        testCaseInfo.setDevID(req.vrfKey.neID);
        int iProbeCount = 3;
        if (-1 != req.param.echoRequest) {
            iProbeCount = req.param.echoRequest;
        }
        testCaseInfo.setProbeCount(iProbeCount);
        testCaseInfo.setResID(iResID);
        testCaseInfo.setSessionID(new String(req.sessionID));
        testCaseInfo.setTestType(101);
        testCaseInfo.setiTimeOut(DiagCommon.getInstance().getTraceTimeOut(req.param.firstTtl, req.param.maxTtl, iProbeCount, req.param.replyTimeOut));
        testCaseInfo.setGetFirstTime(DiagCommon.getInstance().getTraceResultTime(iProbeCount, req.param.replyTimeOut));
        testCaseInfo.setGetIntevalTime(DiagCommon.getInstance().getTraceResultTime(iProbeCount, req.param.replyTimeOut));
        testCaseInfo.setMoIpTrace(startIpTraceMo);
        return testCaseInfo;
    }
}

