/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartL3vpnPingReq;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnStartL3vpnPingRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.L3vpnUniResIDParser;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.translation.asn.QAsnPingParamTranslator;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartIpPing;

public class StartL3vpnPingTask
extends AbstractQTask<QAsnStartL3vpnPingReq, QAsnStartL3vpnPingRsp> {
    protected void executeTask(QAsnStartL3vpnPingReq req, QAsnStartL3vpnPingRsp rsp, Task task) {
        IAsnTranslationContext asnTransContext = DiagCommon.getInstance().getContext();
        int iResID = DiagCommon.getInstance().assignResID();
        String testName = DiagnoseUtil.combineTestName(iResID);
        StartIpPing startIpPingMo = this.setStartIpPing(req, asnTransContext, testName);
        TestCaseInfo testCase = this.push(req, task, iResID, startIpPingMo);
        DiagSchedulerMsg oDiagMsg = new DiagSchedulerMsg(testCase.getDevID(), testCase, false);
        DiagSchedulerCache.getInstance().push(oDiagMsg);
        rsp.testCaseID = iResID;
        DiagCommon.getInstance().execSuccess(rsp.result);
    }

    private StartIpPing setStartIpPing(QAsnStartL3vpnPingReq req, IAsnTranslationContext asnTransContext, String testName) {
        StartIpPing startIpPingMo = new StartIpPing();
        startIpPingMo.setTestName(testName);
        this.decodeKeyProperity(req, startIpPingMo);
        QAsnPingParamTranslator translator = new QAsnPingParamTranslator();
        try {
            translator.decode(req.param, startIpPingMo, asnTransContext);
        }
        catch (VMFException e) {
            this.getLogger().error("decode startIpPing failed", (Object)e.getMessage());
        }
        return startIpPingMo;
    }

    private void decodeKeyProperity(QAsnStartL3vpnPingReq req, StartIpPing startIpPingMo) {
        startIpPingMo.setDevID(Integer.valueOf(req.vrfKey.neID));
        if (null != req.vrfKey.poSerialNum) {
            startIpPingMo.setSerialNum(new String(req.vrfKey.poSerialNum));
        }
        if (!new String(req.vrfKey.strFDN).isEmpty()) {
            startIpPingMo.setFdn(new String(req.vrfKey.strFDN));
            L3vpnUniResIDParser l3vpnVrfParse = new L3vpnUniResIDParser();
            l3vpnVrfParse.deserialize(new String(req.vrfKey.strFDN));
            if (null != l3vpnVrfParse.getVrfName() && !l3vpnVrfParse.getVrfName().isEmpty()) {
                startIpPingMo.setVrfName(l3vpnVrfParse.getVrfName());
            }
            if (null != l3vpnVrfParse.getVrfID() && !l3vpnVrfParse.getVrfID().isEmpty()) {
                startIpPingMo.setVrfName(l3vpnVrfParse.getVrfID());
            }
        }
    }

    private TestCaseInfo push(QAsnStartL3vpnPingReq req, Task task, int iResID, StartIpPing startIpPingMo) {
        TestCaseInfo testCase = new TestCaseInfo();
        testCase.setTask(task);
        testCase.setTestName("NEDiag" + iResID);
        testCase.setDevID(req.vrfKey.neID);
        testCase.setProbeCount(req.param.echoRequest);
        testCase.setResID(iResID);
        testCase.setSessionID(new String(req.sessionID));
        testCase.setTestType(6);
        testCase.setiTimeOut(DiagCommon.getInstance().getPingTimeOut(req.param.echoRequest, req.param.sendDistant, req.param.replyTimeOut));
        testCase.setGetFirstTime(DiagCommon.getInstance().getFirstPingResultTime(req.param.echoRequest, req.param.sendDistant));
        testCase.setGetIntevalTime(DiagCommon.getInstance().getPingResultInterval(req.param.replyTimeOut));
        testCase.setMoIpPing(startIpPingMo);
        return testCase;
    }
}

