/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnDisableTMReq;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnStartTMRsp;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.Pwe3UniResIDParser;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.NestingContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.AutoTest;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;

public class DisableTMTask
extends AbstractQTask<QAsnDisableTMReq, QAsnStartTMRsp> {
    protected void executeTask(QAsnDisableTMReq req, QAsnStartTMRsp rsp, Task task) {
        rsp.oRetrun = new QAsnErrInfoReturn();
        rsp.oRetrun.result = 0;
        if (null == req) {
            this.getLogger().error("DisableTMTask.executeTask() req error, req is empty");
            return;
        }
        if (null == req.oSrvIndex || null == req.oSinkSapKey) {
            this.getLogger().error("DisableTMTask.executeTask() oSinkSapKey error, oSinkSapKey is empty where dev is ptn79");
            return;
        }
        if (0 != req.oSrcSapKey.strFDN.length) {
            this.getLogger().error("DisableTMTask.executeTask() oSrcSapKey error, oSrcSapKey is not empty where dev is ptn79");
            return;
        }
        AutoTest autoTest = new AutoTest();
        Pwe3UniResIDParser parser = new Pwe3UniResIDParser();
        parser.deserialize(StringUtil.globalString((byte[])req.oSrvIndex.strFDN));
        autoTest.setDevID(Integer.valueOf(parser.getDevID()));
        autoTest.setServiceName(parser.getIfID());
        autoTest.setServiceType(AutoTest.SERVICE_TYPE_ENUM.VLL);
        String testName = autoTest.getServiceType() + "|" + autoTest.getServiceName();
        autoTest.setTestName(testName);
        NestingContext nestingContext = new NestingContext(autoTest.getDevID().intValue(), false);
        nestingContext.setConfigDev(true);
        nestingContext.addChangeRecord(AutoTest.class).addDelete((Object)autoTest);
        nestingContext.addFeatureMoTypeFirst(FeatureName.DGNTL, AutoTest.class);
        DefaultMOService deployService = new DefaultMOService();
        try {
            deployService.addDeployJob(nestingContext);
            deployService.deploy();
        }
        catch (VMFException e) {
            this.getLogger().error("DisableTMTask executeTask(), deploy AutoTest failed. nestingContext = " + nestingContext, (Throwable)e);
        }
        ErrorInfo errorInfo = deployService.getErrorInfo((VmfMO)autoTest);
        if (null != errorInfo && 0 != errorInfo.getErrorCode() && 0 == rsp.oRetrun.result) {
            rsp.oRetrun.result = errorInfo.getErrorCode();
            rsp.oRetrun.errList = new QAsnErrInfoList();
            QAsnErrInfo qErrInfo = new QAsnErrInfo();
            qErrInfo.errCode = errorInfo.getErrorCode();
            qErrInfo.strOperDesc = null == errorInfo.getErrorMessage() ? "".getBytes() : errorInfo.getErrorMessage().getBytes();
            rsp.oRetrun.errList.add((Object)qErrInfo);
        }
    }
}

