/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.service;

import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnPing;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnSPRingPingRet;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnSPRingTracertRet;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnTracert;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnTracertList;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnL3vpnPingRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnL3vpnTracertRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnLspPingRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnLspTracertRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnPwe3PwPingRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnPwe3PwTracertRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnSPRingPingRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnSPRingTracertRpt;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.imap.IMessageSession;
import com.huawei.vmf.adapter.common.imap.MessageSessionFactory;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv4PingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv4PingResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv4TraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv4TraceResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.LspPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.LspPingResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.LspTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.LspTraceResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.Pwe3PingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Pwe3PingResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.Pwe3TraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Pwe3TraceResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.RingPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.RingPingResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.RingTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.RingTraceResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.VplsPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.VplsPingResultDetail;
import com.huawei.vmf.adapter.fservice.diagnose.model.VplsTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.VplsTraceResultDetail;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class DiagResultApi {
    private static final Logger LOGGER = RunLogger.getLogger(DiagResultApi.class);

    public void notifyTestCaseResult(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCase) {
        LOGGER.info("Enter into notifyTestCaseResult.");
        if (null == queryContext || null == testCase) {
            LOGGER.info("notifyTestCaseResult() queryContext or testCase is NULL.");
            return;
        }
        switch (testCase.getTestType()) {
            case 6: 
            case 100: {
                this.sendL3vpnPingRpt(queryContext, testCase);
                break;
            }
            case 101: {
                this.sendL3vpnTraceRpt(queryContext, testCase);
                break;
            }
            case 9: {
                this.sendLspPingRpt(queryContext, testCase);
                break;
            }
            case 10: {
                this.sendLspTraceRpt(queryContext, testCase);
                break;
            }
            case 14: {
                this.sendPwe3PingRpt(queryContext, testCase);
                break;
            }
            case 15: {
                this.sendPwe3TraceRpt(queryContext, testCase);
                break;
            }
            case 32: {
                this.sendVplsPingRpt(queryContext, testCase);
                break;
            }
            case 33: {
                this.sendVplsTraceRpt(queryContext, testCase);
                break;
            }
            case 1009: {
                this.sendRingPingRpt(queryContext, testCase);
                break;
            }
            case 1010: {
                this.sendRingTraceRpt(queryContext, testCase);
                break;
            }
        }
    }

    private void sendL3vpnPingRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCase) {
        QAsnL3vpnPingRpt l3vpnPingRpt = new QAsnL3vpnPingRpt();
        AsnUtil.setDefaultAsnValue((FStruct)l3vpnPingRpt);
        AsnUtil.setDefaultAsnValue((FStruct)l3vpnPingRpt.statistic);
        Collection ipPingResults = queryContext.getQueryResult(Ipv4PingResult.class);
        if (null == ipPingResults) {
            return;
        }
        for (Ipv4PingResult pingResult : ipPingResults) {
            l3vpnPingRpt.testCaseID = testCase.getResID();
            l3vpnPingRpt.sessionID = testCase.getSessionID().getBytes();
            l3vpnPingRpt.statistic.neID = AsnUtil.intValue((Integer)testCase.getDevID());
            l3vpnPingRpt.statistic.txNum = AsnUtil.intValue((Long)pingResult.getPacketSend());
            l3vpnPingRpt.statistic.rxNum = AsnUtil.intValue((Long)pingResult.getPacketRecv());
            l3vpnPingRpt.statistic.txFailNum = -1;
            l3vpnPingRpt.statistic.timeoutNum = -1;
            l3vpnPingRpt.statistic.initFailNum = -1;
            l3vpnPingRpt.statistic.lossRate = AsnUtil.intValue((Integer)pingResult.getLossRatio()) * 100;
            l3vpnPingRpt.statistic.minDelay = AsnUtil.intValue((Long)pingResult.getRttMin());
            l3vpnPingRpt.statistic.avgDelay = AsnUtil.intValue((Long)pingResult.getAverageRtt());
            l3vpnPingRpt.statistic.maxDelay = AsnUtil.intValue((Long)pingResult.getRttMax());
            if (0 == pingResult.getErrorType()) {
                l3vpnPingRpt.result.isSuccess = true;
                l3vpnPingRpt.result.retCode = 0;
                if (0L == pingResult.getPacketRecv()) {
                    l3vpnPingRpt.result.isSuccess = false;
                    l3vpnPingRpt.result.retCode = 555798761;
                }
            } else {
                l3vpnPingRpt.result.isSuccess = false;
                l3vpnPingRpt.result.retCode = 555798665;
            }
            l3vpnPingRpt.finished = Ipv4PingResult.STATUS_ENUM.FINISHED.intValue() == pingResult.getStatus().intValue() ? Ipv4PingResult.STATUS_ENUM.FINISHED.intValue() : Ipv4PingResult.STATUS_ENUM.PROCESSING.intValue();
            Collection ipPingDeatils = pingResult.getIpv4PingResultDetails();
            if (null == ipPingDeatils) continue;
            for (Ipv4PingResultDetail ipPingResultDetail : ipPingDeatils) {
                QAsnPing ping = new QAsnPing();
                ping.neID = AsnUtil.intValue((Integer)testCase.getDevID());
                ping.destination = AsnUtil.getBytes((String)ipPingResultDetail.getIpAddr());
                ping.pktLen = AsnUtil.intValue((Long)ipPingResultDetail.getPacketSize());
                ping.pktSeq = AsnUtil.intValue((Long)ipPingResultDetail.getIndex());
                ping.ttl = AsnUtil.intValue((Integer)ipPingResultDetail.getTtl());
                ping.delay = AsnUtil.intValue((Long)ipPingResultDetail.getRtt());
                l3vpnPingRpt.pingList.add((Object)ping);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(65728, testCase.getTask(), (FStruct)l3vpnPingRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65728, (FStruct)l3vpnPingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendL3vpnTraceRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCase) {
        QAsnL3vpnTracertRpt l3vpnTraceRpt = new QAsnL3vpnTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)l3vpnTraceRpt);
        Collection ipTraceResults = queryContext.getQueryResult(Ipv4TraceResult.class);
        if (null == ipTraceResults) {
            return;
        }
        for (Ipv4TraceResult ipTrace : ipTraceResults) {
            l3vpnTraceRpt.sessionID = testCase.getSessionID().getBytes();
            l3vpnTraceRpt.testCaseID = testCase.getResID();
            if (0 == ipTrace.getErrorType()) {
                l3vpnTraceRpt.result.isSuccess = true;
                l3vpnTraceRpt.result.retCode = 0;
            } else {
                l3vpnTraceRpt.result.isSuccess = false;
                l3vpnTraceRpt.result.retCode = 555798665;
            }
            l3vpnTraceRpt.finished = Ipv4TraceResult.STATUS_ENUM.FINISHED.intValue() == ipTrace.getStatus().intValue() ? Ipv4TraceResult.STATUS_ENUM.FINISHED.intValue() : Ipv4TraceResult.STATUS_ENUM.PROCESSING.intValue();
            Collection traceDetails = ipTrace.getIpv4TraceResultDetails();
            if (null == traceDetails) continue;
            for (Ipv4TraceResultDetail traceDetail : traceDetails) {
                QAsnTracert trace = new QAsnTracert();
                trace.neID = AsnUtil.intValue((Integer)traceDetail.getDevID());
                trace.pktSeq = AsnUtil.intValue((Long)traceDetail.getHopIndex());
                trace.midIp = AsnUtil.getBytes((String)traceDetail.getDsIpAddr());
                trace.minDelay = -1;
                trace.maxDelay = AsnUtil.intValue((Long)traceDetail.getRtt());
                trace.avgDelay = -1;
                l3vpnTraceRpt.tracertList.add((Object)trace);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(65729, testCase.getTask(), (FStruct)l3vpnTraceRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65729, (FStruct)l3vpnTraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendLspPingRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCaseInfo) {
        QAsnLspPingRpt lspPingRpt = new QAsnLspPingRpt();
        Collection lspPingResults = queryContext.getQueryResult(LspPingResult.class);
        if (null == lspPingResults) {
            LOGGER.error("The lspPingResults is null");
            return;
        }
        for (LspPingResult lspPingResult : lspPingResults) {
            lspPingRpt.testCaseID = testCaseInfo.getResID();
            lspPingRpt.sessionID = testCaseInfo.getSessionID().getBytes();
            lspPingRpt.statistic.neID = AsnUtil.intValue((Integer)lspPingResult.getDevID());
            lspPingRpt.statistic.txNum = AsnUtil.intValue((Long)lspPingResult.getPacketSend());
            lspPingRpt.statistic.rxNum = AsnUtil.intValue((Long)lspPingResult.getPacketRecv());
            lspPingRpt.statistic.txFailNum = -1;
            lspPingRpt.statistic.timeoutNum = -1;
            lspPingRpt.statistic.initFailNum = -1;
            lspPingRpt.statistic.lossRate = AsnUtil.intValue((Integer)lspPingResult.getLossRatio()) * 100;
            lspPingRpt.statistic.minDelay = AsnUtil.intValue((Long)lspPingResult.getRttMin());
            lspPingRpt.statistic.avgDelay = AsnUtil.intValue((Long)lspPingResult.getRttAverage());
            lspPingRpt.statistic.maxDelay = AsnUtil.intValue((Long)lspPingResult.getRttMax());
            if (0 == lspPingResult.getErrorType()) {
                lspPingRpt.result.isSuccess = true;
                lspPingRpt.result.retCode = 0;
                if (0L == lspPingResult.getPacketRecv()) {
                    lspPingRpt.result.isSuccess = false;
                    lspPingRpt.result.retCode = 555798761;
                }
            } else {
                lspPingRpt.result.isSuccess = false;
                lspPingRpt.result.retCode = 555798665;
            }
            lspPingRpt.finished = LspPingResult.STATUS_ENUM.FINISHED.intValue() == lspPingResult.getStatus().intValue();
            Collection pingResultDetails = lspPingResult.getLspPingResultDetails();
            if (null == pingResultDetails) continue;
            for (LspPingResultDetail pingResultDetail : pingResultDetails) {
                QAsnPing ping = new QAsnPing();
                ping.neID = AsnUtil.intValue((Integer)pingResultDetail.getDevID());
                ping.destination = AsnUtil.getBytes((String)pingResultDetail.getDestIpAddr());
                ping.pktLen = AsnUtil.intValue((Long)pingResultDetail.getPacketSize());
                ping.pktSeq = AsnUtil.intValue((Long)pingResultDetail.getIndex());
                ping.ttl = AsnUtil.intValue((Integer)pingResultDetail.getTtl());
                ping.delay = AsnUtil.intValue((Long)pingResultDetail.getRtt());
                lspPingRpt.pingList.add((Object)ping);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(65730, testCaseInfo.getTask(), (FStruct)lspPingRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65730, (FStruct)lspPingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendLspTraceRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCaseInfo) {
        QAsnLspTracertRpt lspTraceRpt = new QAsnLspTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)lspTraceRpt);
        Collection lspTraceResults = queryContext.getQueryResult(LspTraceResult.class);
        if (null == lspTraceResults) {
            return;
        }
        for (LspTraceResult traceResult : lspTraceResults) {
            lspTraceRpt.sessionID = testCaseInfo.getSessionID().getBytes();
            lspTraceRpt.testCaseID = testCaseInfo.getResID();
            if (0 == traceResult.getErrorType()) {
                lspTraceRpt.result.isSuccess = true;
                lspTraceRpt.result.retCode = 0;
            } else {
                lspTraceRpt.result.isSuccess = false;
                lspTraceRpt.result.retCode = 555798665;
            }
            lspTraceRpt.finished = LspTraceResult.STATUS_ENUM.FINISHED.intValue() == traceResult.getStatus().intValue();
            lspTraceRpt.tracertList = new QAsnTracertList();
            Collection lspTraceResultDetails = traceResult.getLspTraceResultDetails();
            if (null == lspTraceResultDetails) continue;
            for (LspTraceResultDetail traceResultDetail : lspTraceResultDetails) {
                QAsnTracert tracert = new QAsnTracert();
                tracert.neID = AsnUtil.intValue((Integer)traceResultDetail.getDevID());
                tracert.pktSeq = AsnUtil.intValue((Long)traceResultDetail.getHopIndex());
                tracert.midIp = AsnUtil.getBytes((String)traceResultDetail.getDsIpAddr());
                tracert.maxDelay = AsnUtil.intValue((Long)traceResultDetail.getRtt());
                tracert.minDelay = -1;
                tracert.avgDelay = -1;
                lspTraceRpt.tracertList.add((Object)tracert);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(65731, testCaseInfo.getTask(), (FStruct)lspTraceRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65731, (FStruct)lspTraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendPwe3PingRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCaseInfo) {
        QAsnPwe3PwPingRpt pwe3PingRpt = new QAsnPwe3PwPingRpt();
        Collection pwe3PingResults = queryContext.getQueryResult(Pwe3PingResult.class);
        if (null == pwe3PingResults) {
            return;
        }
        for (Pwe3PingResult pwe3Ping : pwe3PingResults) {
            pwe3PingRpt.sessionID = testCaseInfo.getSessionID().getBytes();
            pwe3PingRpt.testCaseID = testCaseInfo.getResID();
            pwe3PingRpt.pwPingResult.pwKey.neID = testCaseInfo.getDevID();
            pwe3PingRpt.pwPingResult.pwKey.strFDN = testCaseInfo.getFdn().getBytes();
            pwe3PingRpt.pwPingResult.pwKey.strMOC = "PW".getBytes();
            pwe3PingRpt.pwPingResult.pingStatistic.neID = AsnUtil.intValue((Integer)pwe3Ping.getDevID());
            pwe3PingRpt.pwPingResult.pingStatistic.txNum = AsnUtil.intValue((Long)pwe3Ping.getPacketSend());
            pwe3PingRpt.pwPingResult.pingStatistic.rxNum = AsnUtil.intValue((Long)pwe3Ping.getPacketRecv());
            pwe3PingRpt.pwPingResult.pingStatistic.txFailNum = -1;
            pwe3PingRpt.pwPingResult.pingStatistic.timeoutNum = -1;
            pwe3PingRpt.pwPingResult.pingStatistic.initFailNum = -1;
            pwe3PingRpt.pwPingResult.pingStatistic.lossRate = AsnUtil.intValue((Integer)pwe3Ping.getLossRatio()) * 100;
            pwe3PingRpt.pwPingResult.pingStatistic.minDelay = AsnUtil.intValue((Long)pwe3Ping.getRttMin());
            pwe3PingRpt.pwPingResult.pingStatistic.avgDelay = AsnUtil.intValue((Long)pwe3Ping.getRttAverage());
            pwe3PingRpt.pwPingResult.pingStatistic.maxDelay = AsnUtil.intValue((Long)pwe3Ping.getRttMax());
            if (0 == pwe3Ping.getErrorType()) {
                pwe3PingRpt.result.isSuccess = true;
                pwe3PingRpt.result.retCode = 0;
                if (0L == pwe3Ping.getPacketRecv()) {
                    pwe3PingRpt.result.isSuccess = false;
                    pwe3PingRpt.result.retCode = 555798761;
                }
            } else {
                pwe3PingRpt.result.isSuccess = false;
                pwe3PingRpt.result.retCode = 555798665;
            }
            pwe3PingRpt.finished = Pwe3PingResult.STATUS_ENUM.FINISHED.intValue() == pwe3Ping.getStatus().intValue();
            Collection pwe3PingDetails = pwe3Ping.getPwe3PingResultDetails();
            if (null == pwe3PingDetails) continue;
            for (Pwe3PingResultDetail pingDetail : pwe3PingDetails) {
                QAsnPing ping = new QAsnPing();
                ping.neID = testCaseInfo.getDevID();
                ping.destination = AsnUtil.getBytes((String)pingDetail.getDestIpAddr());
                ping.pktLen = AsnUtil.intValue((Long)pingDetail.getPacketSize());
                ping.pktSeq = AsnUtil.intValue((Long)pingDetail.getIndex());
                ping.ttl = AsnUtil.intValue((Integer)pingDetail.getTtl());
                ping.delay = AsnUtil.intValue((Long)pingDetail.getRtt());
                pwe3PingRpt.pwPingResult.pingList.add((Object)ping);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(65726, testCaseInfo.getTask(), (FStruct)pwe3PingRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65726, (FStruct)pwe3PingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendVplsPingRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCaseInfo) {
        QAsnPwe3PwPingRpt vplsPingRpt = new QAsnPwe3PwPingRpt();
        Collection vplsPingResults = queryContext.getQueryResult(VplsPingResult.class);
        if (null == vplsPingResults) {
            return;
        }
        for (VplsPingResult vplsPing : vplsPingResults) {
            vplsPingRpt.pwPingResult.pingStatistic.avgDelay = AsnUtil.intValue((Long)vplsPing.getRttAverage());
            vplsPingRpt.pwPingResult.pingStatistic.lossRate = AsnUtil.intValue((Integer)vplsPing.getLossRatio()) * 100;
            vplsPingRpt.pwPingResult.pingStatistic.maxDelay = AsnUtil.intValue((Long)vplsPing.getRttMax());
            vplsPingRpt.pwPingResult.pingStatistic.minDelay = AsnUtil.intValue((Long)vplsPing.getRttMin());
            vplsPingRpt.pwPingResult.pingStatistic.neID = AsnUtil.intValue((Integer)vplsPing.getDevID());
            vplsPingRpt.pwPingResult.pingStatistic.rxNum = AsnUtil.intValue((Long)vplsPing.getPacketRecv());
            vplsPingRpt.pwPingResult.pingStatistic.txNum = AsnUtil.intValue((Long)vplsPing.getPacketSend());
            Collection vplsPingDetails = vplsPing.getVplsPingResultDetails();
            if (null != vplsPingDetails) {
                for (VplsPingResultDetail pingDetail : vplsPingDetails) {
                    QAsnPing ping = new QAsnPing();
                    ping.delay = AsnUtil.intValue((Long)pingDetail.getRtt());
                    ping.destination = AsnUtil.getBytes((String)pingDetail.getDestIpAddr());
                    ping.neID = AsnUtil.intValue((Integer)pingDetail.getDevID());
                    ping.pktLen = AsnUtil.intValue((Long)pingDetail.getPacketSize());
                    ping.pktSeq = AsnUtil.intValue((Long)pingDetail.getIndex());
                    ping.ttl = AsnUtil.intValue((Integer)pingDetail.getTtl());
                    vplsPingRpt.pwPingResult.pingList.add((Object)ping);
                }
            }
            vplsPingRpt.sessionID = testCaseInfo.getSessionID().getBytes();
            vplsPingRpt.testCaseID = testCaseInfo.getResID();
        }
        DiagCommon.getInstance().sendAsysMessage(65726, testCaseInfo.getTask(), (FStruct)vplsPingRpt);
    }

    private void sendPwe3TraceRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCaseInfo) {
        QAsnPwe3PwTracertRpt pwe3TraceRpt = new QAsnPwe3PwTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)pwe3TraceRpt);
        Collection pwe3TraceResults = queryContext.getQueryResult(Pwe3TraceResult.class);
        if (null == pwe3TraceResults) {
            return;
        }
        for (Pwe3TraceResult pwe3Trace : pwe3TraceResults) {
            pwe3TraceRpt.sessionID = testCaseInfo.getSessionID().getBytes();
            pwe3TraceRpt.testCaseID = testCaseInfo.getResID();
            if (0 == pwe3Trace.getErrorType()) {
                pwe3TraceRpt.result.isSuccess = true;
                pwe3TraceRpt.result.retCode = 0;
            } else {
                pwe3TraceRpt.result.isSuccess = false;
                pwe3TraceRpt.result.retCode = 555798665;
            }
            pwe3TraceRpt.finished = Pwe3TraceResult.STATUS_ENUM.FINISHED.intValue() == pwe3Trace.getStatus().intValue();
            pwe3TraceRpt.pwTracertResult.pwKey.neID = testCaseInfo.getDevID();
            pwe3TraceRpt.pwTracertResult.pwKey.strFDN = testCaseInfo.getFdn().getBytes();
            pwe3TraceRpt.pwTracertResult.pwKey.strMOC = "PW".getBytes();
            Collection pwe3TraceDetails = pwe3Trace.getPwe3TraceResultDetails();
            if (null == pwe3TraceDetails) continue;
            for (Pwe3TraceResultDetail pwe3Detail : pwe3TraceDetails) {
                QAsnTracert trace = new QAsnTracert();
                trace.neID = AsnUtil.intValue((Integer)pwe3Detail.getDevID());
                trace.pktSeq = AsnUtil.intValue((Long)pwe3Detail.getIndex());
                trace.midIp = AsnUtil.getBytes((String)pwe3Detail.getDsIpAddr());
                trace.minDelay = -1;
                trace.maxDelay = AsnUtil.intValue((Long)pwe3Detail.getRtt());
                trace.avgDelay = -1;
                pwe3TraceRpt.pwTracertResult.tracertList.add((Object)trace);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(65727, testCaseInfo.getTask(), (FStruct)pwe3TraceRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65727, (FStruct)pwe3TraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendVplsTraceRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCaseInfo) {
        QAsnPwe3PwTracertRpt vplsTraceRpt = new QAsnPwe3PwTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)vplsTraceRpt);
        Collection vplsTraceResults = queryContext.getQueryResult(VplsTraceResult.class);
        if (null == vplsTraceResults) {
            return;
        }
        for (VplsTraceResult vplsTrace : vplsTraceResults) {
            vplsTraceRpt.sessionID = testCaseInfo.getSessionID().getBytes();
            vplsTraceRpt.testCaseID = testCaseInfo.getResID();
            vplsTraceRpt.poTestCaseNameInfo.strTestCaseName = testCaseInfo.getTestName().getBytes();
            Collection vplsTraceDetails = vplsTrace.getVplsTraceResultDetails();
            if (null == vplsTraceDetails) continue;
            for (VplsTraceResultDetail vplsTraceDetail : vplsTraceDetails) {
                QAsnTracert trace = new QAsnTracert();
                trace.maxDelay = AsnUtil.intValue((Long)vplsTraceDetail.getRtt());
                trace.midIp = AsnUtil.getBytes((String)vplsTraceDetail.getDestIpAddr());
                trace.neID = AsnUtil.intValue((Integer)vplsTraceDetail.getDevID());
                trace.pktSeq = AsnUtil.intValue((Long)vplsTraceDetail.getIndex());
                vplsTraceRpt.pwTracertResult.tracertList.add((Object)trace);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(65727, testCaseInfo.getTask(), (FStruct)vplsTraceRpt);
    }

    private void sendRingPingRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCaseInfo) {
        QAsnSPRingPingRpt ringPingRpt = new QAsnSPRingPingRpt();
        AsnUtil.setDefaultAsnValue((FStruct)ringPingRpt);
        Collection ringPingResults = queryContext.getQueryResult(RingPingResult.class);
        if (null == ringPingResults) {
            return;
        }
        for (RingPingResult ringPing : ringPingResults) {
            ringPingRpt.testCaseID = testCaseInfo.getResID();
            ringPingRpt.sessionID = testCaseInfo.getSessionID().getBytes();
            if (0 == ringPing.getErrorType()) {
                ringPingRpt.result.isSuccess = true;
                ringPingRpt.result.retCode = 0;
                if (0L == ringPing.getPacketRecv()) {
                    ringPingRpt.result.isSuccess = false;
                    ringPingRpt.result.retCode = 555798761;
                }
            } else {
                ringPingRpt.result.isSuccess = false;
                ringPingRpt.result.retCode = 555798665;
            }
            ringPingRpt.finished = RingPingResult.STATUS_ENUM.FINISHED.intValue() == ringPing.getStatus().intValue();
            ringPingRpt.statistic.neID = AsnUtil.intValue((Integer)ringPing.getDevID());
            ringPingRpt.statistic.txNum = AsnUtil.intValue((Long)ringPing.getPacketSend());
            ringPingRpt.statistic.rxNum = AsnUtil.intValue((Long)ringPing.getPacketRecv());
            ringPingRpt.statistic.txFailNum = AsnUtil.intValue((Long)(ringPing.getPacketSend() - ringPing.getPacketRecv()));
            ringPingRpt.statistic.lossRate = AsnUtil.intValue((Integer)ringPing.getLossRatio()) * 100;
            ringPingRpt.statistic.minDelay = AsnUtil.intValue((Long)ringPing.getRttMin());
            ringPingRpt.statistic.avgDelay = AsnUtil.intValue((Long)ringPing.getRttAverage());
            ringPingRpt.statistic.maxDelay = AsnUtil.intValue((Long)ringPing.getRttMax());
            Collection ringPingDetails = ringPing.getRingPingResultDetails();
            if (null == ringPingDetails) continue;
            for (RingPingResultDetail ringResultDetail : ringPingDetails) {
                QAsnSPRingPingRet ringPingRet = new QAsnSPRingPingRet();
                ringPingRet.direction = AsnUtil.intValue((Integer)ringPing.getRingDirect());
                ringPingRet.srcNodeID = AsnUtil.intValue((Integer)ringPing.getSrcNodeId());
                ringPingRet.destNodeID = AsnUtil.intValue((Integer)ringPing.getDstNodeId());
                ringPingRet.pktLen = AsnUtil.intValue((Long)ringResultDetail.getPacketSize());
                ringPingRet.pktSeq = AsnUtil.intValue((Long)ringResultDetail.getIndex());
                ringPingRet.ttl = AsnUtil.intValue((Integer)ringResultDetail.getTtl());
                ringPingRet.delay = AsnUtil.intValue((Long)ringResultDetail.getRtt());
                ringPingRet.ringKey.neID = AsnUtil.intValue((Integer)ringResultDetail.getDevID());
                ringPingRet.ringKey.strFDN = testCaseInfo.getFdn().getBytes();
                ringPingRet.ringKey.strMOC = "RING".getBytes();
                ringPingRpt.pingList.add((Object)ringPingRet);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(11536629, testCaseInfo.getTask(), (FStruct)ringPingRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(11536629, (FStruct)ringPingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendRingTraceRpt(QuerySchemaTranslatorContext queryContext, TestCaseInfo testCaseInfo) {
        QAsnSPRingTracertRpt ringTraceRpt = new QAsnSPRingTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)ringTraceRpt);
        Collection ringTraceResults = queryContext.getQueryResult(RingTraceResult.class);
        if (null == ringTraceResults) {
            return;
        }
        for (RingTraceResult ringTrace : ringTraceResults) {
            ringTraceRpt.sessionID = testCaseInfo.getSessionID().getBytes();
            ringTraceRpt.testCaseID = testCaseInfo.getResID();
            if (0 == ringTrace.getErrorType()) {
                ringTraceRpt.result.isSuccess = true;
                ringTraceRpt.result.retCode = 0;
            } else {
                ringTraceRpt.result.isSuccess = false;
                ringTraceRpt.result.retCode = 555798665;
            }
            ringTraceRpt.finished = RingTraceResult.STATUS_ENUM.FINISHED.intValue() == ringTrace.getStatus().intValue();
            Collection ringTraceDetails = ringTrace.getRingTraceResultDetails();
            if (null == ringTraceDetails) continue;
            for (RingTraceResultDetail ringTraceDetail : ringTraceDetails) {
                QAsnSPRingTracertRet trace = new QAsnSPRingTracertRet();
                trace.destNodeID = AsnUtil.intValue((Integer)ringTraceDetail.getDstNodeId());
                trace.rspNodeID = AsnUtil.intValue((Integer)ringTraceDetail.getRspNodeId());
                trace.nodeType = AsnUtil.intValue((Integer)ringTraceDetail.getType());
                trace.ttl = AsnUtil.intValue((Integer)ringTraceDetail.getTtl());
                trace.maxDelay = AsnUtil.intValue((Long)ringTraceDetail.getRtt());
                trace.avgDelay = -1;
                trace.minDelay = -1;
                trace.direction = ringTrace.getRingDirect();
                trace.ringKey.neID = testCaseInfo.getDevID();
                trace.ringKey.strFDN = testCaseInfo.getFdn().getBytes();
                trace.ringKey.strMOC = "RING".getBytes();
                ringTraceRpt.tracertList.add((Object)trace);
            }
        }
        DiagCommon.getInstance().sendAsysMessage(11536630, testCaseInfo.getTask(), (FStruct)ringTraceRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(11536630, (FStruct)ringTraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    public void notifyTestCaseError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        if (null == testCase) {
            return;
        }
        switch (testCase.getTestType()) {
            case 6: 
            case 100: {
                this.sendL3vpnPingError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 101: {
                this.sendL3vpnTraceError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 9: {
                this.sendLspPingError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 10: {
                this.sendLspTraceError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 14: {
                this.sendPwe3PingError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 15: {
                this.sendPwe3TraceError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 32: {
                this.sendPwe3PingError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 33: {
                this.sendPwe3TraceError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 1009: {
                this.sendRingPingError(testCase, iErrorCode, errorMsg);
                break;
            }
            case 1010: {
                this.sendRingTraceError(testCase, iErrorCode, errorMsg);
                break;
            }
        }
    }

    private void sendL3vpnPingError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        QAsnL3vpnPingRpt l3vpnPingRpt = new QAsnL3vpnPingRpt();
        AsnUtil.setDefaultAsnValue((FStruct)l3vpnPingRpt);
        l3vpnPingRpt.finished = 1;
        l3vpnPingRpt.result.retCode = iErrorCode;
        l3vpnPingRpt.result.isSuccess = false;
        if (null != errorMsg) {
            l3vpnPingRpt.result.reason = errorMsg;
        }
        l3vpnPingRpt.testCaseID = testCase.getResID();
        l3vpnPingRpt.sessionID = testCase.getSessionID().getBytes();
        DiagCommon.getInstance().sendAsysMessage(65728, testCase.getTask(), (FStruct)l3vpnPingRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65728, (FStruct)l3vpnPingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendL3vpnTraceError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        QAsnL3vpnTracertRpt l3vpnTraceRpt = new QAsnL3vpnTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)l3vpnTraceRpt);
        l3vpnTraceRpt.finished = 1;
        l3vpnTraceRpt.result.retCode = iErrorCode;
        l3vpnTraceRpt.result.isSuccess = false;
        if (null != errorMsg) {
            l3vpnTraceRpt.result.reason = errorMsg;
        }
        l3vpnTraceRpt.testCaseID = testCase.getResID();
        l3vpnTraceRpt.sessionID = testCase.getSessionID().getBytes();
        DiagCommon.getInstance().sendAsysMessage(65729, testCase.getTask(), (FStruct)l3vpnTraceRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65729, (FStruct)l3vpnTraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendLspPingError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        QAsnLspPingRpt lspPingRpt = new QAsnLspPingRpt();
        AsnUtil.setDefaultAsnValue((FStruct)lspPingRpt);
        lspPingRpt.finished = true;
        lspPingRpt.result.retCode = iErrorCode;
        lspPingRpt.result.isSuccess = false;
        if (null != errorMsg) {
            lspPingRpt.result.reason = errorMsg;
        }
        lspPingRpt.testCaseID = testCase.getResID();
        lspPingRpt.sessionID = testCase.getSessionID().getBytes();
        DiagCommon.getInstance().sendAsysMessage(65730, testCase.getTask(), (FStruct)lspPingRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65730, (FStruct)lspPingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendLspTraceError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        QAsnLspTracertRpt lspTraceRpt = new QAsnLspTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)lspTraceRpt);
        lspTraceRpt.finished = true;
        lspTraceRpt.result.retCode = iErrorCode;
        lspTraceRpt.result.isSuccess = false;
        if (null != errorMsg) {
            lspTraceRpt.result.reason = errorMsg;
        }
        lspTraceRpt.testCaseID = testCase.getResID();
        lspTraceRpt.sessionID = testCase.getSessionID().getBytes();
        DiagCommon.getInstance().sendAsysMessage(65731, testCase.getTask(), (FStruct)lspTraceRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65731, (FStruct)lspTraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendPwe3PingError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        QAsnPwe3PwPingRpt pwe3PingRpt = new QAsnPwe3PwPingRpt();
        AsnUtil.setDefaultAsnValue((FStruct)pwe3PingRpt);
        pwe3PingRpt.finished = true;
        pwe3PingRpt.result.retCode = iErrorCode;
        pwe3PingRpt.result.isSuccess = false;
        if (null != errorMsg) {
            pwe3PingRpt.result.reason = errorMsg;
        }
        pwe3PingRpt.testCaseID = testCase.getResID();
        pwe3PingRpt.sessionID = testCase.getSessionID().getBytes();
        DiagCommon.getInstance().sendAsysMessage(65726, testCase.getTask(), (FStruct)pwe3PingRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65726, (FStruct)pwe3PingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendPwe3TraceError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        QAsnPwe3PwTracertRpt pwe3TraceRpt = new QAsnPwe3PwTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)pwe3TraceRpt);
        pwe3TraceRpt.finished = true;
        pwe3TraceRpt.result.retCode = iErrorCode;
        pwe3TraceRpt.result.isSuccess = false;
        if (null != errorMsg) {
            pwe3TraceRpt.result.reason = errorMsg;
        }
        pwe3TraceRpt.testCaseID = testCase.getResID();
        pwe3TraceRpt.sessionID = testCase.getSessionID().getBytes();
        DiagCommon.getInstance().sendAsysMessage(65727, testCase.getTask(), (FStruct)pwe3TraceRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65727, (FStruct)pwe3TraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendRingPingError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        QAsnSPRingPingRpt ringPingRpt = new QAsnSPRingPingRpt();
        AsnUtil.setDefaultAsnValue((FStruct)ringPingRpt);
        ringPingRpt.finished = true;
        ringPingRpt.result.retCode = iErrorCode;
        ringPingRpt.result.isSuccess = false;
        if (null != errorMsg) {
            ringPingRpt.result.reason = errorMsg;
        }
        ringPingRpt.testCaseID = testCase.getResID();
        ringPingRpt.sessionID = testCase.getSessionID().getBytes();
        DiagCommon.getInstance().sendAsysMessage(11536629, testCase.getTask(), (FStruct)ringPingRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(11536629, (FStruct)ringPingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void sendRingTraceError(TestCaseInfo testCase, int iErrorCode, byte[] errorMsg) {
        QAsnSPRingTracertRpt ringTraceRpt = new QAsnSPRingTracertRpt();
        AsnUtil.setDefaultAsnValue((FStruct)ringTraceRpt);
        ringTraceRpt.finished = true;
        ringTraceRpt.result.retCode = iErrorCode;
        ringTraceRpt.result.isSuccess = false;
        if (null != errorMsg) {
            ringTraceRpt.result.reason = errorMsg;
        }
        ringTraceRpt.testCaseID = testCase.getResID();
        ringTraceRpt.sessionID = testCase.getSessionID().getBytes();
        DiagCommon.getInstance().sendAsysMessage(11536630, testCase.getTask(), (FStruct)ringTraceRpt);
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(11536630, (FStruct)ringTraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }
}

