/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.service;

import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnPing;
import com.huawei.network.qasn.m_q_ip_diagnose_model.QAsnTracert;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnLspPingRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnLspTracertRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnPwe3PwPingRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnPwe3PwTracertRpt;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.imap.IMessageSession;
import com.huawei.vmf.adapter.common.imap.MessageSessionFactory;
import com.huawei.vmf.adapter.common.utilty.IpAddressUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.common.NoReplyPingResultInfo;
import com.huawei.vmf.adapter.diagnose.common.NoReplyTraceResultInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.service.DiagResultApi;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class DiagNoReplyResultApi {
    private static final Logger LOGGER = RunLogger.getLogger(DiagResultApi.class);
    private static final DiagNoReplyResultApi INSTANCE = new DiagNoReplyResultApi();

    private DiagNoReplyResultApi() {
    }

    public static DiagNoReplyResultApi getInstance() {
        return INSTANCE;
    }

    public void sendLspPingRpt(DiagSchedulerMsg oDiagMsg, NoReplyPingResultInfo resultInfo) {
        QAsnLspPingRpt lspPingRpt = new QAsnLspPingRpt();
        lspPingRpt.sessionID = oDiagMsg.getTestCase().getSessionID().getBytes();
        lspPingRpt.testCaseID = oDiagMsg.getTestCase().getResID();
        if (0 == resultInfo.getRxNum()) {
            lspPingRpt.result.isSuccess = false;
            lspPingRpt.result.retCode = 555798761;
            lspPingRpt.result.reason = "".getBytes();
        } else {
            lspPingRpt.result.isSuccess = true;
            lspPingRpt.result.retCode = 0;
            lspPingRpt.result.reason = "".getBytes();
        }
        lspPingRpt.finished = true;
        lspPingRpt.statistic.neID = oDiagMsg.getDevID();
        lspPingRpt.statistic.rxNum = resultInfo.getRxNum();
        lspPingRpt.statistic.txNum = resultInfo.getTxNum();
        lspPingRpt.statistic.txFailNum = -1;
        lspPingRpt.statistic.timeoutNum = -1;
        lspPingRpt.statistic.initFailNum = -1;
        if (0 != lspPingRpt.statistic.txNum) {
            lspPingRpt.statistic.lossRate = (lspPingRpt.statistic.txNum - lspPingRpt.statistic.rxNum) * 10000 / lspPingRpt.statistic.txNum;
        }
        try {
            DiagCommon.getInstance().sendAsysMessage(65730, oDiagMsg.getTestCase().getTask(), (FStruct)lspPingRpt);
        }
        catch (Exception e) {
            LOGGER.error("DiagNoReplyScheduleCache sendLspPingRpt() sendAyncMessage() error." + e.getMessage());
        }
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65730, (FStruct)lspPingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    public void sendLspTraceRpt(DiagSchedulerMsg oDiagMsg, NoReplyTraceResultInfo resultInfo, NoReplyPingResultInfo ttlResultInfo) {
        QAsnLspTracertRpt lspTraceRpt = new QAsnLspTracertRpt();
        lspTraceRpt.sessionID = oDiagMsg.getTestCase().getSessionID().getBytes();
        lspTraceRpt.testCaseID = oDiagMsg.getTestCase().getResID();
        lspTraceRpt.result.isSuccess = true;
        lspTraceRpt.result.retCode = 0;
        lspTraceRpt.result.reason = "".getBytes();
        lspTraceRpt.finished = true;
        for (int iHop = 1; iHop <= ttlResultInfo.getTTL(); ++iHop) {
            QAsnTracert qasnTracert = new QAsnTracert();
            if (null == resultInfo.getMapHotResult()) continue;
            NoReplyPingResultInfo pingResult = resultInfo.getMapHotResult().get(String.valueOf(iHop));
            if (String.valueOf(pingResult.getDestLsrID()).equals("")) break;
            this.combineResult(oDiagMsg, resultInfo, pingResult, iHop, qasnTracert);
            lspTraceRpt.tracertList.add((Object)qasnTracert);
        }
        try {
            DiagCommon.getInstance().sendAsysMessage(65731, oDiagMsg.getTestCase().getTask(), (FStruct)lspTraceRpt);
        }
        catch (Exception e) {
            LOGGER.error("DiagNoReplyScheduleCache sendLspTraceRpt() sendAyncMessage() error." + e.getMessage());
        }
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65731, (FStruct)lspTraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    private void combineResult(DiagSchedulerMsg oDiagMsg, NoReplyTraceResultInfo resultInfo, NoReplyPingResultInfo ttlResultInfo, int iHop, QAsnTracert qasnTracert) {
        LOGGER.info("Enter into DiagNoReplyScheduleCache combineResult() and the srcTunnelID is:" + resultInfo.getKeyID());
        qasnTracert.neID = oDiagMsg.getDevID();
        qasnTracert.pktSeq = iHop;
        qasnTracert.midIp = IpAddressUtil.longAsIp((long)ttlResultInfo.getDestLsrID()).getBytes();
        qasnTracert.poiLossRatio = ttlResultInfo.getLossRate();
        qasnTracert.poiSentPackets = ttlResultInfo.getTxNum();
        qasnTracert.poiReceivedPackets = ttlResultInfo.getRxNum();
        qasnTracert.poResult = new QAsnSingleReturn();
        if (0 == qasnTracert.poiReceivedPackets) {
            qasnTracert.poResult.isSuccess = false;
            qasnTracert.poResult.retCode = 555798761;
        } else {
            qasnTracert.poResult.isSuccess = true;
            qasnTracert.poResult.retCode = 0;
        }
    }

    public void sendPwPingRpt(DiagSchedulerMsg oDiagMsg, NoReplyPingResultInfo resultInfo) {
        int iDevID;
        QAsnPwe3PwPingRpt pwPingRpt = new QAsnPwe3PwPingRpt();
        pwPingRpt.testCaseID = oDiagMsg.getTestCase().getResID();
        pwPingRpt.sessionID = oDiagMsg.getTestCase().getSessionID().getBytes();
        if (0 == resultInfo.getRxNum()) {
            pwPingRpt.result.isSuccess = false;
            pwPingRpt.result.retCode = 555798761;
            pwPingRpt.result.reason = "".getBytes();
        } else {
            pwPingRpt.result.isSuccess = true;
            pwPingRpt.result.retCode = 0;
            pwPingRpt.result.reason = "".getBytes();
        }
        pwPingRpt.finished = true;
        pwPingRpt.pwPingResult.pingStatistic.neID = iDevID = oDiagMsg.getTestCase().getDevID();
        pwPingRpt.pwPingResult.pingStatistic.txNum = resultInfo.getTxNum();
        pwPingRpt.pwPingResult.pingStatistic.rxNum = resultInfo.getRxNum();
        pwPingRpt.pwPingResult.pingStatistic.txFailNum = -1;
        pwPingRpt.pwPingResult.pingStatistic.timeoutNum = -1;
        pwPingRpt.pwPingResult.pingStatistic.initFailNum = -1;
        if (0 != pwPingRpt.pwPingResult.pingStatistic.txNum) {
            pwPingRpt.pwPingResult.pingStatistic.lossRate = (pwPingRpt.pwPingResult.pingStatistic.txNum - pwPingRpt.pwPingResult.pingStatistic.rxNum) * 10000 / pwPingRpt.pwPingResult.pingStatistic.txNum;
        }
        pwPingRpt.pwPingResult.pingStatistic.avgDelay = resultInfo.getAvgDelay();
        pwPingRpt.pwPingResult.pingStatistic.maxDelay = resultInfo.getMaxDelay();
        pwPingRpt.pwPingResult.pingStatistic.minDelay = resultInfo.getMinDelay();
        QAsnPing pwPing = new QAsnPing();
        pwPing.neID = iDevID;
        pwPing.destination = resultInfo.getDestIP().getBytes();
        pwPing.pktLen = -1;
        pwPing.pktSeq = -1;
        pwPing.ttl = resultInfo.getTTL();
        pwPing.delay = resultInfo.getMaxDelay();
        pwPingRpt.pwPingResult.pingList.add((Object)pwPing);
        pwPingRpt.pwPingResult.pwKey.neID = iDevID;
        pwPingRpt.pwPingResult.pwKey.strFDN = oDiagMsg.getTestCase().getFdn().getBytes();
        pwPingRpt.pwPingResult.pwKey.strMOC = "PW".getBytes();
        try {
            DiagCommon.getInstance().sendAsysMessage(65726, oDiagMsg.getTestCase().getTask(), (FStruct)pwPingRpt);
        }
        catch (Exception e) {
            LOGGER.error("DiagNoReplyScheduleCache sendPwPingRpt() sendAyncMessage() error." + e.getMessage());
        }
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65726, (FStruct)pwPingRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }

    public void sendPwTracertRpt(DiagSchedulerMsg oDiagMsg, NoReplyTraceResultInfo resultInfo, NoReplyPingResultInfo ttlResultInfo) {
        QAsnPwe3PwTracertRpt pwTraceRpt = new QAsnPwe3PwTracertRpt();
        pwTraceRpt.sessionID = oDiagMsg.getTestCase().getSessionID().getBytes();
        pwTraceRpt.testCaseID = oDiagMsg.getTestCase().getResID();
        pwTraceRpt.result.isSuccess = true;
        pwTraceRpt.result.retCode = 0;
        pwTraceRpt.result.reason = "".getBytes();
        pwTraceRpt.finished = true;
        pwTraceRpt.pwTracertResult.pwKey.neID = oDiagMsg.getTestCase().getDevID();
        pwTraceRpt.pwTracertResult.pwKey.strFDN = oDiagMsg.getTestCase().getFdn().getBytes();
        pwTraceRpt.pwTracertResult.pwKey.strMOC = "PW".getBytes();
        for (int iHop = 1; iHop <= ttlResultInfo.getTTL(); ++iHop) {
            QAsnTracert qasnTracert = new QAsnTracert();
            if (null == resultInfo.getMapHotResult()) continue;
            NoReplyPingResultInfo pingResult = resultInfo.getMapHotResult().get(String.valueOf(iHop));
            if (String.valueOf(pingResult.getDestLsrID()).equals("")) break;
            this.combineResult(oDiagMsg, resultInfo, pingResult, iHop, qasnTracert);
            pwTraceRpt.pwTracertResult.tracertList.add((Object)qasnTracert);
        }
        try {
            DiagCommon.getInstance().sendAsysMessage(65727, oDiagMsg.getTestCase().getTask(), (FStruct)pwTraceRpt);
        }
        catch (Exception e) {
            LOGGER.error("DiagNoReplyScheduleCache sendPwTracertRpt() sendAyncMessage() error." + e.getMessage());
        }
        try {
            IMessageSession session = MessageSessionFactory.getSession();
            session.sendReliableEvent(65727, (FStruct)pwTraceRpt);
        }
        catch (VMFException e) {
            LOGGER.error("session.sendReliableEvent sendRpt error. Msg:" + (Object)((Object)e));
        }
    }
}

