/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.translation.schema.ActionSchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv4PingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv4TraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv6PingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv6TraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.LspPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.LspTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Pwe3PingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Pwe3TraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.RingPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.RingTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.VplsPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.VplsTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteIp6Ping;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteIp6Trace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteIpPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteIpTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteLspPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteLspTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeletePwe3Ping;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeletePwe3Trace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteRingPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteRingTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteVplsPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteVplsTrace;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import org.slf4j.Logger;

public final class DiagDevService {
    private static final Logger LOGGER = RunLogger.getLogger(DiagDevService.class);
    public static final DiagDevService INSTANCE = new DiagDevService();

    private DiagDevService() {
    }

    public static DiagDevService getInstance() {
        return INSTANCE;
    }

    public QuerySchemaTranslatorContext queryTestResult(int iDevID, int iTestType, String strTestName) {
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(iDevID);
        DefaultMOService queryService = new DefaultMOService();
        switch (iTestType) {
            case 6: 
            case 100: {
                Ipv4PingResult ipPingResult = new Ipv4PingResult();
                ipPingResult.setDevID(Integer.valueOf(iDevID));
                ipPingResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)ipPingResult, null);
                break;
            }
            case 101: {
                Ipv4TraceResult ipTraceResult = new Ipv4TraceResult();
                ipTraceResult.setDevID(Integer.valueOf(iDevID));
                ipTraceResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)ipTraceResult, null);
                break;
            }
            case 11111: {
                Ipv6PingResult ip6PingResult = new Ipv6PingResult();
                ip6PingResult.setDevID(Integer.valueOf(iDevID));
                ip6PingResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)ip6PingResult, null);
                break;
            }
            case 22222: {
                Ipv6TraceResult ip6TraceResult = new Ipv6TraceResult();
                ip6TraceResult.setDevID(Integer.valueOf(iDevID));
                ip6TraceResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)ip6TraceResult, null);
                break;
            }
            case 9: {
                LspPingResult lspPingResult = new LspPingResult();
                lspPingResult.setDevID(Integer.valueOf(iDevID));
                lspPingResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)lspPingResult, null);
                break;
            }
            case 10: {
                LspTraceResult lspTraceResult = new LspTraceResult();
                lspTraceResult.setDevID(Integer.valueOf(iDevID));
                lspTraceResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)lspTraceResult, null);
                break;
            }
            case 14: {
                Pwe3PingResult pwe3PingResult = new Pwe3PingResult();
                pwe3PingResult.setDevID(Integer.valueOf(iDevID));
                pwe3PingResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)pwe3PingResult, null);
                break;
            }
            case 15: {
                Pwe3TraceResult pwe3TraceResult = new Pwe3TraceResult();
                pwe3TraceResult.setDevID(Integer.valueOf(iDevID));
                pwe3TraceResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)pwe3TraceResult, null);
                break;
            }
            case 32: {
                VplsPingResult vplsPingResult = new VplsPingResult();
                vplsPingResult.setDevID(Integer.valueOf(iDevID));
                vplsPingResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)vplsPingResult, null);
                break;
            }
            case 33: {
                VplsTraceResult vplsTraceResult = new VplsTraceResult();
                vplsTraceResult.setDevID(Integer.valueOf(iDevID));
                vplsTraceResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)vplsTraceResult, null);
                break;
            }
            case 1009: {
                RingPingResult ringPingResult = new RingPingResult();
                ringPingResult.setDevID(Integer.valueOf(iDevID));
                ringPingResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)ringPingResult, null);
                break;
            }
            case 1010: {
                RingTraceResult ringTraceResult = new RingTraceResult();
                ringTraceResult.setDevID(Integer.valueOf(iDevID));
                ringTraceResult.setTestName(strTestName);
                queryContext.addQueryAttributes(FeatureName.DGNTL, (VmfMO)ringTraceResult, null);
                break;
            }
        }
        queryService.addQueryJob(queryContext);
        try {
            queryService.poll();
        }
        catch (VMFException e) {
            LOGGER.error("Query ipPingResult failed,", (Object)e.getErrorMessage());
        }
        return queryContext;
    }

    public void deleteTestCase(int iDevID, int iTestType, String strTestName) {
        ActionSchemaTranslatorContext deleteContext = new ActionSchemaTranslatorContext(iDevID);
        DefaultMOService deleteService = new DefaultMOService();
        switch (iTestType) {
            case 6: 
            case 100: {
                DeleteIpPing deleteIpPing = new DeleteIpPing();
                deleteIpPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteIpPing);
                break;
            }
            case 101: {
                DeleteIpTrace deleteIpTrace = new DeleteIpTrace();
                deleteIpTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteIpTrace);
                break;
            }
            case 11111: {
                DeleteIp6Ping deleteIp6Ping = new DeleteIp6Ping();
                deleteIp6Ping.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteIp6Ping);
                break;
            }
            case 22222: {
                DeleteIp6Trace deleteIp6Trace = new DeleteIp6Trace();
                deleteIp6Trace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteIp6Trace);
                break;
            }
            case 9: {
                DeleteLspPing deleteLspPing = new DeleteLspPing();
                deleteLspPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteLspPing);
                break;
            }
            case 10: {
                DeleteLspTrace deleteLspTrace = new DeleteLspTrace();
                deleteLspTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteLspTrace);
                break;
            }
            case 14: {
                DeletePwe3Ping deletePwe3Ping = new DeletePwe3Ping();
                deletePwe3Ping.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deletePwe3Ping);
                break;
            }
            case 15: {
                DeletePwe3Trace deletePwe3Trace = new DeletePwe3Trace();
                deletePwe3Trace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deletePwe3Trace);
                break;
            }
            case 32: {
                DeleteVplsPing deleteVplsPing = new DeleteVplsPing();
                deleteVplsPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteVplsPing);
                break;
            }
            case 33: {
                DeleteVplsTrace deleteVplsTrace = new DeleteVplsTrace();
                deleteVplsTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteVplsTrace);
                break;
            }
            case 1009: {
                DeleteRingPing deleteRingPing = new DeleteRingPing();
                deleteRingPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteRingPing);
                break;
            }
            case 1010: {
                DeleteRingTrace deleteRingTrace = new DeleteRingTrace();
                deleteRingTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteRingTrace);
                break;
            }
        }
        deleteService.addActionJob(deleteContext);
        try {
            deleteService.execute();
        }
        catch (VMFException e) {
            LOGGER.error("DeleteIpPing execute failed", (Throwable)e);
        }
    }
}

