/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.scheduler;

import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagNoReplyScheduleCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerCache;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerQueue;
import com.huawei.vmf.adapter.diagnose.service.DiagResultApi;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class DiagSchedulerMsg
extends TimerTask {
    private static final Logger LOGGER = RunLogger.getLogger(DiagSchedulerMsg.class);
    private Boolean bTimeOut;
    private Boolean bStopped;
    private int iOpStatus;
    private TestCaseInfo oTestCase;
    private Boolean bNoReplyMode;
    private int iDevID;

    public DiagSchedulerMsg() {
        this.iOpStatus = 1;
        this.bStopped = false;
        this.bTimeOut = false;
        this.bNoReplyMode = false;
        this.iDevID = -1;
    }

    public DiagSchedulerMsg(int iDevID, TestCaseInfo oTestCase, boolean isNoReplyMode) {
        this.oTestCase = oTestCase;
        this.iOpStatus = 1;
        this.bStopped = false;
        this.bTimeOut = false;
        this.bNoReplyMode = isNoReplyMode;
        this.iDevID = iDevID;
    }

    @Override
    public void run() {
        this.doMsg();
    }

    private void doMsg() {
        LOGGER.info("Enter into doMsg(), m_bStopped is " + this.bStopped + " ,m_bTimeOut is " + this.bTimeOut + " ,iOpStatus is " + this.iOpStatus);
        if (this.bStopped.booleanValue()) {
            this.processStop();
            return;
        }
        if (this.bTimeOut.booleanValue()) {
            this.processTimeOut();
            return;
        }
        if (1 == this.iOpStatus) {
            this.processSet();
            return;
        }
        if (2 == this.iOpStatus) {
            this.processGet();
            return;
        }
        if (4 == this.iOpStatus) {
            this.processWait();
            return;
        }
        this.processOther();
    }

    public void timeOut() {
        this.bTimeOut = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSet() {
        LOGGER.info("Enter into processSet()...");
        if (null == this.oTestCase) {
            this.remove(this);
            return;
        }
        if (DiagSchedulerCache.getInstance().getToken(this.iDevID).booleanValue()) {
            try {
                ErrorInfo errorInfo = this.oTestCase.setOp();
                if (!AsnTranslatorUtil.isSuccess((ErrorInfo)errorInfo)) {
                    DiagResultApi result = new DiagResultApi();
                    if (null != errorInfo.getErrorMessage()) {
                        result.notifyTestCaseError(this.oTestCase, errorInfo.getErrorCode(), errorInfo.getErrorMessage().getBytes());
                    } else {
                        result.notifyTestCaseError(this.oTestCase, errorInfo.getErrorCode(), "TestCase execute failed".getBytes());
                    }
                    this.remove(this);
                    return;
                }
            }
            catch (VMFException e) {
                LOGGER.error("oTestCase.setOp() error, The errorCode is " + e.getErrorCode());
                DiagResultApi result = new DiagResultApi();
                result.notifyTestCaseError(this.oTestCase, e.getErrorCode(), e.getErrorMessage().getBytes());
                this.remove(this);
                return;
            }
            finally {
                DiagSchedulerCache.getInstance().releaseToken(this.iDevID);
            }
            this.oTestCase.setiExecBeginTime(System.currentTimeMillis());
            if (this.bStopped.booleanValue()) {
                this.remove(this);
                return;
            }
            this.iOpStatus = 2;
            DiagSchedulerQueue.getInstance().getGetQueue().schedule(this, (long)this.getTestCase().getGetFirstTime(), TimeUnit.SECONDS);
            if (this.bNoReplyMode.booleanValue()) {
                this.iOpStatus = 4;
            }
        } else {
            LOGGER.info("processSet getToken() failed, The DevID is " + this.iDevID + ", testName is " + this.oTestCase.getTestName());
            DiagSchedulerQueue.getInstance().getSetQueue().schedule(this, 1L, TimeUnit.SECONDS);
        }
    }

    private void processStop() {
        LOGGER.info("Enter into processStop();");
        this.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGet() {
        LOGGER.info("Enter into processGet().");
        if (null == this.oTestCase) {
            this.remove(this);
            return;
        }
        if (this.oTestCase.isTimeOut().booleanValue()) {
            this.timeOut();
            LOGGER.info("testCase is TimeOut. The testName is " + this.oTestCase.getTestName());
        }
        if (DiagSchedulerCache.getInstance().getToken(this.iDevID).booleanValue()) {
            QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(this.oTestCase.getDevID());
            try {
                ErrorInfo errorInfo = this.oTestCase.getOp(queryContext);
                if (!AsnTranslatorUtil.isSuccess((ErrorInfo)errorInfo)) {
                    DiagResultApi result = new DiagResultApi();
                    result.notifyTestCaseError(this.oTestCase, errorInfo.getErrorCode(), errorInfo.getErrorMessage().getBytes());
                    this.remove(this);
                    return;
                }
            }
            catch (VMFException e) {
                LOGGER.error("TestCaseInfo do getOp() error,", (Object)e.getErrorMessage());
                DiagResultApi result = new DiagResultApi();
                result.notifyTestCaseError(this.oTestCase, e.getErrorCode(), e.getErrorMessage().getBytes());
                this.remove(this);
                return;
            }
            finally {
                DiagSchedulerCache.getInstance().releaseToken(this.iDevID);
            }
            if (this.oTestCase.isFinished().booleanValue()) {
                LOGGER.info("The testCase " + this.oTestCase.getTestName() + " is finished.");
                DiagResultApi result = new DiagResultApi();
                result.notifyTestCaseResult(queryContext, this.oTestCase);
                this.remove(this);
                return;
            }
            if (this.bStopped.booleanValue()) {
                this.remove(this);
                return;
            }
            DiagSchedulerQueue.getInstance().getGetQueue().schedule(this, (long)this.oTestCase.getGetIntevalTime(), TimeUnit.SECONDS);
        } else {
            LOGGER.info("processGet  getToken() failed, The DevID is " + this.iDevID + " , testName is " + this.oTestCase.getTestName());
            DiagSchedulerQueue.getInstance().getGetQueue().schedule(this, 1L, TimeUnit.SECONDS);
        }
    }

    private void processWait() {
        LOGGER.info("Enter into processWait().");
        if (null == this.oTestCase) {
            LOGGER.error("do processWait(), this this.oTestCase is null.");
            this.remove(this);
            return;
        }
        long iNowTime = System.currentTimeMillis();
        long iTotalTime = (iNowTime - this.oTestCase.getiExecBeginTime()) / 1000L;
        LOGGER.error("iTotalTime is :" + iTotalTime + "; this.oTestCase.getiTimeOut()" + this.oTestCase.getiTimeOut());
        if (iTotalTime > (long)(this.oTestCase.getiTimeOut() + 60)) {
            this.timeOut();
            this.bTimeOut = true;
        }
        if (this.bStopped.booleanValue()) {
            this.remove(this);
            return;
        }
        DiagSchedulerQueue.getInstance().getGetQueue().schedule(this, (long)this.oTestCase.getGetIntevalTime(), TimeUnit.SECONDS);
    }

    private void processTimeOut() {
        LOGGER.info("Enter into processTimeOut().");
        if (null == this.oTestCase) {
            LOGGER.error("do processTimeOut(), this this.oTestCase is null.");
            this.remove(this);
            return;
        }
        DiagResultApi result = new DiagResultApi();
        result.notifyTestCaseError(this.oTestCase, 555798758, "".getBytes());
        this.remove(this);
    }

    private void processOther() {
        LOGGER.info("Enter into processOther().");
        if (null == this.oTestCase) {
            LOGGER.error("do processOther(), this this.oTestCase is null.");
            this.remove(this);
            return;
        }
        DiagResultApi result = new DiagResultApi();
        result.notifyTestCaseError(this.oTestCase, 555798665, "".getBytes());
        this.remove(this);
    }

    public void remove(DiagSchedulerMsg oMsg) {
        if (null == oMsg) {
            return;
        }
        TestCaseInfo testCase = oMsg.getTestCase();
        if (null == testCase) {
            return;
        }
        if (DiagSchedulerCache.getInstance().getToken(this.iDevID).booleanValue()) {
            testCase.delOp();
            DiagSchedulerCache.getInstance().releaseToken(this.iDevID);
            if (this.bNoReplyMode.booleanValue()) {
                DiagNoReplyScheduleCache.getInstance().remove(oMsg);
            } else {
                DiagSchedulerCache.getInstance().remove(oMsg);
            }
        } else {
            LOGGER.info("remove() getToken() failed, The DevID is " + this.iDevID + " , testName is " + testCase.getTestName());
            DiagSchedulerQueue.getInstance().getGetQueue().schedule(this, 1L, TimeUnit.SECONDS);
        }
    }

    public int getDevID() {
        return this.iDevID;
    }

    public void setDevID(int iDevID) {
        this.iDevID = iDevID;
    }

    public final Boolean getNoReplyMode() {
        return this.bNoReplyMode;
    }

    public void setNoReplyMode(Boolean bNoReplyMode) {
        this.bNoReplyMode = bNoReplyMode;
    }

    public TestCaseInfo getTestCase() {
        return this.oTestCase;
    }

    public void setoTestCase(TestCaseInfo oTestCase) {
        this.oTestCase = oTestCase;
    }

    public Boolean getStopped() {
        return this.bStopped;
    }

    public void setStopped(Boolean bStopped) {
        this.bStopped = bStopped;
    }

    public Boolean getTimeOut() {
        return this.bTimeOut;
    }

    public void setTimeOut(Boolean bTimeOut) {
        this.bTimeOut = bTimeOut;
    }

    public int getiOpStatus() {
        return this.iOpStatus;
    }

    public void setiOpStatus(int iOpStatus) {
        this.iOpStatus = iOpStatus;
    }
}

