/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.scheduler;

import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.diagnose.scheduler.DevHandler;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public final class DiagSchedulerCache {
    private static final Logger LOGGER = RunLogger.getLogger(DiagSchedulerCache.class);
    private static final DiagSchedulerCache INSTANCE = new DiagSchedulerCache();
    private static final int DEV_MAX_EXCUTE_NUMBER = 3;
    private static final int DEV_MIN_EXCUTE_NUMBER = 1;
    private final Map<String, DiagSchedulerMsg> MAPMSG = new HashMap<String, DiagSchedulerMsg>();
    private final Map<Integer, DevHandler> DEVMAP = new HashMap<Integer, DevHandler>();

    private DiagSchedulerCache() {
    }

    public static DiagSchedulerCache getInstance() {
        return INSTANCE;
    }

    public synchronized void push(DiagSchedulerMsg oDiagMsg) {
        if (null == oDiagMsg || null == oDiagMsg.getTestCase()) {
            return;
        }
        String strTestName = oDiagMsg.getTestCase().getTestName();
        this.MAPMSG.put(strTestName, oDiagMsg);
        DiagSchedulerQueue.getInstance().getSetQueue().execute(oDiagMsg);
        LOGGER.info("Enter into DiagSchedulerCache push(), The testName is " + strTestName);
    }

    public synchronized void remove(DiagSchedulerMsg oDiagMsg) {
        if (null == oDiagMsg || null == oDiagMsg.getTestCase()) {
            return;
        }
        String strTestName = oDiagMsg.getTestCase().getTestName();
        if (this.MAPMSG.containsKey(strTestName)) {
            this.MAPMSG.remove(strTestName);
        }
        LOGGER.info("Enter into DiagSchedulerCache remove(), The testName is " + strTestName);
    }

    public synchronized void stop(Collection<Integer> listResID) {
        if (CollectionUtils.isEmpty(listResID)) {
            return;
        }
        String strTestName = null;
        DiagSchedulerMsg oMsg = null;
        for (Integer resID : listResID) {
            strTestName = "NEDiag" + resID;
            if (!this.MAPMSG.containsKey(strTestName)) continue;
            oMsg = this.MAPMSG.get(strTestName);
            oMsg.setStopped(true);
            LOGGER.info("Enter into DiagSchedulerCache stop(), The testName is " + strTestName + " is stoped.");
        }
    }

    public synchronized Boolean getToken(int iDevID) {
        if (this.DEVMAP.containsKey(iDevID)) {
            DevHandler handler = this.DEVMAP.get(iDevID);
            int iRunning = handler.getRuningNum();
            if (3 > iRunning) {
                handler.setRuningNum(++iRunning);
                LOGGER.info("Enter into DiagSchedulerCache getToken(), The DevID is " + iDevID + ", iRunning = " + iRunning);
                return true;
            }
            return false;
        }
        DevHandler handler = new DevHandler();
        handler.setDevID(iDevID);
        handler.setRuningNum(1);
        this.DEVMAP.put(iDevID, handler);
        LOGGER.info("Enter into DiagSchedulerCache getToken(), The DevID is " + iDevID + ", iRunning = " + 1);
        return true;
    }

    public synchronized void releaseToken(int iDevID) {
        if (this.DEVMAP.containsKey(iDevID)) {
            DevHandler handler = this.DEVMAP.get(iDevID);
            int iRunning = handler.getRuningNum();
            if (1 > --iRunning) {
                this.DEVMAP.remove(iDevID);
            } else {
                handler.setRuningNum(iRunning);
            }
        }
    }
}

