/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.scheduler;

import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnPwNoReplyRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnTunnelNoReplyRpt;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.diagnose.common.NoReplyPingResultInfo;
import com.huawei.vmf.adapter.diagnose.common.NoReplyTraceResultInfo;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerMsg;
import com.huawei.vmf.adapter.diagnose.scheduler.DiagSchedulerQueue;
import com.huawei.vmf.adapter.diagnose.service.DiagNoReplyResultApi;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public final class DiagNoReplyScheduleCache {
    private static final DiagNoReplyScheduleCache INSTANCE = new DiagNoReplyScheduleCache();
    private static final Logger LOGGER = RunLogger.getLogger(DiagNoReplyScheduleCache.class);
    private static final Map<String, DiagSchedulerMsg> NOREPLYMSGMAP = new ConcurrentHashMap<String, DiagSchedulerMsg>();
    private static final Map<String, String> NOREPLYTESTIDMAP = new ConcurrentHashMap<String, String>();
    private static final Map<String, NoReplyPingResultInfo> NOREPLYPINGMAP = new ConcurrentHashMap<String, NoReplyPingResultInfo>();
    private static final Map<String, NoReplyTraceResultInfo> NOREPLYTRACEMAP = new ConcurrentHashMap<String, NoReplyTraceResultInfo>();

    private DiagNoReplyScheduleCache() {
    }

    public static DiagNoReplyScheduleCache getInstance() {
        return INSTANCE;
    }

    public synchronized void push(DiagSchedulerMsg oDiagMsg) {
        if (null == oDiagMsg || null == oDiagMsg.getTestCase()) {
            LOGGER.info("The oDiagMsg or oDiagMsg.getTestCase is NULL!");
            return;
        }
        LOGGER.info("Enter into DiagNoReplyScheduleCache push(), The testName is " + oDiagMsg.getTestCase().getTestName());
        String testName = oDiagMsg.getTestCase().getTestName();
        String strKeyID = oDiagMsg.getTestCase().getKeyID();
        NOREPLYMSGMAP.put(strKeyID, oDiagMsg);
        NOREPLYTESTIDMAP.put(testName, strKeyID);
        if (oDiagMsg.getTestCase().getPingOrTraceType() == 1) {
            NoReplyPingResultInfo resultInfo = new NoReplyPingResultInfo();
            resultInfo.setKeyID(Integer.valueOf(strKeyID));
            resultInfo.setTxNum(oDiagMsg.getTestCase().getProbeCount());
            resultInfo.setStartTime(System.currentTimeMillis() / 1000L);
            resultInfo.setLastRecTime(resultInfo.getStartTime());
            NOREPLYPINGMAP.put(strKeyID, resultInfo);
        } else {
            NoReplyTraceResultInfo resultInfo = new NoReplyTraceResultInfo();
            resultInfo.setKeyID(Integer.valueOf(strKeyID));
            resultInfo.setTxNum(oDiagMsg.getTestCase().getProbeCount());
            resultInfo.setStartTime(System.currentTimeMillis() / 1000L);
            resultInfo.setLastRecTime(resultInfo.getStartTime());
            resultInfo.setMaxTTL(oDiagMsg.getTestCase().getMaxTtl());
            resultInfo.setDestLsrID(oDiagMsg.getTestCase().getDestLsrID());
            resultInfo.setDestIP(oDiagMsg.getTestCase().getDestIP());
            NOREPLYTRACEMAP.put(strKeyID, resultInfo);
        }
        DiagSchedulerQueue.getInstance().getSetQueue().execute(oDiagMsg);
    }

    public synchronized void remove(DiagSchedulerMsg oDiagMsg) {
        if (null == oDiagMsg || null == oDiagMsg.getTestCase()) {
            LOGGER.info("The oDiagMsg or oDiagMsg.getTestCase is NULL!");
            return;
        }
        LOGGER.info("Enter into DiagNoReplyScheduleCache remove(), The testName is " + oDiagMsg.getTestCase().getTestName());
        String strTestName = oDiagMsg.getTestCase().getTestName();
        String strKeyID = oDiagMsg.getTestCase().getKeyID();
        NOREPLYMSGMAP.remove(strKeyID);
        NOREPLYTESTIDMAP.remove(strTestName);
        NOREPLYPINGMAP.remove(strKeyID);
        NOREPLYTRACEMAP.remove(strKeyID);
    }

    public boolean isInCache(String strKeyID) {
        return NOREPLYMSGMAP.containsKey(strKeyID);
    }

    public synchronized void updateLspPingResult(QAsnTunnelNoReplyRpt rpt) {
        LOGGER.info("Enter into DiagNoReplyScheduleCache updateLspPingResult(), The QAsnTunnelNoReplyRpt is " + rpt);
        if (null == rpt) {
            return;
        }
        DiagSchedulerMsg oDiagMsg = null;
        String strKeyID = String.valueOf(rpt.iIndex);
        oDiagMsg = NOREPLYMSGMAP.get(strKeyID);
        if (null == oDiagMsg) {
            return;
        }
        NoReplyPingResultInfo resultInfo = NOREPLYPINGMAP.get(strKeyID);
        if (null == resultInfo) {
            return;
        }
        long iNowTime = System.currentTimeMillis() / 1000L;
        long iTimeDelay = iNowTime - resultInfo.getLastRecTime();
        resultInfo.setLastRecTime(iNowTime);
        this.calcDelayAndRecNum(iTimeDelay, resultInfo);
        long iCostTime = iNowTime - resultInfo.getStartTime();
        int iTimeout = oDiagMsg.getTestCase().getiTimeOut();
        if (resultInfo.getRxNum() == resultInfo.getTxNum() || iCostTime >= (long)iTimeout) {
            DiagNoReplyResultApi.getInstance().sendLspPingRpt(oDiagMsg, resultInfo);
            this.remove(oDiagMsg);
        } else {
            NOREPLYPINGMAP.put(strKeyID, resultInfo);
        }
    }

    public synchronized void updateLspTraceResult(QAsnTunnelNoReplyRpt rpt) {
        LOGGER.info("Enter into DiagNoReplyScheduleCache updateLspTraceResult() and the QAsnTunnelNoReplyRpt is:" + rpt);
        if (null == rpt) {
            return;
        }
        DiagSchedulerMsg oDiagMsg = null;
        String strKeyID = String.valueOf(rpt.iIndex);
        oDiagMsg = NOREPLYMSGMAP.get(strKeyID);
        if (null == oDiagMsg) {
            return;
        }
        NoReplyTraceResultInfo resultInfo = NOREPLYTRACEMAP.get(strKeyID);
        if (null == resultInfo) {
            return;
        }
        long iNowTime = System.currentTimeMillis() / 1000L;
        long iTimeDelay = iNowTime - resultInfo.getLastRecTime();
        long iCostTime = iNowTime - resultInfo.getStartTime();
        resultInfo.setLastRecTime(iNowTime);
        NoReplyPingResultInfo ttlResultInfo = this.initHopResultInfo(rpt.dstlsrID.toString(), strKeyID, resultInfo, iTimeDelay);
        int iTimeout = oDiagMsg.getTestCase().getiTimeOut();
        LOGGER.info("ttlResultInfo.getRxNum():" + ttlResultInfo.getRxNum() + " ; rpt.dstlsrID" + rpt.dstlsrID + "; resultInfo.getDestLsrID()" + resultInfo.getDestLsrID() + "; resultInfo.getMaxTTL()" + resultInfo.getMaxTTL() + "; iCostTime" + iCostTime + "; iTimeout" + iTimeout);
        if (ttlResultInfo.getRxNum() == resultInfo.getMaxTTL() && (long)Integer.valueOf(String.valueOf(rpt.dstlsrID)).intValue() == resultInfo.getDestLsrID() || iCostTime >= (long)iTimeout) {
            DiagNoReplyResultApi.getInstance().sendLspTraceRpt(oDiagMsg, resultInfo, ttlResultInfo);
            this.remove(oDiagMsg);
        } else {
            NOREPLYTRACEMAP.put(strKeyID, resultInfo);
        }
    }

    private synchronized NoReplyPingResultInfo initHopResultInfo(String strDstLsrID, String strKeyID, NoReplyTraceResultInfo traceResult, long iTimeDelay) {
        LOGGER.info("Enter into DiagNoReplyScheduleCache initHopResultInfo()");
        NoReplyPingResultInfo ttlResultInfo = new NoReplyPingResultInfo();
        Map<String, NoReplyPingResultInfo> mapHotResult = traceResult.getMapHotResult();
        String strTtl = "";
        int iRxNum = 1;
        if (null != mapHotResult && !mapHotResult.isEmpty()) {
            strTtl = String.valueOf(mapHotResult.size() + 1);
            iRxNum = mapHotResult.size() + 1;
        } else {
            strTtl = String.valueOf(1);
        }
        ttlResultInfo.setTTL(Integer.valueOf(strTtl));
        ttlResultInfo.setKeyID(Integer.valueOf(strKeyID));
        ttlResultInfo.setTxNum(traceResult.getTxNum());
        ttlResultInfo.setRxNum(iRxNum);
        LOGGER.info("The iRxNum is " + iRxNum);
        ttlResultInfo.setDestLsrID(Integer.valueOf(strDstLsrID));
        if (null == mapHotResult) {
            mapHotResult = new HashMap<String, NoReplyPingResultInfo>();
        }
        mapHotResult.put(strTtl, ttlResultInfo);
        traceResult.setMapHotResult(mapHotResult);
        return ttlResultInfo;
    }

    public void calcDelayAndRecNum(long iTimeDelay, NoReplyPingResultInfo resultInfo) {
        if (-1 == resultInfo.getRxNum()) {
            resultInfo.setRxNum(1);
            resultInfo.setMaxDelay((int)iTimeDelay);
            resultInfo.setMinDelay((int)iTimeDelay);
            resultInfo.setAvgDelay((int)iTimeDelay);
            resultInfo.setTotalDelay((int)iTimeDelay);
        } else {
            resultInfo.setRxNum(resultInfo.getRxNum() + 1);
            if (iTimeDelay > (long)resultInfo.getMaxDelay()) {
                resultInfo.setMaxDelay((int)iTimeDelay);
            }
            if (iTimeDelay < (long)resultInfo.getMinDelay()) {
                resultInfo.setMinDelay((int)iTimeDelay);
            }
            resultInfo.setTotalDelay(resultInfo.getTotalDelay() + (int)iTimeDelay);
        }
        if (resultInfo.getTxNum() >= 1) {
            resultInfo.setLossRate((resultInfo.getTxNum() - resultInfo.getRxNum()) * 10000 / resultInfo.getTxNum());
        }
    }

    public synchronized void updatePwPingResult(QAsnPwNoReplyRpt rpt) {
        LOGGER.info("Enter into DiagNoReplyScheduleCache updatePwPingResult(), The QAsnPwNoReplyRpt is " + rpt);
        if (null == rpt) {
            return;
        }
        DiagSchedulerMsg oDiagMsg = null;
        String strKeyID = String.valueOf(rpt.iIndex);
        oDiagMsg = NOREPLYMSGMAP.get(strKeyID);
        if (null == oDiagMsg) {
            return;
        }
        NoReplyPingResultInfo resultInfo = NOREPLYPINGMAP.get(strKeyID);
        if (null == resultInfo) {
            return;
        }
        long iNowTime = System.currentTimeMillis() / 1000L;
        long iTimeDelay = iNowTime - resultInfo.getLastRecTime();
        resultInfo.setLastRecTime(iNowTime);
        this.calcDelayAndRecNum(iTimeDelay, resultInfo);
        long iCostTime = iNowTime - resultInfo.getStartTime();
        int iTimeout = oDiagMsg.getTestCase().getiTimeOut();
        if (resultInfo.getRxNum() == resultInfo.getTxNum() || iCostTime >= (long)iTimeout) {
            DiagNoReplyResultApi.getInstance().sendPwPingRpt(oDiagMsg, resultInfo);
            this.remove(oDiagMsg);
        } else {
            NOREPLYPINGMAP.put(strKeyID, resultInfo);
        }
    }

    public synchronized void updatePwTracertResult(QAsnPwNoReplyRpt rpt) {
        LOGGER.info("Enter into DiagNoReplyScheduleCache updatePwTracertResult() and the QAsnPwNoReplyRpt is:" + rpt);
        if (null == rpt) {
            return;
        }
        DiagSchedulerMsg oDiagMsg = null;
        String strKeyID = String.valueOf(rpt.iIndex);
        oDiagMsg = NOREPLYMSGMAP.get(strKeyID);
        if (null == oDiagMsg) {
            return;
        }
        NoReplyTraceResultInfo resultInfo = NOREPLYTRACEMAP.get(strKeyID);
        if (null == resultInfo) {
            return;
        }
        long iNowTime = System.currentTimeMillis() / 1000L;
        long iTimeDelay = iNowTime - resultInfo.getLastRecTime();
        long iCostTime = iNowTime - resultInfo.getStartTime();
        resultInfo.setLastRecTime(iNowTime);
        NoReplyPingResultInfo ttlResultInfo = this.initHopResultInfo(rpt.dstlsrID.toString(), strKeyID, resultInfo, iTimeDelay);
        int iTimeout = oDiagMsg.getTestCase().getiTimeOut();
        if (ttlResultInfo.getRxNum() == ttlResultInfo.getTxNum() && (long)Integer.valueOf(String.valueOf(rpt.dstlsrID)).intValue() == resultInfo.getDestLsrID() || ttlResultInfo.getRxNum() <= ttlResultInfo.getTxNum() && ttlResultInfo.getTTL() == resultInfo.getMaxTTL() || iCostTime >= (long)iTimeout) {
            DiagNoReplyResultApi.getInstance().sendPwTracertRpt(oDiagMsg, resultInfo, ttlResultInfo);
            this.remove(oDiagMsg);
        } else {
            NOREPLYTRACEMAP.put(strKeyID, resultInfo);
        }
    }
}

