/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.nofaulttrap;

import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnPwNoReplyRpt;
import com.huawei.network.qasn.m_q_ip_diagnose_op.QAsnTunnelNoReplyRpt;
import com.huawei.vmf.adapter.common.utilty.IpAddressUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.diagnose.Activator;
import com.huawei.vmf.adapter.diagnose.common.DiagCommon;
import com.huawei.vmf.adapter.diagnose.task.NoReplyLspTask;
import com.huawei.vmf.adapter.diagnose.task.NoReplyPwTask;
import com.huawei.vmf.adapter.diagnose.util.DiagnoseUtil;
import com.huawei.vmf.adapter.framework.trapadmin.FaultUtil;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.fservice.mpls.service.IMplsService;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class NeDiagNoFaultTrap
implements IFaultListener {
    private static final Logger LOGGER = RunLogger.getLogger(NeDiagNoFaultTrap.class);

    public void handle(List<AsnForwardFaultRptStrc> alarms) {
        LOGGER.info("Enter into NeDiagNoFaultTrap handle()" + alarms.size());
        if (alarms.isEmpty()) {
            return;
        }
        for (AsnForwardFaultRptStrc trap : alarms) {
            int faultId = trap.sFaultID.intValue();
            List paramList = FaultUtil.getParaList((AsnForwardFaultRptStrc)trap);
            int iDevID = FaultUtil.getDevIdFromAlarm((AsnForwardFaultRptStrc)trap);
            LOGGER.info("The NoreplyNeDiagAlarm datail is:" + paramList);
            if (paramList.isEmpty()) continue;
            if (153620558 == faultId || 153620557 == faultId) {
                this.parseLspAlarm(faultId, paramList, iDevID);
                continue;
            }
            if (153620564 == faultId || 153620563 == faultId) {
                this.parsePwAlarm(faultId, paramList, iDevID);
                continue;
            }
            LOGGER.info(String.format("ignore alarm-id %d", faultId));
        }
    }

    private BigInteger converString(String strValue) {
        int intValue = -1;
        if (!strValue.isEmpty()) {
            intValue = Integer.parseInt(strValue);
        }
        return BigInteger.valueOf(intValue);
    }

    private void parseLspAlarm(int faultId, List<String> paramList, int iDevID) {
        String strTunnelID = "";
        String strSrcLsrID = "";
        String strDestLsrID = "";
        String strTtl = "";
        String strHandleID = "";
        strTunnelID = paramList.get(0);
        strSrcLsrID = paramList.get(1);
        strDestLsrID = paramList.get(2);
        strTtl = paramList.get(3);
        strHandleID = paramList.get(4);
        QAsnTunnelNoReplyRpt rpt = new QAsnTunnelNoReplyRpt();
        rpt.dstlsrID = this.converString(strDestLsrID);
        rpt.srclsrID = this.converString(strSrcLsrID);
        rpt.srcTunnelID = this.converString(strTunnelID);
        rpt.iTtl = this.converString(strTtl);
        rpt.iIndex = this.converString(strHandleID);
        if (153620558 == faultId) {
            rpt.iDiagType = BigInteger.valueOf(1L);
        } else if (153620557 == faultId) {
            rpt.iDiagType = BigInteger.valueOf(2L);
            String strLsrID = this.queryLsrIDByDevID(iDevID);
            try {
                rpt.dstlsrID = BigInteger.valueOf(IpAddressUtil.ipAsLong((String)strLsrID));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        this.sendTunnelNoReplyRpt(rpt);
    }

    private String queryLsrIDByDevID(int iDevID) {
        LOGGER.info("Enter into queryLsrIDByDevID and the DevID :" + iDevID);
        ArrayList<Integer> devIds = new ArrayList<Integer>();
        IMplsService mplsService = Activator.getService(IMplsService.class);
        devIds.add(iDevID);
        Map mapDevIDLsrID = new HashMap();
        try {
            mapDevIDLsrID = mplsService.queryLsrIDByDevID(devIds);
        }
        catch (Exception e) {
            // empty catch block
        }
        String strLsrID = "";
        if (null != mapDevIDLsrID) {
            strLsrID = (String)mapDevIDLsrID.get(iDevID);
        }
        LOGGER.info("Enter into queryLsrIDByDevID and the LsrID :" + strLsrID);
        return strLsrID;
    }

    private void parsePwAlarm(int faultId, List<String> paramList, int iDevID) {
        String strPwSndPeAddr = "";
        String strPwRmtPeAddr = "";
        String strPwType = "";
        String strPwTtl = "";
        String strPwHandle = "";
        strPwSndPeAddr = paramList.get(0);
        strPwRmtPeAddr = paramList.get(1);
        strPwType = paramList.get(3);
        strPwTtl = paramList.get(4);
        strPwHandle = paramList.get(5);
        QAsnPwNoReplyRpt rpt = new QAsnPwNoReplyRpt();
        rpt.dstlsrID = this.converString(strPwRmtPeAddr);
        rpt.srclsrID = this.converString(strPwSndPeAddr);
        rpt.iTtl = this.converString(strPwTtl);
        rpt.iIndex = this.converString(strPwHandle);
        rpt.iDiagType = this.converString(strPwType);
        if (153620564 == faultId) {
            rpt.iDiagType = BigInteger.valueOf(1L);
        } else if (153620563 == faultId) {
            rpt.iDiagType = BigInteger.valueOf(2L);
            String strLsrID = this.queryLsrIDByDevID(iDevID);
            rpt.dstlsrID = BigInteger.valueOf(DiagnoseUtil.ipToNumber(strLsrID));
        }
        this.sendPwNoReplyRpt(rpt);
    }

    private void sendTunnelNoReplyRpt(QAsnTunnelNoReplyRpt rpt) {
        if (NoReplyLspTask.getInstance().isInNoReplyTestCaseCache(rpt).booleanValue()) {
            NoReplyLspTask.getInstance().receiveNoReplyResult(rpt);
        } else {
            try {
                DiagCommon.getInstance().sendBroadcastMessage(11536585, (FStruct)rpt);
            }
            catch (Exception e) {
                LOGGER.error("NeDiagNoFaultTrap handle() session.sendAyncMessage() error." + e.getMessage());
            }
        }
    }

    private void sendPwNoReplyRpt(QAsnPwNoReplyRpt rpt) {
        if (NoReplyPwTask.getInstance().isInNoReplyTestCaseCache(rpt).booleanValue()) {
            NoReplyPwTask.getInstance().receiveNoReplyResult(rpt);
        } else {
            try {
                DiagCommon.getInstance().sendBroadcastMessage(0xB00B22, (FStruct)rpt);
            }
            catch (Exception e) {
                LOGGER.error("NeDiagNoFaultTrap handle() session.sendAyncMessage() error." + e.getMessage());
            }
        }
    }
}

