/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.common;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.diagnose.common.TestCaseFactory;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.IMOService;
import com.huawei.vmf.adapter.framework.translation.schema.ActionSchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartIpPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartIpTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartLspPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartLspTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartPwe3Ping;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartPwe3Trace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartRingPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartRingTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartVplsPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StartVplsTrace;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import org.slf4j.Logger;

public class TestCaseInfo {
    private static final Logger LOGGER = RunLogger.getLogger(TestCaseInfo.class);
    private Task task;
    private String testName;
    private int iResID;
    private String sessionID;
    private int devID;
    private String fdn;
    private int testType;
    private int iTimeOut;
    private int iGetFirstTime;
    private int iGetIntevalTime;
    private long iExecBeginTime;
    private int iExcuteMode = -1;
    private String keyID;
    private int pingOrTraceType;
    private int probeCount;
    private int maxTtl;
    private long iDestLsrID;
    private String strDestIP;
    private StartIpPing moIpPing = null;
    private StartIpTrace moIpTrace = null;
    private StartLspTrace moLspTrace = null;
    private StartLspPing moLspPing = null;
    private StartPwe3Ping moPwe3Ping = null;
    private StartPwe3Trace moPwe3Trace = null;
    private StartVplsPing moVplsPing = null;
    private StartVplsTrace moVplsTrace = null;
    private StartRingPing moRingPing = null;
    private StartRingTrace moRingTrace = null;
    private Boolean isFinished = false;

    public Boolean equal(TestCaseInfo info) {
        return this.testName.equals(info.getTestName()) && this.sessionID.equals(info.getSessionID());
    }

    public ErrorInfo setOp() throws VMFException {
        LOGGER.info("Enter into setOp().");
        DefaultMOService moService = new DefaultMOService();
        ErrorInfo errorInfo = null;
        ActionSchemaTranslatorContext actionContext = new ActionSchemaTranslatorContext(this.devID);
        switch (this.testType) {
            case 6: 
            case 100: {
                errorInfo = this.setMO(this.moIpPing, actionContext, (IMOService)moService);
                break;
            }
            case 101: {
                errorInfo = this.setMO(this.moIpTrace, actionContext, (IMOService)moService);
                break;
            }
            case 9: {
                errorInfo = this.setMO(this.moLspPing, actionContext, (IMOService)moService);
                break;
            }
            case 10: {
                errorInfo = this.setMO(this.moLspTrace, actionContext, (IMOService)moService);
                break;
            }
            case 14: {
                errorInfo = this.setMO(this.moPwe3Ping, actionContext, (IMOService)moService);
                break;
            }
            case 15: {
                errorInfo = this.setMO(this.moPwe3Trace, actionContext, (IMOService)moService);
                break;
            }
            case 1009: {
                errorInfo = this.setMO(this.moRingPing, actionContext, (IMOService)moService);
                break;
            }
            case 1010: {
                errorInfo = this.setMO(this.moRingTrace, actionContext, (IMOService)moService);
                break;
            }
        }
        return errorInfo;
    }

    private <T extends VmfMO> ErrorInfo setMO(T objectMo, ActionSchemaTranslatorContext actionContext, IMOService moService) throws VMFException {
        actionContext.addAction(FeatureName.DGNTL, objectMo);
        moService.addActionJob(actionContext);
        try {
            moService.execute();
        }
        catch (VMFException e) {
            LOGGER.error("moService.execute() failed", (Object)e.getErrorMessage());
        }
        ErrorInfo errorInfo = moService.getErrorInfo(objectMo);
        return errorInfo;
    }

    public int stopOp() {
        LOGGER.info("Enter into stopOp().");
        ActionSchemaTranslatorContext deleteContext = new ActionSchemaTranslatorContext(this.devID);
        DefaultMOService stopService = new DefaultMOService();
        TestCaseFactory.getInstance().getStopMo(deleteContext, this.testType, this.testName);
        stopService.addActionJob(deleteContext);
        try {
            stopService.execute();
        }
        catch (VMFException e) {
            LOGGER.error("stopOp stopService.execute() failed", (Object)e.getErrorMessage());
            return e.getErrorCode();
        }
        return 0;
    }

    public long delOp() {
        LOGGER.info("Enter into delOp().");
        ActionSchemaTranslatorContext deleteContext = new ActionSchemaTranslatorContext(this.devID);
        DefaultMOService deleteService = new DefaultMOService();
        TestCaseFactory.getInstance().getDeleteMO(deleteContext, this.testType, this.testName);
        deleteService.addActionJob(deleteContext);
        try {
            deleteService.execute();
        }
        catch (VMFException e) {
            LOGGER.error("delOp deleteService.execute() failed", (Object)e.getErrorMessage());
            return e.getErrorCode();
        }
        return 0L;
    }

    public ErrorInfo getOp(QuerySchemaTranslatorContext queryContext) throws VMFException {
        ErrorInfo errorInfo = TestCaseFactory.getInstance().getResultMo(queryContext, this.testType, this.devID, this.testName);
        this.isFinished = TestCaseFactory.getInstance().isTestFinished(queryContext, this.testType);
        return errorInfo;
    }

    public Boolean isTimeOut() {
        long iNowTime = System.currentTimeMillis();
        if ((iNowTime - this.iExecBeginTime) / 1000L > (long)(this.getiTimeOut() + 60)) {
            LOGGER.error("TestCaseInfo isTimeOut(), timeout is true.");
            return true;
        }
        return false;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public StartRingPing getMoRingPing() {
        return this.moRingPing;
    }

    public void setMoRingPing(StartRingPing moRingPing) {
        this.moRingPing = moRingPing;
    }

    public StartRingTrace getMoRingTrace() {
        return this.moRingTrace;
    }

    public void setMoRingTrace(StartRingTrace moRingTrace) {
        this.moRingTrace = moRingTrace;
    }

    public int getResID() {
        return this.iResID;
    }

    public void setResID(int iResID) {
        this.iResID = iResID;
    }

    public StartIpTrace getMoIpTrace() {
        return this.moIpTrace;
    }

    public void setMoIpTrace(StartIpTrace moIpTrace) {
        this.moIpTrace = moIpTrace;
    }

    public StartLspTrace getMoLspTrace() {
        return this.moLspTrace;
    }

    public void setMoLspTrace(StartLspTrace moLspTrace) {
        this.moLspTrace = moLspTrace;
    }

    public StartLspPing getMoLspPing() {
        return this.moLspPing;
    }

    public void setMoLspPing(StartLspPing moLspPing) {
        this.moLspPing = moLspPing;
    }

    public StartPwe3Ping getMoPwe3Ping() {
        return this.moPwe3Ping;
    }

    public void setMoPwe3Ping(StartPwe3Ping moPwe3Ping) {
        this.moPwe3Ping = moPwe3Ping;
    }

    public StartPwe3Trace getMoPwe3Trace() {
        return this.moPwe3Trace;
    }

    public void setMoPwe3Trace(StartPwe3Trace moPwe3Trace) {
        this.moPwe3Trace = moPwe3Trace;
    }

    public StartVplsPing getMoVplsPing() {
        return this.moVplsPing;
    }

    public void setMoVplsPing(StartVplsPing moVplsPing) {
        this.moVplsPing = moVplsPing;
    }

    public StartVplsTrace getMoVplsTrace() {
        return this.moVplsTrace;
    }

    public void setMoVplsTrace(StartVplsTrace moVplsTrace) {
        this.moVplsTrace = moVplsTrace;
    }

    public StartIpPing getMoIpPing() {
        return this.moIpPing;
    }

    public void setMoIpPing(StartIpPing moIpPing) {
        this.moIpPing = moIpPing;
    }

    public Boolean isFinished() {
        return this.isFinished;
    }

    public void setIsFinished(Boolean isFinished) {
        this.isFinished = isFinished;
    }

    public int getiTimeOut() {
        return this.iTimeOut;
    }

    public void setiTimeOut(int iTimeOut) {
        this.iTimeOut = iTimeOut;
    }

    public int getGetFirstTime() {
        return this.iGetFirstTime;
    }

    public void setGetFirstTime(int iGetFirstTime) {
        this.iGetFirstTime = iGetFirstTime;
    }

    public int getGetIntevalTime() {
        return this.iGetIntevalTime;
    }

    public void setGetIntevalTime(int iGetIntevalTime) {
        this.iGetIntevalTime = iGetIntevalTime;
    }

    public long getiExecBeginTime() {
        return this.iExecBeginTime;
    }

    public void setiExecBeginTime(long iExecBeginTime) {
        this.iExecBeginTime = iExecBeginTime;
    }

    public int getiExcuteMode() {
        return this.iExcuteMode;
    }

    public void setiExcuteMode(int iExcuteMode) {
        this.iExcuteMode = iExcuteMode;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getFdn() {
        return this.fdn;
    }

    public void setFdn(String fdn) {
        this.fdn = fdn;
    }

    public int getDevID() {
        return this.devID;
    }

    public void setDevID(int devID) {
        this.devID = devID;
    }

    public int getTestType() {
        return this.testType;
    }

    public void setTestType(int testType) {
        this.testType = testType;
    }

    public int getPingOrTraceType() {
        return this.pingOrTraceType;
    }

    public void setPingOrTraceType(int pingOrTraceType) {
        this.pingOrTraceType = pingOrTraceType;
    }

    public String getKeyID() {
        return this.keyID;
    }

    public void setKeyID(String keyID) {
        this.keyID = keyID;
    }

    public int getProbeCount() {
        return this.probeCount;
    }

    public void setProbeCount(int probeCount) {
        this.probeCount = probeCount;
    }

    public int getMaxTtl() {
        return this.maxTtl;
    }

    public void setMaxTtl(int maxTtl) {
        this.maxTtl = maxTtl;
    }

    public void setDestLsrID(long iDestLsrID) {
        this.iDestLsrID = iDestLsrID;
    }

    public long getDestLsrID() {
        return this.iDestLsrID;
    }

    public void setDestIP(String strDestIP) {
        this.strDestIP = strDestIP;
    }

    public String getDestIP() {
        return this.strDestIP;
    }
}

