/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.common;

import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.diagnose.common.TestCaseInfo;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.IMOService;
import com.huawei.vmf.adapter.framework.translation.schema.ActionSchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv4PingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv4TraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv6PingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Ipv6TraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.LspPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.LspTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Pwe3PingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.Pwe3TraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.RingPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.RingTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.VplsPingResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.VplsTraceResult;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteIpPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteIpTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteLspPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteLspTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeletePwe3Ping;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeletePwe3Trace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteRingPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteRingTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteVplsPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.DeleteVplsTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StopIpPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StopIpTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StopLspPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StopLspTrace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StopPwe3Ping;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StopPwe3Trace;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StopVplsPing;
import com.huawei.vmf.adapter.fservice.diagnose.model.act.StopVplsTrace;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;

public final class TestCaseFactory {
    private static final Logger LOGGER = RunLogger.getLogger(TestCaseInfo.class);
    private static final TestCaseFactory INSTANCE = new TestCaseFactory();

    private TestCaseFactory() {
    }

    public static TestCaseFactory getInstance() {
        return INSTANCE;
    }

    public Boolean isTestFinished(QuerySchemaTranslatorContext queryContext, int iTestType) {
        Boolean flag = false;
        switch (iTestType) {
            case 6: 
            case 100: {
                flag = this.isIpv4PingFinished(queryContext);
                break;
            }
            case 101: {
                flag = this.isIpv4TraceFinished(queryContext);
                break;
            }
            case 11111: {
                flag = this.isIpv6PingFinished(queryContext);
                break;
            }
            case 22222: {
                flag = this.isIpv6TraceFinished(queryContext);
                break;
            }
            case 9: {
                flag = this.isLspPingFinished(queryContext);
                break;
            }
            case 10: {
                flag = this.isLspTraceFinished(queryContext);
                break;
            }
            case 14: {
                flag = this.isPwe3PingFinished(queryContext);
                break;
            }
            case 15: {
                flag = this.isPwe3TraceFinished(queryContext);
                break;
            }
            case 32: {
                flag = this.isVplsPingFinished(queryContext);
                break;
            }
            case 33: {
                flag = this.isVplsTraceFinished(queryContext);
                break;
            }
            case 1009: {
                flag = this.isRingPingFinished(queryContext);
                break;
            }
            case 1010: {
                flag = this.isRingTraceFinished(queryContext);
                break;
            }
        }
        return flag;
    }

    private Boolean isIpv4PingFinished(QuerySchemaTranslatorContext queryContext) {
        Collection ipPingResults = queryContext.getQueryResult(Ipv4PingResult.class);
        Iterator i$ = ipPingResults.iterator();
        if (i$.hasNext()) {
            Ipv4PingResult pingResult = (Ipv4PingResult)i$.next();
            return pingResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isIpv4TraceFinished(QuerySchemaTranslatorContext queryContext) {
        Collection ipTraceResults = queryContext.getQueryResult(Ipv4TraceResult.class);
        Iterator i$ = ipTraceResults.iterator();
        if (i$.hasNext()) {
            Ipv4TraceResult traceResult = (Ipv4TraceResult)i$.next();
            return traceResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isIpv6PingFinished(QuerySchemaTranslatorContext queryContext) {
        Collection ipv6PingResults = queryContext.getQueryResult(Ipv6PingResult.class);
        Iterator i$ = ipv6PingResults.iterator();
        if (i$.hasNext()) {
            Ipv6PingResult ipv6PingResult = (Ipv6PingResult)i$.next();
            return ipv6PingResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isIpv6TraceFinished(QuerySchemaTranslatorContext queryContext) {
        Collection ipv6TraceResults = queryContext.getQueryResult(Ipv6TraceResult.class);
        Iterator i$ = ipv6TraceResults.iterator();
        if (i$.hasNext()) {
            Ipv6TraceResult ipv6TraceResult = (Ipv6TraceResult)i$.next();
            return ipv6TraceResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isLspPingFinished(QuerySchemaTranslatorContext queryContext) {
        Collection lspPingResults = queryContext.getQueryResult(LspPingResult.class);
        Iterator i$ = lspPingResults.iterator();
        if (i$.hasNext()) {
            LspPingResult pingResult = (LspPingResult)i$.next();
            return pingResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isLspTraceFinished(QuerySchemaTranslatorContext queryContext) {
        Collection lspTraceResults = queryContext.getQueryResult(LspTraceResult.class);
        Iterator i$ = lspTraceResults.iterator();
        if (i$.hasNext()) {
            LspTraceResult traceResult = (LspTraceResult)i$.next();
            return traceResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isPwe3PingFinished(QuerySchemaTranslatorContext queryContext) {
        Collection pwe3PingResults = queryContext.getQueryResult(Pwe3PingResult.class);
        Iterator i$ = pwe3PingResults.iterator();
        if (i$.hasNext()) {
            Pwe3PingResult pwe3PingResult = (Pwe3PingResult)i$.next();
            return pwe3PingResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isPwe3TraceFinished(QuerySchemaTranslatorContext queryContext) {
        Collection pwe3TraceResults = queryContext.getQueryResult(Pwe3TraceResult.class);
        Iterator i$ = pwe3TraceResults.iterator();
        if (i$.hasNext()) {
            Pwe3TraceResult pwe3TraceResult = (Pwe3TraceResult)i$.next();
            return pwe3TraceResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isVplsPingFinished(QuerySchemaTranslatorContext queryContext) {
        Collection vplsPingResults = queryContext.getQueryResult(VplsPingResult.class);
        Iterator i$ = vplsPingResults.iterator();
        if (i$.hasNext()) {
            VplsPingResult vplsPingResult = (VplsPingResult)i$.next();
            return vplsPingResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isVplsTraceFinished(QuerySchemaTranslatorContext queryContext) {
        Collection vplsTraceResults = queryContext.getQueryResult(VplsTraceResult.class);
        Iterator i$ = vplsTraceResults.iterator();
        if (i$.hasNext()) {
            VplsTraceResult vplsTraceResult = (VplsTraceResult)i$.next();
            return vplsTraceResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isRingPingFinished(QuerySchemaTranslatorContext queryContext) {
        Collection ringPingResults = queryContext.getQueryResult(RingPingResult.class);
        Iterator i$ = ringPingResults.iterator();
        if (i$.hasNext()) {
            RingPingResult ringPingResult = (RingPingResult)i$.next();
            return ringPingResult.getStatus() == 1;
        }
        return false;
    }

    private Boolean isRingTraceFinished(QuerySchemaTranslatorContext queryContext) {
        Collection ringTraceResults = queryContext.getQueryResult(RingTraceResult.class);
        Iterator i$ = ringTraceResults.iterator();
        if (i$.hasNext()) {
            RingTraceResult ringTraceResult = (RingTraceResult)i$.next();
            return ringTraceResult.getStatus() == 1;
        }
        return false;
    }

    public ErrorInfo getResultMo(QuerySchemaTranslatorContext queryContext, int iTestType, int iDevID, String strTestName) {
        DefaultMOService queryService = new DefaultMOService();
        ErrorInfo errorInfo = new ErrorInfo();
        switch (iTestType) {
            case 6: 
            case 100: {
                Ipv4PingResult ipPingResult = new Ipv4PingResult();
                ipPingResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(ipPingResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 101: {
                Ipv4TraceResult ipTraceResult = new Ipv4TraceResult();
                ipTraceResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(ipTraceResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 11111: {
                Ipv6PingResult ip6PingResult = new Ipv6PingResult();
                ip6PingResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(ip6PingResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 22222: {
                Ipv6TraceResult ip6TraceResult = new Ipv6TraceResult();
                ip6TraceResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(ip6TraceResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 9: {
                LspPingResult lspPingResult = new LspPingResult();
                lspPingResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(lspPingResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 10: {
                LspTraceResult lspTraceResult = new LspTraceResult();
                lspTraceResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(lspTraceResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 14: {
                Pwe3PingResult pwe3PingResult = new Pwe3PingResult();
                pwe3PingResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(pwe3PingResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 15: {
                Pwe3TraceResult pwe3TraceResult = new Pwe3TraceResult();
                pwe3TraceResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(pwe3TraceResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 32: {
                VplsPingResult vplsPingResult = new VplsPingResult();
                vplsPingResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(vplsPingResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 33: {
                VplsTraceResult vplsTraceResult = new VplsTraceResult();
                vplsTraceResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(vplsTraceResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 1009: {
                RingPingResult ringPingResult = new RingPingResult();
                ringPingResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(ringPingResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
            case 1010: {
                RingTraceResult ringTraceResult = new RingTraceResult();
                ringTraceResult.setTestName(strTestName);
                errorInfo = this.pullDataFromDev(ringTraceResult, iDevID, queryContext, (IMOService)queryService);
                break;
            }
        }
        return errorInfo;
    }

    private <T extends VmfMO> ErrorInfo pullDataFromDev(T objectMo, int iDevID, QuerySchemaTranslatorContext queryContext, IMOService queryService) {
        ErrorInfo errorInfo = new ErrorInfo();
        objectMo.setDevID(Integer.valueOf(iDevID));
        queryContext.addQueryAttributes(FeatureName.DGNTL, objectMo, null);
        queryService.addQueryJob(queryContext);
        try {
            queryService.poll();
            errorInfo = queryService.getErrorInfo(objectMo);
        }
        catch (VMFException e) {
            LOGGER.error("getOp queryService.poll() failed", (Object)e.getErrorMessage());
            errorInfo.setErrorCode(e.getErrorCode());
            errorInfo.setErrorMessage(e.getErrorMessage());
        }
        return errorInfo;
    }

    public void getDeleteMO(ActionSchemaTranslatorContext deleteContext, int iTestType, String strTestName) {
        switch (iTestType) {
            case 6: 
            case 100: {
                DeleteIpPing deleteIpPing = new DeleteIpPing();
                deleteIpPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteIpPing);
                break;
            }
            case 101: {
                DeleteIpTrace deleteIpTrace = new DeleteIpTrace();
                deleteIpTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteIpTrace);
                break;
            }
            case 9: {
                DeleteLspPing deleteLspPing = new DeleteLspPing();
                deleteLspPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteLspPing);
                break;
            }
            case 10: {
                DeleteLspTrace deleteLspTrace = new DeleteLspTrace();
                deleteLspTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteLspTrace);
                break;
            }
            case 14: {
                DeletePwe3Ping deletePwe3Ping = new DeletePwe3Ping();
                deletePwe3Ping.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deletePwe3Ping);
                break;
            }
            case 15: {
                DeletePwe3Trace deletePwe3Trace = new DeletePwe3Trace();
                deletePwe3Trace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deletePwe3Trace);
                break;
            }
            case 32: {
                DeleteVplsPing deleteVplsPing = new DeleteVplsPing();
                deleteVplsPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteVplsPing);
                break;
            }
            case 33: {
                DeleteVplsTrace deleteVplsTrace = new DeleteVplsTrace();
                deleteVplsTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteVplsTrace);
                break;
            }
            case 1009: {
                DeleteRingPing deleteRingPing = new DeleteRingPing();
                deleteRingPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteRingPing);
                break;
            }
            case 1010: {
                DeleteRingTrace deleteRingTrace = new DeleteRingTrace();
                deleteRingTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)deleteRingTrace);
                break;
            }
        }
    }

    public void getStopMo(ActionSchemaTranslatorContext deleteContext, int iTestType, String strTestName) {
        switch (iTestType) {
            case 6: 
            case 100: {
                StopIpPing moIpPing = new StopIpPing();
                moIpPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)moIpPing);
                break;
            }
            case 101: {
                StopIpTrace moIpTrace = new StopIpTrace();
                moIpTrace.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)moIpTrace);
                break;
            }
            case 9: {
                StopLspPing moLspPing = new StopLspPing();
                moLspPing.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)moLspPing);
                break;
            }
            case 10: {
                StopLspTrace mo = new StopLspTrace();
                mo.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)mo);
                break;
            }
            case 14: {
                StopPwe3Ping mo = new StopPwe3Ping();
                mo.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)mo);
                break;
            }
            case 15: {
                StopPwe3Trace mo = new StopPwe3Trace();
                mo.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)mo);
                break;
            }
            case 32: {
                StopVplsPing mo = new StopVplsPing();
                mo.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)mo);
                break;
            }
            case 33: {
                StopVplsTrace mo = new StopVplsTrace();
                mo.setTestName(strTestName);
                deleteContext.addAction(FeatureName.DGNTL, (VmfMO)mo);
                break;
            }
        }
    }
}

