/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.diagnose.common;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.extendpoint.framework.IMessageCommMgr;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class DiagCommon {
    private static final Logger LOGGER = RunLogger.getLogger(DiagCommon.class);
    private static final DiagCommon INSTANCE = new DiagCommon();
    private static IProxyService mdpproxy;
    private static int iResID;

    private DiagCommon() {
        ProcessInfo procInfo = ProcessInfoHelper.getRuntimeProcessInfo();
        mdpproxy = MsgProxy.getProxyService((ProcessInfo)procInfo);
    }

    public static DiagCommon getInstance() {
        return INSTANCE;
    }

    public synchronized int assignResID() {
        return iResID++;
    }

    public void sendBroadcastMessage(int cmdCode, FStruct fstruct) {
        LOGGER.info("Enter into sendBroadcastMessage:[cmdCode={}, fstruct={}]", new Object[]{cmdCode, AsnUtil.toString((FStruct)fstruct)});
        mdpproxy.sendBroadcastMessage(cmdCode, fstruct);
    }

    public void sendAsysMessage(int cmdCode, Task task, FStruct req) {
        IMessageCommMgr messageCommon = (IMessageCommMgr)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(IMessageCommMgr.class);
        if (messageCommon != null) {
            try {
                messageCommon.sendMessageToE2E(cmdCode, req);
            }
            catch (Exception e) {
                LOGGER.error("Failed to send diagnose result from weblct!", (Throwable)e);
            }
        } else {
            MSGHead msgHead = this.getMSGHead(task, (byte)6, cmdCode);
            LOGGER.info("NEDiag Send rpt asn:[head={}, cmdCode={}, class={}, rpt={}]", new Object[]{msgHead.toString(), cmdCode, req.getClass().getName(), AsnUtil.toString((FStruct)req)});
            mdpproxy.sendAsyncMessage(msgHead, req, null);
        }
    }

    private MSGHead getMSGHead(Task task, byte messageType, int cmdCode) {
        MSGPacketExt msg = task.getMsg();
        char senderProcID = msg.mheader.senderProcID;
        char senderProcHandle = msg.mheader.senderProcHandle;
        char senderDeskID = msg.mheader.senderDeskID;
        MSGHead msgHead = new MSGHead();
        msgHead.receiverDeskID = senderDeskID;
        msgHead.receiverProcHandle = senderProcHandle;
        msgHead.receiverProcID = senderProcID;
        msgHead.msgType = messageType;
        msgHead.cmdCode = cmdCode;
        return msgHead;
    }

    public int getPingTimeOut(int packetCount, int interval, int timeOut) {
        int iTimeOut = 0;
        iTimeOut = (packetCount - 1) * interval / 1000 + timeOut / 1000 + 3;
        return iTimeOut;
    }

    public int getNoReplyPingTimeOut(int packetCount, int interval, int timeOut) {
        int iTimeOut = 0;
        iTimeOut = (packetCount - 1) * interval / 1000 + timeOut / 1000 + 120;
        return iTimeOut;
    }

    public int getFirstPingResultTime(int packetCount, int interval) {
        int iTimeOut = 0;
        iTimeOut = (packetCount - 1) * interval / 1000 + 3;
        return iTimeOut;
    }

    public int getPingResultInterval(int timeOut) {
        int iTimeOut = 3;
        if (0 != timeOut) {
            iTimeOut = timeOut / 1000;
        }
        return iTimeOut;
    }

    public int getTraceResultTime(int packetCount, int timeOut) {
        int iTimeOut = 0;
        iTimeOut = packetCount * timeOut / 1000;
        if (3 > iTimeOut) {
            iTimeOut = 3;
        }
        return iTimeOut;
    }

    public int getTraceTimeOut(int firstTtl, int maxTtl, int packetCount, int timeOut) {
        int iTimeOut = 0;
        iTimeOut = (maxTtl - firstTtl + 3) * packetCount * timeOut / 1000;
        return iTimeOut;
    }

    public int getNoReplyTraceTimeOut(int firstTtl, int maxTtl, int packetCount, int timeOut) {
        int iTimeOut = 0;
        iTimeOut = (maxTtl - firstTtl + 60) * packetCount * timeOut / 1000;
        return iTimeOut;
    }

    public IAsnTranslationContext getContext() {
        AsnTranslationContext asnTransContext = new AsnTranslationContext();
        asnTransContext.setOperType(EOperationType.CREATE);
        Context context = new Context();
        asnTransContext.setTransactionContext(context);
        return asnTransContext;
    }

    public void execSuccess(QAsnSingleReturn singleReturn) {
        singleReturn.isSuccess = true;
        singleReturn.reason = "TestCase execute success".getBytes();
        singleReturn.retCode = 0;
    }

    public void execFail(QAsnSingleReturn singleReturn) {
        singleReturn.isSuccess = false;
        singleReturn.reason = "TestCase execute fail".getBytes();
        singleReturn.retCode = 1107499878;
    }

    static {
        iResID = 1;
    }
}

