/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.dhcp.translation.asn;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpAddress;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpAddressList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpRelay;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.dhcp.common.Utility;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnVpnDhcpAddressTranslator;
import com.huawei.vmf.adapter.dhcp.translation.asn.spec.QAsnVpnDhcpRelaySpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayVpnCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.ServerAddr;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.Collection;
import java.util.Vector;

public class QAsnVpnDhcpRelayTranslator
extends AbstractAsnTranslator<QAsnDhcpRelay, DhcpRelayVpnCfg> {
    private IAsnTranslator<QAsnDhcpAddress, ServerAddr> qasnDhcpAddressTranslator = new QAsnVpnDhcpAddressTranslator();
    private QAsnVpnDhcpRelaySpecTranslator qasnDhcpRelaySpecTranslator = new QAsnVpnDhcpRelaySpecTranslator();

    public void decode(QAsnDhcpRelay asn, DhcpRelayVpnCfg mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnDhcpRelaySpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeDhcpRelayVpnCfg(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
    }

    public void decodeDhcpRelayVpnCfg(QAsnDhcpRelay asn, DhcpRelayVpnCfg mo, IAsnTranslationContext context) throws VMFException {
        L3vpnInstance vpninstance = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        mo.setDeployStatus(vpninstance.getDeployStatus());
        mo.setDevID(vpninstance.getDevID());
        mo.setVrfName(vpninstance.getVrfName());
        mo.setVrID(vpninstance.getVrID());
        this.qasnDhcpRelaySpecTranslator.decodeQAsnDhcpRelaySpecKeys(asn, mo, context);
        context.addProperty(DhcpRelayVpnCfg.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setIsEnable(this.parseBoolean(asn.enableState, "isEnable", Utility.z_dhcpRelayVpnCfgMasks, (VmfMO)mo, context));
        mo.setHopLimit(this.integerValue(asn.relayBoundLimit, "hopLimit", Utility.z_dhcpRelayVpnCfgMasks, (VmfMO)mo, context));
        mo.setServerPolicy(this.integerValue(asn.serverSelectPolicy, "serverPolicy", Utility.z_dhcpRelayVpnCfgMasks, (VmfMO)mo, context));
        this.decodeServerAddrList(asn, mo, context);
        this.setChanged((VmfMO)mo, Utility.z_dhcpRelayVpnCfgMasks, asn.poOperMask, context);
    }

    private void decodeServerAddrList(QAsnDhcpRelay asn, DhcpRelayVpnCfg mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.serverAddrList) {
            return;
        }
        mo.addServerAddrs(this.qasnDhcpAddressTranslator.decode((Collection)asn.serverAddrList, context));
    }

    public void encode(DhcpRelayVpnCfg mo, QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnDhcpRelaySpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeDhcpRelayVpnCfg(mo, asn, context);
    }

    public void encodeDhcpRelayVpnCfg(DhcpRelayVpnCfg mo, QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.enableState = this.intValue(mo.getIsEnable());
        asn.relayBoundLimit = this.intValue(mo.getHopLimit());
        asn.serverSelectPolicy = this.intValue(mo.getServerPolicy());
        mask |= this.setChangeMask((VmfMO)mo, context, Utility.z_dhcpRelayVpnCfgMasks);
        this.encodeServerAddrList(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.getChangeMask((Vector)asn.serverAddrList, Utility.z_qasnDhcpRelayMasks, "serverAddrList"));
    }

    private void encodeServerAddrList(DhcpRelayVpnCfg mo, QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo.getServerAddrs()) {
            return;
        }
        if (null == asn.serverAddrList) {
            asn.serverAddrList = new QAsnDhcpAddressList();
        }
        asn.serverAddrList.addAll(this.qasnDhcpAddressTranslator.encode(mo.getServerAddrs(), context));
    }

    public Class<QAsnDhcpRelay> getAsnClass() {
        return QAsnDhcpRelay.class;
    }

    public Class<DhcpRelayVpnCfg> getMoClass() {
        return DhcpRelayVpnCfg.class;
    }
}

