/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.dhcp.translation.asn;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpAddress;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.dhcp.model.ServerAddr;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;

public class QAsnVpnDhcpAddressTranslator
extends AbstractAsnTranslator<QAsnDhcpAddress, ServerAddr> {
    public static final Object[][] z_qasnDhcpAddressMasks = new Object[0][];
    public static final Object[][] z_serverAddrMasks = new Object[0][];

    public void decode(QAsnDhcpAddress asn, ServerAddr mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        L3vpnInstance vpninstance = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        mo.setDevID(vpninstance.getDevID());
        mo.setVrfName(vpninstance.getVrfName());
        mo.setVrID(vpninstance.getVrID());
        this.decodeServerAddr(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
    }

    public void decodeServerAddr(QAsnDhcpAddress asn, ServerAddr mo, IAsnTranslationContext context) throws VMFException {
        L3vpnInstance vpninstance = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        mo.setDevID(vpninstance.getDevID());
        mo.setVrfName(vpninstance.getVrfName());
        mo.setVrID(vpninstance.getVrID());
        mo.setServerIp(this.strValue(asn.strIpAddress));
        context.addProperty(ServerAddr.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        this.setChanged((VmfMO)mo, z_serverAddrMasks, asn.poOperMask, context);
    }

    public void encode(ServerAddr mo, QAsnDhcpAddress asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.encodeServerAddr(mo, asn, context);
    }

    public void encodeServerAddr(ServerAddr mo, QAsnDhcpAddress asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strIpAddress = this.getBytes(mo.getServerIp());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_serverAddrMasks));
    }

    public Class<QAsnDhcpAddress> getAsnClass() {
        return QAsnDhcpAddress.class;
    }

    public Class<ServerAddr> getMoClass() {
        return ServerAddr.class;
    }
}

