/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.dhcp.translation.asn;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpAddress;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpAddressList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpRelay;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.dhcp.common.Utility;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnDhcpAddressTranslator;
import com.huawei.vmf.adapter.dhcp.translation.asn.spec.QAsnDhcpRelaySpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayGiaddr;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayServerAddr;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnDhcpRelayTranslator
extends AbstractAsnTranslator<QAsnDhcpRelay, DhcpRelayIfCfg> {
    private IAsnTranslator<QAsnDhcpAddress, DhcpRelayIfCfg> qasnDhcpAddressTranslator = new QAsnDhcpAddressTranslator();
    public static final Object[][] z_qasnDhcpRelayMasks = new Object[0][];
    public static final Object[][] z_dhcpIntfOpt82FormateMasks = new Object[0][];
    private QAsnDhcpRelaySpecTranslator qasnDhcpRelaySpecTranslator = new QAsnDhcpRelaySpecTranslator();

    public void decode(QAsnDhcpRelay asn, DhcpRelayIfCfg mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        Interface interfaceInstance = (Interface)context.getProperty(Interface.class.getName());
        mo.setDevID(interfaceInstance.getDevID());
        mo.setInterfaceName(interfaceInstance.getIfName());
        mo.setVrID(interfaceInstance.getVrID());
        this.qasnDhcpRelaySpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeDhcpRelayIfCfg(asn, mo, context);
        this.qasnDhcpRelaySpecTranslator.decodeKeyRefMoDhcpIntfOpt82Formate(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
        this.qasnDhcpRelaySpecTranslator.decodePoOption82Mode(asn, mo, context);
        L3vpnInstance vpninstance = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        mo.setDeployStatus(vpninstance.getDeployStatus());
    }

    public void decodeDhcpRelayIfCfg(QAsnDhcpRelay asn, DhcpRelayIfCfg mo, IAsnTranslationContext context) throws VMFException {
        this.qasnDhcpRelaySpecTranslator.decodeQAsnDhcpRelaySpecKeys(asn, mo, context);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        mo.setIsEnable(this.parseBoolean(asn.enableState, "isEnable", Utility.z_dhcpRelayIfCfgMasks, (VmfMO)mo, context));
        context.addProperty(DhcpRelayIfCfg.class.getName(), (Object)mo);
        this.decodeServerAddrList(asn, mo, context);
        this.decodeIpRelayGiaddrList(asn, mo, context);
        this.setChanged((VmfMO)mo, Utility.z_dhcpRelayIfCfgMasks, asn.poOperMask, context);
    }

    private void decodeIpRelayGiaddrList(QAsnDhcpRelay asn, DhcpRelayIfCfg mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.ipRelayGiaddrList) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)asn.ipRelayGiaddrList)) {
            return;
        }
        for (Object obj : asn.ipRelayGiaddrList) {
            DhcpRelayGiaddr dhcpRelayGiaddr = new DhcpRelayGiaddr();
            new QAsnDhcpAddressTranslator().decodeDhcpRelayGiaddr((QAsnDhcpAddress)obj, dhcpRelayGiaddr, context);
            ArrayList<DhcpRelayGiaddr> dhcpRelayGiaddrs = new ArrayList<DhcpRelayGiaddr>();
            dhcpRelayGiaddrs.add(dhcpRelayGiaddr);
            mo.addDhcpRelayGiaddrs(dhcpRelayGiaddrs);
        }
    }

    private void decodeServerAddrList(QAsnDhcpRelay asn, DhcpRelayIfCfg mo, IAsnTranslationContext context) throws VMFException {
        if (null == asn.serverAddrList) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)asn.serverAddrList)) {
            return;
        }
        for (Object obj : asn.serverAddrList) {
            DhcpRelayServerAddr dhcpRelayServerAddr = new DhcpRelayServerAddr();
            new QAsnDhcpAddressTranslator().decodeDhcpRelayServerAddr((QAsnDhcpAddress)obj, dhcpRelayServerAddr, context);
            ArrayList<DhcpRelayServerAddr> dhcpRelayServerAddrs = new ArrayList<DhcpRelayServerAddr>();
            dhcpRelayServerAddrs.add(dhcpRelayServerAddr);
            mo.addDhcpRelayServerAddrs(dhcpRelayServerAddrs);
        }
    }

    public void encode(DhcpRelayIfCfg mo, QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnDhcpRelaySpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeDhcpRelayIfCfg(mo, asn, context);
        this.qasnDhcpRelaySpecTranslator.encodeKeyRefMoDhcpIntfOpt82Formate(mo, asn, context);
        this.qasnDhcpRelaySpecTranslator.encodePoOption82Mode(mo, asn, context);
    }

    public void encodeDhcpRelayIfCfg(DhcpRelayIfCfg mo, QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.enableState = this.intValue(mo.getIsEnable());
        mask |= this.setChangeMask((VmfMO)mo, context, Utility.z_dhcpRelayIfCfgMasks);
        this.encodeServerAddrList(mo, asn, context);
        mask |= this.getChangeMask((Vector)asn.serverAddrList, z_qasnDhcpRelayMasks, "serverAddrList");
        this.encodeIpRelayGiaddrList(mo, asn, context);
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.getChangeMask((Vector)asn.ipRelayGiaddrList, z_qasnDhcpRelayMasks, "ipRelayGiaddrList"));
    }

    private void encodeIpRelayGiaddrList(DhcpRelayIfCfg mo, QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        Collection dhcpServer = mo.getDhcpRelayGiaddrs();
        if (!CollectionUtils.isEmpty((Collection)dhcpServer)) {
            if (asn.ipRelayGiaddrList == null) {
                asn.ipRelayGiaddrList = new QAsnDhcpAddressList();
            }
            Iterator it = dhcpServer.iterator();
            while (it.hasNext()) {
                QAsnDhcpAddress qasnDhcpAddress = new QAsnDhcpAddress();
                asn.ipRelayGiaddrList.add((Object)qasnDhcpAddress);
                AsnUtil.setDefaultAsnValue((FStruct)qasnDhcpAddress);
                new QAsnDhcpAddressTranslator().encodeDhcpRelayGiaddr((DhcpRelayGiaddr)it.next(), qasnDhcpAddress, context);
            }
        }
    }

    private void encodeServerAddrList(DhcpRelayIfCfg mo, QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        Collection dhcpServer = mo.getDhcpRelayServerAddrs();
        if (!CollectionUtils.isEmpty((Collection)dhcpServer)) {
            if (asn.serverAddrList == null) {
                asn.serverAddrList = new QAsnDhcpAddressList();
            }
            Iterator it = dhcpServer.iterator();
            while (it.hasNext()) {
                QAsnDhcpAddress qasnDhcpAddress = new QAsnDhcpAddress();
                asn.serverAddrList.add((Object)qasnDhcpAddress);
                AsnUtil.setDefaultAsnValue((FStruct)qasnDhcpAddress);
                new QAsnDhcpAddressTranslator().encodeDhcpRelayServerAddr((DhcpRelayServerAddr)it.next(), qasnDhcpAddress, context);
            }
        }
    }

    public Class<QAsnDhcpRelay> getAsnClass() {
        return QAsnDhcpRelay.class;
    }

    public Class<DhcpRelayIfCfg> getMoClass() {
        return DhcpRelayIfCfg.class;
    }
}

