/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.dhcp.translation.asn;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpAddress;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.dhcp.translation.asn.spec.QAsnDhcpAddressSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayGiaddr;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayServerAddr;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class QAsnDhcpAddressTranslator
extends AbstractAsnTranslator<QAsnDhcpAddress, DhcpRelayIfCfg> {
    public static final Object[][] z_qasnDhcpAddressMasks = new Object[0][];
    public static final Object[][] z_dhcpRelayServerAddrMasks = new Object[0][];
    public static final Object[][] z_dhcpRelayGiaddrMasks = new Object[0][];
    private QAsnDhcpAddressSpecTranslator qasnDhcpAddressSpecTranslator = new QAsnDhcpAddressSpecTranslator();

    public void decode(QAsnDhcpAddress asn, DhcpRelayIfCfg mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        Interface interfaceInstance = (Interface)context.getProperty(Interface.class.getName());
        mo.setDevID(interfaceInstance.getDevID());
        mo.setInterfaceName(interfaceInstance.getIfName());
        mo.setVrID(interfaceInstance.getVrID());
        this.qasnDhcpAddressSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.qasnDhcpAddressSpecTranslator.decodeQAsnDhcpAddressSpecKeys(asn, mo, context);
        context.addProperty(DhcpRelayIfCfg.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        DhcpRelayServerAddr dhcpRelayServerAddr = new DhcpRelayServerAddr();
        this.decodeDhcpRelayServerAddr(asn, dhcpRelayServerAddr, context);
        ArrayList<DhcpRelayServerAddr> dhcpRelayServerAddrs = new ArrayList<DhcpRelayServerAddr>();
        dhcpRelayServerAddrs.add(dhcpRelayServerAddr);
        mo.addDhcpRelayServerAddrs(dhcpRelayServerAddrs);
        DhcpRelayGiaddr dhcpRelayGiaddr = new DhcpRelayGiaddr();
        this.decodeDhcpRelayGiaddr(asn, dhcpRelayGiaddr, context);
        ArrayList<DhcpRelayGiaddr> dhcpRelayGiaddrs = new ArrayList<DhcpRelayGiaddr>();
        dhcpRelayGiaddrs.add(dhcpRelayGiaddr);
        mo.addDhcpRelayGiaddrs(dhcpRelayGiaddrs);
    }

    public void decodeDhcpRelayGiaddr(QAsnDhcpAddress asn, DhcpRelayGiaddr mo, IAsnTranslationContext context) throws VMFException {
        DhcpRelayIfCfg dhcpRelayIfCfg = (DhcpRelayIfCfg)context.getProperty(DhcpRelayIfCfg.class.getName());
        mo.setDevID(dhcpRelayIfCfg.getDevID());
        mo.setVrID(dhcpRelayIfCfg.getVrID());
        mo.setInterfaceName(dhcpRelayIfCfg.getInterfaceName());
        if (EOperationType.MODIFY.equals((Object)context.getOperType())) {
            mo.setGiAddr(this.strValue(asn.strIpAddress));
            mo.setOptionCode(asn.iDhcpOptionCode);
            mo.setVendorClass(this.strValue(asn.strDhcpText));
        } else {
            mo.setGiAddr(this.strValue(asn.strIpAddress, "giAddr", z_dhcpRelayGiaddrMasks, (VmfMO)mo, context));
            mo.setOptionCode(this.integerValue(asn.iDhcpOptionCode, "optionCode", z_dhcpRelayGiaddrMasks, (VmfMO)mo, context));
            mo.setVendorClass(this.strValue(asn.strDhcpText, "vendorClass", z_dhcpRelayGiaddrMasks, (VmfMO)mo, context));
        }
        if (asn.iDhcpOptionCode == 60) {
            mo.setIsVendor(Boolean.valueOf(true));
        } else {
            mo.setIsVendor(Boolean.valueOf(false));
            mo.setVendorClass("-");
        }
        if (mo.getOptionCode() == null || mo.getOptionCode() == -1) {
            mo.setOptionCode(Integer.valueOf(0));
        }
        context.addProperty(DhcpRelayGiaddr.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        this.setChanged((VmfMO)mo, z_dhcpRelayGiaddrMasks, asn.poOperMask, context);
    }

    public void decodeDhcpRelayServerAddr(QAsnDhcpAddress asn, DhcpRelayServerAddr mo, IAsnTranslationContext context) throws VMFException {
        DhcpRelayIfCfg dhcpRelayIfCfg = (DhcpRelayIfCfg)context.getProperty(DhcpRelayIfCfg.class.getName());
        mo.setDevID(dhcpRelayIfCfg.getDevID());
        mo.setVrID(dhcpRelayIfCfg.getVrID());
        mo.setInterfaceName(dhcpRelayIfCfg.getInterfaceName());
        if (EOperationType.MODIFY.equals((Object)context.getOperType())) {
            mo.setServerAddr(this.strValue(asn.strIpAddress));
            mo.setOptionCode(asn.iDhcpOptionCode);
            mo.setVendorClass(this.strValue(asn.strDhcpText));
        } else {
            mo.setServerAddr(this.strValue(asn.strIpAddress, "serverAddr", z_dhcpRelayServerAddrMasks, (VmfMO)mo, context));
            mo.setOptionCode(this.integerValue(asn.iDhcpOptionCode, "optionCode", z_dhcpRelayServerAddrMasks, (VmfMO)mo, context));
            mo.setVendorClass(this.strValue(asn.strDhcpText, "vendorClass", z_dhcpRelayServerAddrMasks, (VmfMO)mo, context));
        }
        if (asn.iDhcpOptionCode == 60) {
            mo.setIsVendor(Boolean.valueOf(true));
        } else {
            mo.setIsVendor(Boolean.valueOf(false));
            mo.setVendorClass("-");
        }
        if (mo.getOptionCode() == null || mo.getOptionCode() == -1) {
            mo.setOptionCode(Integer.valueOf(0));
        }
        context.addProperty(DhcpRelayServerAddr.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        this.setChanged((VmfMO)mo, z_dhcpRelayServerAddrMasks, asn.poOperMask, context);
    }

    public void encode(DhcpRelayIfCfg mo, QAsnDhcpAddress asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnDhcpAddressSpecTranslator.encodeKeyProperties(mo, asn, context);
        if (!CollectionUtils.isEmpty((Collection)mo.getDhcpRelayServerAddrs())) {
            this.encodeDhcpRelayServerAddr((DhcpRelayServerAddr)mo.getDhcpRelayServerAddrs().iterator().next(), asn, context);
        }
        if (!CollectionUtils.isEmpty((Collection)mo.getDhcpRelayGiaddrs())) {
            this.encodeDhcpRelayGiaddr((DhcpRelayGiaddr)mo.getDhcpRelayGiaddrs().iterator().next(), asn, context);
        }
    }

    public void encodeDhcpRelayGiaddr(DhcpRelayGiaddr mo, QAsnDhcpAddress asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strIpAddress = this.getBytes(mo.getGiAddr());
        if (mo.getOptionCode() != null && mo.getOptionCode() == 0) {
            mo.setOptionCode(null);
        }
        if (mo.getVendorClass() != null && "-".equals(mo.getVendorClass())) {
            mo.setVendorClass(null);
        }
        asn.iDhcpOptionCode = this.intValue(mo.getOptionCode());
        asn.strDhcpText = this.getBytes(mo.getVendorClass());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_dhcpRelayGiaddrMasks));
    }

    public void encodeDhcpRelayServerAddr(DhcpRelayServerAddr mo, QAsnDhcpAddress asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.strIpAddress = this.getBytes(mo.getServerAddr());
        if (mo.getOptionCode() != null && mo.getOptionCode() == 0) {
            mo.setOptionCode(null);
        }
        if (mo.getVendorClass() != null && "-".equals(mo.getVendorClass())) {
            mo.setVendorClass(null);
        }
        asn.iDhcpOptionCode = this.intValue(mo.getOptionCode());
        asn.strDhcpText = this.getBytes(mo.getVendorClass());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_dhcpRelayServerAddrMasks));
    }

    public Class<QAsnDhcpAddress> getAsnClass() {
        return QAsnDhcpAddress.class;
    }

    public Class<DhcpRelayIfCfg> getMoClass() {
        return DhcpRelayIfCfg.class;
    }
}

