/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.dhcp.service;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpRelay;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.dhcp.common.Utility;
import com.huawei.vmf.adapter.dhcp.dao.DhcpDao;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnVpnDhcpRelayTranslator;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpIntfOpt82Formate;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpOpt82Intf;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayGiaddr;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayServerAddr;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayVpnCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.ServerAddr;
import com.huawei.vmf.adapter.fservice.dhcp.service.IDhcpService;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DhcpService
implements IDhcpService {
    private Logger logger = LoggerFactory.getLogger(DhcpService.class);

    public void decodeDhcpRealyVpn(QAsnDhcpRelay asn, L3vpnInstance vpn, Object objContext) {
        try {
            if (asn == null) {
                return;
            }
            IAsnTranslationContext context = (IAsnTranslationContext)objContext;
            if (EOperationType.MODIFY.equals((Object)context.getOperType())) {
                if (asn.poOperMask == null || asn.poOperMask == 0) {
                    return;
                }
                DhcpRelayVpnCfg delayMo = (DhcpRelayVpnCfg)new QAsnVpnDhcpRelayTranslator().decode((FStruct)asn, context);
                if (delayMo != null) {
                    if (null != asn.poOperMask && (2 & asn.poOperMask) > 0) {
                        DhcpDao dao = (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, DhcpDao.class);
                        Collection<ServerAddr> serverList = dao.queryDhcpRelayServerVpnAddr(vpn);
                        HashMap<String, ServerAddr> existRecord = new HashMap<String, ServerAddr>();
                        HashMap<String, ServerAddr> newRecord = new HashMap<String, ServerAddr>();
                        if (!CollectionUtils.isEmpty(serverList)) {
                            for (ServerAddr server : serverList) {
                                existRecord.put(server.getServerIp(), server);
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)delayMo.getServerAddrs())) {
                            for (ServerAddr server : delayMo.getServerAddrs()) {
                                newRecord.put(server.getServerIp(), server);
                                if (existRecord.get(server.getServerIp()) != null) continue;
                                context.getTransactionContext().addChangeRecord(ServerAddr.class).addCreate((Object)server);
                            }
                        }
                        ArrayList<ServerAddr> deleteServerList = new ArrayList<ServerAddr>();
                        if (!CollectionUtils.isEmpty(serverList)) {
                            for (ServerAddr server : serverList) {
                                if (newRecord.get(server.getServerIp()) != null) continue;
                                deleteServerList.add(server);
                            }
                        }
                        context.getTransactionContext().addChangeRecord(ServerAddr.class).addDelete(deleteServerList);
                        delayMo.addServerAddrs(deleteServerList);
                    }
                    vpn.addKeyRefMo((VmfMO)delayMo);
                }
            } else {
                DhcpRelayVpnCfg delayMo = (DhcpRelayVpnCfg)new QAsnVpnDhcpRelayTranslator().decode((FStruct)asn, context);
                vpn.addKeyRefMo((VmfMO)delayMo);
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.decode error", (Throwable)e);
        }
    }

    public Collection<L3vpnInstance> processDhcpRelayVpn(Collection<L3vpnInstance> l3vpns, Object objContext, EOperationType operType) {
        try {
            Context context = (Context)objContext;
            DhcpDao dao = (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, DhcpDao.class);
            Collection<DhcpRelayVpnCfg> relayVpns = dao.queryDhcpRelayVpnCfgs(l3vpns);
            if (CollectionUtils.isEmpty(relayVpns)) {
                return l3vpns;
            }
            Collection<ServerAddr> servers = dao.queryDhcpRelayServerVpnAddrs(l3vpns);
            Map<L3vpnInstance, DhcpRelayVpnCfg> vpnMap = this.getDhcpRelayVpnCfgMap(l3vpns, relayVpns);
            Map<L3vpnInstance, Collection<ServerAddr>> serverMap = this.getServerAddrMap(l3vpns, servers);
            for (L3vpnInstance l3vpn : l3vpns) {
                DhcpRelayVpnCfg dhcpRelayResult = vpnMap.get(l3vpn);
                if (dhcpRelayResult == null) continue;
                dhcpRelayResult.setServerAddrs(serverMap.get(l3vpn));
                Utility.INSTANCE.addMo2Context(context, operType, DhcpRelayVpnCfg.class, dhcpRelayResult, (VmfMO)l3vpn);
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.processSAP error", (Throwable)e);
        }
        return l3vpns;
    }

    public Map<L3vpnInstance, DhcpRelayVpnCfg> processDhcpRelayVpnFromDb(Collection<L3vpnInstance> l3vpns) {
        HashMap<L3vpnInstance, DhcpRelayVpnCfg> vrfRelayVpns = new HashMap<L3vpnInstance, DhcpRelayVpnCfg>();
        try {
            DhcpDao dao = (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, DhcpDao.class);
            ArrayList<Interface> interfaceKeys = new ArrayList<Interface>();
            for (L3vpnInstance l3vpn : l3vpns) {
                if (l3vpn.getL3vpnIfs() == null) continue;
                for (L3vpnIf ifMo : l3vpn.getL3vpnIfs()) {
                    Interface mo = new Interface();
                    mo.setDevID(ifMo.getDevID());
                    mo.setVrID(ifMo.getVrID());
                    mo.setIfName(ifMo.getIfName());
                    interfaceKeys.add(mo);
                }
            }
            Collection<Object> dhcpRelayResults = new ArrayList();
            Collection<Object> dhcpRelayGiaddrs = new ArrayList();
            Collection<Object> dhcpRelayServerAddrs = new ArrayList();
            Collection<Object> opt82Intfs = new ArrayList();
            Collection<Object> opt82Formates = new ArrayList();
            if (!CollectionUtils.isEmpty(interfaceKeys) && !CollectionUtils.isEmpty(dhcpRelayResults = dao.queryDhcpRelayIfCfg(interfaceKeys))) {
                dhcpRelayGiaddrs = dao.queryDhcpRelayGiaddrs(interfaceKeys);
                dhcpRelayServerAddrs = dao.queryDhcpRelayServerAddrs(interfaceKeys);
                for (DhcpRelayIfCfg dhcpRelayIfCfg : dhcpRelayResults) {
                    if (!CollectionUtils.isEmpty(dhcpRelayGiaddrs)) {
                        for (DhcpRelayGiaddr dhcpRelayGiaddr : dhcpRelayGiaddrs) {
                            if (dhcpRelayGiaddr.getDevID().intValue() != dhcpRelayIfCfg.getDevID().intValue() || dhcpRelayGiaddr.getVrID().intValue() != dhcpRelayIfCfg.getVrID().intValue() || !dhcpRelayGiaddr.getInterfaceName().equals(dhcpRelayIfCfg.getInterfaceName())) continue;
                            dhcpRelayIfCfg.addDhcpRelayGiaddrs(Arrays.asList(dhcpRelayGiaddr));
                        }
                    }
                    if (CollectionUtils.isEmpty(dhcpRelayServerAddrs)) continue;
                    for (DhcpRelayServerAddr dhcpRelayServerAddr : dhcpRelayServerAddrs) {
                        if (dhcpRelayServerAddr.getDevID().intValue() != dhcpRelayIfCfg.getDevID().intValue() || dhcpRelayServerAddr.getVrID().intValue() != dhcpRelayIfCfg.getVrID().intValue() || !dhcpRelayServerAddr.getInterfaceName().equals(dhcpRelayIfCfg.getInterfaceName())) continue;
                        dhcpRelayIfCfg.addDhcpRelayServerAddrs(Arrays.asList(dhcpRelayServerAddr));
                    }
                }
                opt82Intfs = dao.queryDhcpOption82Intf(interfaceKeys);
                opt82Formates = dao.queryDhcpOption82Formates(interfaceKeys);
            }
            for (L3vpnInstance l3vpnInstance : l3vpns) {
                if (CollectionUtils.isEmpty((Collection)l3vpnInstance.getL3vpnIfs())) continue;
                for (L3vpnIf l3vpnIf : l3vpnInstance.getL3vpnIfs()) {
                    for (DhcpRelayIfCfg dhcpRelayIfCfg : dhcpRelayResults) {
                        if (!dhcpRelayIfCfg.getInterfaceName().equals(l3vpnIf.getIfName()) || dhcpRelayIfCfg.getDevID().intValue() != l3vpnIf.getDevID().intValue() || dhcpRelayIfCfg.getVrID().intValue() != l3vpnIf.getVrID().intValue()) continue;
                        l3vpnInstance.addKeyRefMo((VmfMO)dhcpRelayIfCfg);
                    }
                    for (DhcpOpt82Intf dhcpOpt82Intf : opt82Intfs) {
                        if (!dhcpOpt82Intf.getIfName().equals(l3vpnIf.getIfName()) || dhcpOpt82Intf.getDevID().intValue() != l3vpnIf.getDevID().intValue() || dhcpOpt82Intf.getVrID().intValue() != l3vpnIf.getVrID().intValue()) continue;
                        l3vpnInstance.addKeyRefMo((VmfMO)dhcpOpt82Intf);
                    }
                    for (DhcpIntfOpt82Formate dhcpIntfOpt82Formate : opt82Formates) {
                        if (!dhcpIntfOpt82Formate.getIfName().equals(l3vpnIf.getIfName()) || dhcpIntfOpt82Formate.getDevID().intValue() != l3vpnIf.getDevID().intValue() || dhcpIntfOpt82Formate.getVrID().intValue() != l3vpnIf.getVrID().intValue()) continue;
                        l3vpnInstance.addKeyRefMo((VmfMO)dhcpIntfOpt82Formate);
                    }
                }
            }
            Collection<DhcpRelayVpnCfg> relayVpns = dao.queryDhcpRelayVpnCfgs(l3vpns);
            if (CollectionUtils.isEmpty(relayVpns)) {
                return vrfRelayVpns;
            }
            Collection<ServerAddr> collection = dao.queryDhcpRelayServerVpnAddrs(l3vpns);
            Map<L3vpnInstance, DhcpRelayVpnCfg> vpnMap = this.getDhcpRelayVpnCfgMap(l3vpns, relayVpns);
            Map<L3vpnInstance, Collection<ServerAddr>> map = this.getServerAddrMap(l3vpns, collection);
            for (L3vpnInstance l3vpnInstance : l3vpns) {
                DhcpRelayVpnCfg dhcpRelayResult = vpnMap.get(l3vpnInstance);
                if (dhcpRelayResult == null) continue;
                dhcpRelayResult.setServerAddrs(map.get(l3vpnInstance));
                vrfRelayVpns.put(l3vpnInstance, dhcpRelayResult);
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.processSAP error", (Throwable)e);
        }
        return vrfRelayVpns;
    }

    public QAsnDhcpRelay encodeDhcpRelayVpn(DhcpRelayVpnCfg mo, Object context) throws VMFException {
        return (QAsnDhcpRelay)new QAsnVpnDhcpRelayTranslator().encode(mo, (IAsnTranslationContext)context);
    }

    private Map<L3vpnInstance, DhcpRelayVpnCfg> getDhcpRelayVpnCfgMap(Collection<L3vpnInstance> l3vpns, Collection<DhcpRelayVpnCfg> dhcpRelayResults) {
        HashMap<L3vpnInstance, DhcpRelayVpnCfg> dhcpRelayIfCgfMap = new HashMap<L3vpnInstance, DhcpRelayVpnCfg>();
        block0: for (L3vpnInstance l3vpn : l3vpns) {
            for (DhcpRelayVpnCfg dhcpIfCfg : dhcpRelayResults) {
                if (l3vpn.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || !l3vpn.getVrfName().equals(dhcpIfCfg.getVrfName())) continue;
                dhcpRelayIfCgfMap.put(l3vpn, dhcpIfCfg);
                continue block0;
            }
        }
        return dhcpRelayIfCgfMap;
    }

    private Map<L3vpnInstance, Collection<ServerAddr>> getServerAddrMap(Collection<L3vpnInstance> l3vpns, Collection<ServerAddr> dhcpRelayGiaddrs) {
        HashMap<L3vpnInstance, Collection<ServerAddr>> dhcpRelayIfCgfMap = new HashMap<L3vpnInstance, Collection<ServerAddr>>();
        for (L3vpnInstance l3vpn : l3vpns) {
            ArrayList<ServerAddr> giaddr = new ArrayList<ServerAddr>();
            for (ServerAddr dhcpIfCfg : dhcpRelayGiaddrs) {
                if (l3vpn.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || !l3vpn.getVrfName().equals(dhcpIfCfg.getVrfName())) continue;
                giaddr.add(dhcpIfCfg);
            }
            dhcpRelayIfCgfMap.put(l3vpn, giaddr);
        }
        return dhcpRelayIfCgfMap;
    }

    public void processDhcpToL3vpn(Map<L3vpnInstance, Collection<Interface>> vrf2Sap, Object objContext) {
        IAsnTranslationContext context = (IAsnTranslationContext)objContext;
        try {
            for (Map.Entry<L3vpnInstance, Collection<Interface>> entey : vrf2Sap.entrySet()) {
                Collection<Interface> interfaceKeys = entey.getValue();
                DhcpDao dao = (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, DhcpDao.class);
                Collection<DhcpRelayIfCfg> dhcpRelayResults = dao.queryDhcpRelayIfCfg(interfaceKeys);
                if (CollectionUtils.isEmpty(dhcpRelayResults)) {
                    return;
                }
                Map<Interface, DhcpRelayIfCfg> ifCfgMap = this.getDhcpRelayIfCfgMap(interfaceKeys, dhcpRelayResults);
                Collection<DhcpRelayGiaddr> dhcpRelayGiaddrs = dao.queryDhcpRelayGiaddrs(ifCfgMap.keySet());
                Collection<DhcpRelayServerAddr> dhcpRelayServerAddrs = dao.queryDhcpRelayServerAddrs(ifCfgMap.keySet());
                Collection<DhcpOpt82Intf> opt82Intfs = dao.queryDhcpOption82Intf(ifCfgMap.keySet());
                Collection<DhcpIntfOpt82Formate> opt82Formates = dao.queryDhcpOption82Formates(ifCfgMap.keySet());
                Map<Interface, Collection<DhcpRelayGiaddr>> realayGiaddrMap = this.getDhcpRelayGiaddrMap(ifCfgMap.keySet(), dhcpRelayGiaddrs);
                Map<Interface, Collection<DhcpRelayServerAddr>> realyServerMap = this.getDhcpRelayServerMap(ifCfgMap.keySet(), dhcpRelayServerAddrs);
                Map<Interface, DhcpOpt82Intf> opt82IntfMap = this.getDhcpOpt82IntfMap(ifCfgMap.keySet(), opt82Intfs);
                Map<Interface, Collection<DhcpIntfOpt82Formate>> opt82FormateMap = this.getDhcpIntfOpt82FormateMap(ifCfgMap.keySet(), opt82Formates);
                for (Interface interfaceKey : ifCfgMap.keySet()) {
                    DhcpRelayIfCfg dhcpRelayResult = ifCfgMap.get(interfaceKey);
                    if (dhcpRelayResult == null) continue;
                    dhcpRelayResult.setDhcpRelayGiaddrs(realayGiaddrMap.get(interfaceKey));
                    dhcpRelayResult.setDhcpRelayServerAddrs(realyServerMap.get(interfaceKey));
                    Utility.INSTANCE.addMo2Context(context.getTransactionContext(), context.getOperType(), DhcpRelayIfCfg.class, dhcpRelayResult, (VmfMO)entey.getKey());
                    DhcpOpt82Intf opt82Intf = opt82IntfMap.get(interfaceKey);
                    Utility.INSTANCE.addMo2Context(context.getTransactionContext(), context.getOperType(), DhcpOpt82Intf.class, opt82Intf, (VmfMO)entey.getKey());
                    Collection<DhcpIntfOpt82Formate> opt82Formate = opt82FormateMap.get(interfaceKey);
                    if (CollectionUtils.isEmpty(opt82Formate)) continue;
                    Iterator<DhcpIntfOpt82Formate> it = opt82Formate.iterator();
                    while (it.hasNext()) {
                        Utility.INSTANCE.addMo2Context(context.getTransactionContext(), context.getOperType(), DhcpIntfOpt82Formate.class, it.next(), (VmfMO)entey.getKey());
                    }
                }
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.processSAP error", (Throwable)e);
        }
    }

    private Map<Interface, DhcpRelayIfCfg> getDhcpRelayIfCfgMap(Collection<Interface> interfaceKeys, Collection<DhcpRelayIfCfg> dhcpRelayResults) {
        HashMap<Interface, DhcpRelayIfCfg> dhcpRelayIfCgfMap = new HashMap<Interface, DhcpRelayIfCfg>();
        block0: for (Interface interfaceKey : interfaceKeys) {
            for (DhcpRelayIfCfg dhcpIfCfg : dhcpRelayResults) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getInterfaceName())) continue;
                dhcpRelayIfCgfMap.put(interfaceKey, dhcpIfCfg);
                continue block0;
            }
        }
        return dhcpRelayIfCgfMap;
    }

    private Map<Interface, Collection<DhcpRelayGiaddr>> getDhcpRelayGiaddrMap(Collection<Interface> interfaceKeys, Collection<DhcpRelayGiaddr> dhcpRelayGiaddrs) {
        HashMap<Interface, Collection<DhcpRelayGiaddr>> dhcpRelayIfCgfMap = new HashMap<Interface, Collection<DhcpRelayGiaddr>>();
        for (Interface interfaceKey : interfaceKeys) {
            ArrayList<DhcpRelayGiaddr> giaddr = new ArrayList<DhcpRelayGiaddr>();
            for (DhcpRelayGiaddr dhcpIfCfg : dhcpRelayGiaddrs) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getInterfaceName())) continue;
                giaddr.add(dhcpIfCfg);
            }
            dhcpRelayIfCgfMap.put(interfaceKey, giaddr);
        }
        return dhcpRelayIfCgfMap;
    }

    private Map<Interface, Collection<DhcpRelayServerAddr>> getDhcpRelayServerMap(Collection<Interface> interfaceKeys, Collection<DhcpRelayServerAddr> dhcpRelayGiaddrs) {
        HashMap<Interface, Collection<DhcpRelayServerAddr>> dhcpRelayIfCgfMap = new HashMap<Interface, Collection<DhcpRelayServerAddr>>();
        for (Interface interfaceKey : interfaceKeys) {
            ArrayList<DhcpRelayServerAddr> giaddr = new ArrayList<DhcpRelayServerAddr>();
            for (DhcpRelayServerAddr dhcpIfCfg : dhcpRelayGiaddrs) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getInterfaceName())) continue;
                giaddr.add(dhcpIfCfg);
            }
            dhcpRelayIfCgfMap.put(interfaceKey, giaddr);
        }
        return dhcpRelayIfCgfMap;
    }

    private Map<Interface, DhcpOpt82Intf> getDhcpOpt82IntfMap(Collection<Interface> interfaceKeys, Collection<DhcpOpt82Intf> dhcpRelayResults) {
        HashMap<Interface, DhcpOpt82Intf> dhcpRelayIfCgfMap = new HashMap<Interface, DhcpOpt82Intf>();
        block0: for (Interface interfaceKey : interfaceKeys) {
            for (DhcpOpt82Intf dhcpIfCfg : dhcpRelayResults) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getIfName())) continue;
                dhcpRelayIfCgfMap.put(interfaceKey, dhcpIfCfg);
                continue block0;
            }
        }
        return dhcpRelayIfCgfMap;
    }

    private Map<Interface, Collection<DhcpIntfOpt82Formate>> getDhcpIntfOpt82FormateMap(Collection<Interface> interfaceKeys, Collection<DhcpIntfOpt82Formate> dhcpRelayGiaddrs) {
        HashMap<Interface, Collection<DhcpIntfOpt82Formate>> dhcpRelayIfCgfMap = new HashMap<Interface, Collection<DhcpIntfOpt82Formate>>();
        for (Interface interfaceKey : interfaceKeys) {
            ArrayList<DhcpIntfOpt82Formate> giaddr = new ArrayList<DhcpIntfOpt82Formate>();
            for (DhcpIntfOpt82Formate dhcpIfCfg : dhcpRelayGiaddrs) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getIfName())) continue;
                giaddr.add(dhcpIfCfg);
            }
            dhcpRelayIfCgfMap.put(interfaceKey, giaddr);
        }
        return dhcpRelayIfCgfMap;
    }
}

