/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.dhcp.service;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpRelay;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnOption82Conf;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnOption82ConfList;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.dhcp.common.Utility;
import com.huawei.vmf.adapter.dhcp.dao.DhcpDao;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnOption82ConfTranslator;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnOption82InsTranslator;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnVpnDhcpRelayTranslator;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IIfmAssociateFunctionExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpIntfOpt82Formate;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpOpt82Intf;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayGiaddr;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayServerAddr;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayVpnCfg;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DhcpExtPoint
implements IIfmAssociateFunctionExtPoint {
    private Logger logger = LoggerFactory.getLogger(DhcpExtPoint.class);

    public Collection<Interface> processSAP(Collection<Interface> interfaceKeys, IAsnTranslationContext context) {
        return interfaceKeys;
    }

    public void decode(FStruct req, Interface mo, IAsnTranslationContext context) {
        try {
            context.addProperty(Interface.class.getName(), (Object)mo);
            QAsnSAP asn = (QAsnSAP)req;
            if (EOperationType.MODIFY.equals((Object)context.getOperType())) {
                if (asn.poOperMask == null || asn.poOperMask == 0 || asn.poDhcpRelay == null) {
                    return;
                }
                DhcpDao dao = (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, DhcpDao.class);
                DhcpRelayIfCfg dhcpRelayResult = dao.queryDhcpRelayIfCfg(mo);
                if (dhcpRelayResult != null) {
                    Collection<DhcpRelayGiaddr> giadd = dao.queryDhcpRelayGiaddr(mo);
                    dhcpRelayResult.addDhcpRelayGiaddrs(giadd);
                    Collection<DhcpRelayServerAddr> serverAddr = dao.queryDhcpRelayServerAddr(mo);
                    dhcpRelayResult.addDhcpRelayServerAddrs(serverAddr);
                    DhcpRelayIfCfg delayMo = null;
                    Integer dhcpOperMask = asn.poDhcpRelay.poOperMask;
                    if (asn.poOperMask == 2) {
                        context.getTransactionContext().addDBChangeRecord(DhcpRelayIfCfg.class).addDelete((Object)dhcpRelayResult);
                        mo.addKeyRefMo((VmfMO)dhcpRelayResult);
                    } else {
                        delayMo = Utility.INSTANCE.decodeSap(asn.poDhcpRelay, context);
                        if (delayMo != null) {
                            ArrayList<Object> deleteServerList;
                            HashMap<String, Object> newRecord;
                            HashMap<String, Object> existRecord;
                            if (null != dhcpOperMask && (2 & dhcpOperMask) > 0) {
                                existRecord = new HashMap<String, Object>();
                                newRecord = new HashMap<String, Object>();
                                if (!CollectionUtils.isEmpty(serverAddr)) {
                                    for (DhcpRelayServerAddr dhcpRelayServerAddr : serverAddr) {
                                        existRecord.put(dhcpRelayServerAddr.getKey(), dhcpRelayServerAddr);
                                    }
                                }
                                if (!CollectionUtils.isEmpty((Collection)delayMo.getDhcpRelayServerAddrs())) {
                                    for (DhcpRelayServerAddr dhcpRelayServerAddr : delayMo.getDhcpRelayServerAddrs()) {
                                        newRecord.put(dhcpRelayServerAddr.getKey(), dhcpRelayServerAddr);
                                        if (existRecord.get(dhcpRelayServerAddr.getKey()) != null) continue;
                                        context.getTransactionContext().addChangeRecord(DhcpRelayServerAddr.class).addCreate((Object)dhcpRelayServerAddr);
                                    }
                                }
                                deleteServerList = new ArrayList<Object>();
                                if (!CollectionUtils.isEmpty(serverAddr)) {
                                    for (DhcpRelayServerAddr dhcpRelayServerAddr : serverAddr) {
                                        if (newRecord.get(dhcpRelayServerAddr.getKey()) != null) continue;
                                        deleteServerList.add(dhcpRelayServerAddr);
                                    }
                                }
                                context.getTransactionContext().addChangeRecord(DhcpRelayServerAddr.class).addDelete(deleteServerList);
                                delayMo.addDhcpRelayServerAddrs(deleteServerList);
                            }
                            if (null != dhcpOperMask && (0x20 & dhcpOperMask) > 0) {
                                existRecord = new HashMap();
                                newRecord = new HashMap();
                                if (!CollectionUtils.isEmpty(giadd)) {
                                    for (DhcpRelayGiaddr dhcpRelayGiaddr : giadd) {
                                        existRecord.put(dhcpRelayGiaddr.getKey(), dhcpRelayGiaddr);
                                    }
                                }
                                if (!CollectionUtils.isEmpty((Collection)delayMo.getDhcpRelayGiaddrs())) {
                                    for (DhcpRelayGiaddr dhcpRelayGiaddr : delayMo.getDhcpRelayGiaddrs()) {
                                        newRecord.put(dhcpRelayGiaddr.getKey(), dhcpRelayGiaddr);
                                        if (existRecord.get(dhcpRelayGiaddr.getKey()) != null) continue;
                                        context.getTransactionContext().addChangeRecord(DhcpRelayGiaddr.class).addCreate((Object)dhcpRelayGiaddr);
                                    }
                                }
                                deleteServerList = new ArrayList();
                                if (!CollectionUtils.isEmpty(giadd)) {
                                    for (DhcpRelayGiaddr dhcpRelayGiaddr : giadd) {
                                        if (newRecord.get(dhcpRelayGiaddr.getKey()) != null) continue;
                                        deleteServerList.add(dhcpRelayGiaddr);
                                    }
                                }
                                context.getTransactionContext().addChangeRecord(DhcpRelayGiaddr.class).addDelete(deleteServerList);
                                delayMo.addDhcpRelayGiaddrs(deleteServerList);
                            }
                            mo.addKeyRefMo((VmfMO)delayMo);
                        }
                    }
                    DhcpOpt82Intf opt82Intf = dao.queryDhcpOption82Intf(mo);
                    if (opt82Intf != null) {
                        if (asn.poOperMask == 2) {
                            context.getTransactionContext().addDBChangeRecord(DhcpOpt82Intf.class).addDelete((Object)opt82Intf);
                            mo.addKeyRefMo((VmfMO)opt82Intf);
                        } else if (null != dhcpOperMask && (0x40 & dhcpOperMask) > 0) {
                            DhcpOpt82Intf decodeOpt82Intf = Utility.INSTANCE.decodeOpt82Intf(asn.poDhcpRelay, context);
                            context.getTransactionContext().addChangeRecord(DhcpOpt82Intf.class).addModify((Object)decodeOpt82Intf, new PropertyChangeItem("insertEnable", (Object)decodeOpt82Intf.getInsertEnable(), (Object)opt82Intf.getInsertEnable()));
                            context.getTransactionContext().addChangeRecord(DhcpOpt82Intf.class).addModify((Object)decodeOpt82Intf, new PropertyChangeItem("rebuildEnable", (Object)decodeOpt82Intf.getRebuildEnable(), (Object)opt82Intf.getRebuildEnable()));
                            mo.addKeyRefMo((VmfMO)decodeOpt82Intf);
                        }
                    }
                    Collection<DhcpIntfOpt82Formate> opt82Formates = dao.queryDhcpOption82Formates(mo);
                    if (asn.poOperMask == 2) {
                        context.getTransactionContext().addDBChangeRecord(DhcpIntfOpt82Formate.class).addDelete(opt82Formates);
                        mo.addKeyRefMos(opt82Formates);
                    } else if (null != dhcpOperMask && (0x80 & dhcpOperMask) > 0) {
                        Collection<DhcpIntfOpt82Formate> opt82s = Utility.INSTANCE.decodeModifyOption82Conf(asn.poDhcpRelay, context);
                        mo.addKeyRefMos(opt82s);
                    }
                } else if (asn.poDhcpRelay != null && asn.poDhcpRelay.enableState != 0) {
                    DhcpOpt82Intf decodeOpt82Intf;
                    DhcpRelayIfCfg delayMo = Utility.INSTANCE.decodeSap(asn.poDhcpRelay, context);
                    context.getTransactionContext().addChangeRecord(DhcpRelayIfCfg.class).cancelModify((Object)delayMo);
                    context.getTransactionContext().addChangeRecord(DhcpRelayIfCfg.class).addCreate((Object)delayMo);
                    mo.addKeyRefMo((VmfMO)delayMo);
                    if (asn.poDhcpRelay.poOption82Mode != null && asn.poDhcpRelay.poOption82Mode != -1 && (decodeOpt82Intf = Utility.INSTANCE.decodeOpt82Intf(asn.poDhcpRelay, context)) != null) {
                        context.getTransactionContext().addChangeRecord(DhcpOpt82Intf.class).addCreate((Object)decodeOpt82Intf);
                        mo.addKeyRefMo((VmfMO)decodeOpt82Intf);
                    }
                    Collection<DhcpIntfOpt82Formate> opt82s = Utility.INSTANCE.decodeOption82Conf(asn.poDhcpRelay, context);
                    context.getTransactionContext().addChangeRecord(DhcpIntfOpt82Formate.class).addCreate(opt82s);
                    mo.addKeyRefMos(opt82s);
                }
            } else {
                if (null == asn.poDhcpRelay) {
                    return;
                }
                if (asn.poDhcpRelay.enableState != 0) {
                    DhcpOpt82Intf decodeOpt82Intf;
                    DhcpRelayIfCfg delayMo = Utility.INSTANCE.decodeSap(asn.poDhcpRelay, context);
                    mo.addKeyRefMo((VmfMO)delayMo);
                    if (asn.poDhcpRelay.poOption82Mode != null && asn.poDhcpRelay.poOption82Mode != -1 && (decodeOpt82Intf = Utility.INSTANCE.decodeOpt82Intf(asn.poDhcpRelay, context)) != null) {
                        mo.addKeyRefMo((VmfMO)decodeOpt82Intf);
                        Collection<DhcpIntfOpt82Formate> opt82s = Utility.INSTANCE.decodeOption82Conf(asn.poDhcpRelay, context);
                        mo.addKeyRefMos(opt82s);
                    }
                }
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.decode error", (Throwable)e);
        }
    }

    public void decodeDhcpRealyVpn(FStruct req, L3vpnInstance vpn, IAsnTranslationContext context) {
        try {
            if (req == null) {
                return;
            }
            QAsnDhcpRelay asn = (QAsnDhcpRelay)req;
            if (EOperationType.MODIFY.equals((Object)context.getOperType())) {
                if (asn.poOperMask == null || asn.poOperMask == 0) {
                    return;
                }
                DhcpDao dao = (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, DhcpDao.class);
                DhcpRelayVpnCfg dhcpRelayResult = dao.queryDhcpRelayVpnCfg(vpn);
                if (dhcpRelayResult != null) {
                    dhcpRelayResult.setServerAddrs(dao.queryDhcpRelayServerVpnAddr(vpn));
                    Utility.INSTANCE.unDeployMo(Arrays.asList(dhcpRelayResult), DhcpRelayVpnCfg.class, dhcpRelayResult.getDeployStatus() == 1);
                    DhcpRelayVpnCfg delayMo = (DhcpRelayVpnCfg)new QAsnVpnDhcpRelayTranslator().decode((FStruct)asn, context);
                    if (delayMo != null) {
                        Utility.INSTANCE.deployMo(Arrays.asList(delayMo), DhcpRelayVpnCfg.class, dhcpRelayResult.getDeployStatus() == 1);
                    }
                } else {
                    DhcpRelayVpnCfg delayMo = (DhcpRelayVpnCfg)new QAsnVpnDhcpRelayTranslator().decode((FStruct)asn, context);
                    Utility.INSTANCE.deployMo(Arrays.asList(delayMo), DhcpRelayVpnCfg.class, vpn.getDeployStatus() == 1);
                    context.getTransactionContext().addChangeRecord(DhcpRelayVpnCfg.class).cancelCreate((Object)delayMo);
                }
            } else {
                DhcpRelayVpnCfg delayMo = (DhcpRelayVpnCfg)new QAsnVpnDhcpRelayTranslator().decode((FStruct)asn, context);
                vpn.addKeyRefMo((VmfMO)delayMo);
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.decode error", (Throwable)e);
        }
    }

    public void encode(Interface mo, FStruct rsp, IAsnTranslationContext context) {
        try {
            if (mo == null || rsp == null) {
                return;
            }
            List dhcpRelayIfCfgs = mo.getKeyRefMos(DhcpRelayIfCfg.class);
            if (CollectionUtils.isEmpty((Collection)dhcpRelayIfCfgs)) {
                return;
            }
            DhcpRelayIfCfg dhcpRelayResult = (DhcpRelayIfCfg)dhcpRelayIfCfgs.iterator().next();
            if (dhcpRelayResult != null) {
                QAsnSAP qasn = (QAsnSAP)rsp;
                qasn.poDhcpRelay = Utility.INSTANCE.encodeSap(dhcpRelayResult, context);
                List opt82Intfs = mo.getKeyRefMos(DhcpOpt82Intf.class);
                if (CollectionUtils.isEmpty((Collection)opt82Intfs)) {
                    return;
                }
                DhcpOpt82Intf opt82 = (DhcpOpt82Intf)opt82Intfs.iterator().next();
                if (opt82 != null) {
                    List opt82Formates;
                    new QAsnOption82InsTranslator().encode(opt82, qasn.poDhcpRelay, context);
                    if (!dhcpRelayResult.getIsEnable().booleanValue()) {
                        qasn.poDhcpRelay.poOption82Mode = -1;
                    }
                    if (CollectionUtils.isEmpty((Collection)(opt82Formates = mo.getKeyRefMos(DhcpIntfOpt82Formate.class)))) {
                        return;
                    }
                    if (qasn.poDhcpRelay.lstOption82Conf == null) {
                        qasn.poDhcpRelay.lstOption82Conf = new QAsnOption82ConfList();
                    }
                    Iterator it = opt82Formates.iterator();
                    while (it.hasNext()) {
                        QAsnOption82Conf qasnDhcpAddress = new QAsnOption82Conf();
                        qasn.poDhcpRelay.lstOption82Conf.add((Object)qasnDhcpAddress);
                        AsnUtil.setDefaultAsnValue((FStruct)qasnDhcpAddress);
                        new QAsnOption82ConfTranslator().encode((DhcpIntfOpt82Formate)it.next(), qasnDhcpAddress, context);
                    }
                }
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.encode error", (Throwable)e);
        }
    }

    public Collection<L3vpnInstance> processDhcpRelayVpn(Collection<L3vpnInstance> l3vpns, Context context, EOperationType operType) {
        try {
            DhcpDao dao = (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, DhcpDao.class);
            for (L3vpnInstance l3vpn : l3vpns) {
                DhcpRelayVpnCfg dhcpRelayResult = dao.queryDhcpRelayVpnCfg(l3vpn);
                if (dhcpRelayResult != null) {
                    dhcpRelayResult.setServerAddrs(dao.queryDhcpRelayServerVpnAddr(l3vpn));
                }
                Utility.INSTANCE.addMo2Context(context, operType, DhcpRelayVpnCfg.class, dhcpRelayResult, (VmfMO)l3vpn);
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.processSAP error", (Throwable)e);
        }
        return l3vpns;
    }

    public Map<L3vpnInstance, DhcpRelayVpnCfg> processDhcpRelayVpnFromDb(Collection<L3vpnInstance> l3vpns) {
        HashMap<L3vpnInstance, DhcpRelayVpnCfg> vrfRelayVpns = new HashMap<L3vpnInstance, DhcpRelayVpnCfg>();
        try {
            DhcpDao dao = (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, DhcpDao.class);
            for (L3vpnInstance l3vpn : l3vpns) {
                DhcpRelayVpnCfg dhcpRelayResult = dao.queryDhcpRelayVpnCfg(l3vpn);
                if (dhcpRelayResult != null) {
                    dhcpRelayResult.setServerAddrs(dao.queryDhcpRelayServerVpnAddr(l3vpn));
                }
                vrfRelayVpns.put(l3vpn, dhcpRelayResult);
            }
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.processSAP error", (Throwable)e);
        }
        return vrfRelayVpns;
    }

    public QAsnDhcpRelay encodeDhcpRelayVpn(DhcpRelayVpnCfg mo, IAsnTranslationContext context) throws VMFException {
        return (QAsnDhcpRelay)new QAsnVpnDhcpRelayTranslator().encode(mo, context);
    }
}

