/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.dhcp.dao;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.DefaultDao;
import com.huawei.vmf.adapter.framework.dao.RelationMetaMgr;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpIntfOpt82Formate;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpOpt82Intf;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayGiaddr;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayServerAddr;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayVpnCfg;
import com.huawei.vmf.adapter.fservice.dhcp.model.ServerAddr;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.SessionFactory;
import org.springframework.util.CollectionUtils;

public class DhcpDao
extends DefaultDao {
    protected DhcpDao(SessionFactory sf, RelationMetaMgr relationMgr) {
        super(sf, relationMgr);
    }

    public static DhcpDao newInstance() {
        return (DhcpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, new Context(), DhcpDao.class);
    }

    public DhcpRelayIfCfg queryDhcpRelayIfCfg(Interface interfaceKey) throws VMFException {
        if (null == interfaceKey) {
            return null;
        }
        ArrayList<DhcpRelayIfCfg> dhcpRelayFilter = new ArrayList<DhcpRelayIfCfg>();
        DhcpRelayIfCfg dhcpRelay = new DhcpRelayIfCfg();
        dhcpRelay.setDevID(interfaceKey.getDevID());
        dhcpRelay.setInterfaceName(interfaceKey.getIfName());
        dhcpRelayFilter.add(dhcpRelay);
        Collection dhcpRelayResult = this.queryByFields(DhcpRelayIfCfg.class, new String[]{"devID", "interfaceName"}, dhcpRelayFilter, false);
        if (dhcpRelayResult != null && !dhcpRelayResult.isEmpty()) {
            return (DhcpRelayIfCfg)dhcpRelayResult.iterator().next();
        }
        return null;
    }

    public Collection<DhcpRelayIfCfg> queryDhcpRelayIfCfg(Collection<Interface> interfaceKeys) throws VMFException {
        if (null == interfaceKeys || interfaceKeys.isEmpty()) {
            return new ArrayList<DhcpRelayIfCfg>();
        }
        ArrayList<DhcpRelayIfCfg> dhcpRelayFilter = new ArrayList<DhcpRelayIfCfg>();
        for (Interface interfaceKey : interfaceKeys) {
            DhcpRelayIfCfg dhcpRelay = new DhcpRelayIfCfg();
            dhcpRelay.setDevID(interfaceKey.getDevID());
            dhcpRelay.setInterfaceName(interfaceKey.getIfName());
            dhcpRelayFilter.add(dhcpRelay);
        }
        Collection dhcpRelayResult = this.queryByFields(DhcpRelayIfCfg.class, new String[]{"devID", "interfaceName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public DhcpRelayVpnCfg queryDhcpRelayVpnCfg(L3vpnInstance l3vpn) throws VMFException {
        if (null == l3vpn) {
            return null;
        }
        ArrayList<DhcpRelayVpnCfg> dhcpRelayFilter = new ArrayList<DhcpRelayVpnCfg>();
        DhcpRelayVpnCfg dhcpRelay = new DhcpRelayVpnCfg();
        dhcpRelay.setDevID(l3vpn.getDevID());
        dhcpRelay.setVrfName(l3vpn.getVrfName());
        dhcpRelayFilter.add(dhcpRelay);
        Collection dhcpRelayResult = this.queryByFields(DhcpRelayVpnCfg.class, new String[]{"devID", "vrfName"}, dhcpRelayFilter, false);
        if (dhcpRelayResult != null && !dhcpRelayResult.isEmpty()) {
            return (DhcpRelayVpnCfg)dhcpRelayResult.iterator().next();
        }
        return null;
    }

    public Collection<DhcpRelayVpnCfg> queryDhcpRelayVpnCfgs(Collection<L3vpnInstance> l3vpns) throws VMFException {
        if (null == l3vpns || l3vpns.isEmpty()) {
            return new ArrayList<DhcpRelayVpnCfg>();
        }
        ArrayList<DhcpRelayVpnCfg> dhcpRelayFilter = new ArrayList<DhcpRelayVpnCfg>();
        for (L3vpnInstance l3vpn : l3vpns) {
            DhcpRelayVpnCfg dhcpRelay = new DhcpRelayVpnCfg();
            dhcpRelay.setDevID(l3vpn.getDevID());
            dhcpRelay.setVrfName(l3vpn.getVrfName());
            dhcpRelayFilter.add(dhcpRelay);
        }
        Collection dhcpRelayResult = this.queryByFields(DhcpRelayVpnCfg.class, new String[]{"devID", "vrfName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public Collection<DhcpRelayServerAddr> queryDhcpRelayServerAddr(Interface interfaceKey) throws VMFException {
        if (null == interfaceKey) {
            return null;
        }
        ArrayList<DhcpRelayServerAddr> dhcpRelayFilter = new ArrayList<DhcpRelayServerAddr>();
        DhcpRelayServerAddr dhcpRelay = new DhcpRelayServerAddr();
        dhcpRelay.setDevID(interfaceKey.getDevID());
        dhcpRelay.setInterfaceName(interfaceKey.getIfName());
        dhcpRelayFilter.add(dhcpRelay);
        Collection dhcpRelayResult = this.queryByFields(DhcpRelayServerAddr.class, new String[]{"devID", "interfaceName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public Collection<DhcpRelayServerAddr> queryDhcpRelayServerAddrs(Collection<Interface> interfaceKeys) throws VMFException {
        if (null == interfaceKeys || interfaceKeys.isEmpty()) {
            return new ArrayList<DhcpRelayServerAddr>();
        }
        ArrayList<DhcpRelayServerAddr> dhcpRelayFilter = new ArrayList<DhcpRelayServerAddr>();
        for (Interface interfaceKey : interfaceKeys) {
            DhcpRelayServerAddr dhcpRelay = new DhcpRelayServerAddr();
            dhcpRelay.setDevID(interfaceKey.getDevID());
            dhcpRelay.setInterfaceName(interfaceKey.getIfName());
            dhcpRelayFilter.add(dhcpRelay);
        }
        Collection dhcpRelayResult = this.queryByFields(DhcpRelayServerAddr.class, new String[]{"devID", "interfaceName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public Collection<ServerAddr> queryDhcpRelayServerVpnAddr(L3vpnInstance l3vpn) throws VMFException {
        if (null == l3vpn) {
            return null;
        }
        ArrayList<ServerAddr> dhcpRelayFilter = new ArrayList<ServerAddr>();
        ServerAddr dhcpRelay = new ServerAddr();
        dhcpRelay.setDevID(l3vpn.getDevID());
        dhcpRelay.setVrfName(l3vpn.getVrfName());
        dhcpRelayFilter.add(dhcpRelay);
        Collection dhcpRelayResult = this.queryByFields(ServerAddr.class, new String[]{"devID", "vrfName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public Collection<ServerAddr> queryDhcpRelayServerVpnAddrs(Collection<L3vpnInstance> l3vpns) throws VMFException {
        if (null == l3vpns || l3vpns.isEmpty()) {
            return new ArrayList<ServerAddr>();
        }
        ArrayList<ServerAddr> dhcpRelayFilter = new ArrayList<ServerAddr>();
        for (L3vpnInstance l3vpn : l3vpns) {
            ServerAddr dhcpRelay = new ServerAddr();
            dhcpRelay.setDevID(l3vpn.getDevID());
            dhcpRelay.setVrfName(l3vpn.getVrfName());
            dhcpRelayFilter.add(dhcpRelay);
        }
        Collection dhcpRelayResult = this.queryByFields(ServerAddr.class, new String[]{"devID", "vrfName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public Collection<DhcpRelayGiaddr> queryDhcpRelayGiaddr(Interface interfaceKey) throws VMFException {
        if (null == interfaceKey) {
            return null;
        }
        ArrayList<DhcpRelayGiaddr> dhcpRelayFilter = new ArrayList<DhcpRelayGiaddr>();
        DhcpRelayGiaddr dhcpRelay = new DhcpRelayGiaddr();
        dhcpRelay.setDevID(interfaceKey.getDevID());
        dhcpRelay.setInterfaceName(interfaceKey.getIfName());
        dhcpRelayFilter.add(dhcpRelay);
        Collection dhcpRelayResult = this.queryByFields(DhcpRelayGiaddr.class, new String[]{"devID", "interfaceName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public Collection<DhcpRelayGiaddr> queryDhcpRelayGiaddrs(Collection<Interface> interfaceKeys) throws VMFException {
        if (null == interfaceKeys || interfaceKeys.isEmpty()) {
            return new ArrayList<DhcpRelayGiaddr>();
        }
        ArrayList<DhcpRelayGiaddr> dhcpRelayFilter = new ArrayList<DhcpRelayGiaddr>();
        for (Interface interfaceKey : interfaceKeys) {
            DhcpRelayGiaddr dhcpRelay = new DhcpRelayGiaddr();
            dhcpRelay.setDevID(interfaceKey.getDevID());
            dhcpRelay.setInterfaceName(interfaceKey.getIfName());
            dhcpRelayFilter.add(dhcpRelay);
        }
        Collection dhcpRelayResult = this.queryByFields(DhcpRelayGiaddr.class, new String[]{"devID", "interfaceName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public DhcpOpt82Intf queryDhcpOption82Intf(Interface interfaceKey) throws VMFException {
        if (null == interfaceKey) {
            return null;
        }
        ArrayList<DhcpOpt82Intf> dhcpRelayFilter = new ArrayList<DhcpOpt82Intf>();
        DhcpOpt82Intf dhcpRelay = new DhcpOpt82Intf();
        dhcpRelay.setDevID(interfaceKey.getDevID());
        dhcpRelay.setIfName(interfaceKey.getIfName());
        dhcpRelayFilter.add(dhcpRelay);
        Collection dhcpRelayResult = this.queryByFields(DhcpOpt82Intf.class, new String[]{"devID", "ifName"}, dhcpRelayFilter, false);
        if (dhcpRelayResult != null && !dhcpRelayResult.isEmpty()) {
            return (DhcpOpt82Intf)dhcpRelayResult.iterator().next();
        }
        return null;
    }

    public Collection<DhcpOpt82Intf> queryDhcpOption82Intf(Collection<Interface> interfaceKeys) throws VMFException {
        if (null == interfaceKeys || interfaceKeys.isEmpty()) {
            return new ArrayList<DhcpOpt82Intf>();
        }
        ArrayList<DhcpOpt82Intf> dhcpRelayFilter = new ArrayList<DhcpOpt82Intf>();
        for (Interface interfaceKey : interfaceKeys) {
            DhcpOpt82Intf dhcpRelay = new DhcpOpt82Intf();
            dhcpRelay.setDevID(interfaceKey.getDevID());
            dhcpRelay.setIfName(interfaceKey.getIfName());
            dhcpRelayFilter.add(dhcpRelay);
        }
        Collection dhcpRelayResult = this.queryByFields(DhcpOpt82Intf.class, new String[]{"devID", "ifName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public Collection<DhcpIntfOpt82Formate> queryDhcpOption82Formates(Interface interfaceKey) throws VMFException {
        if (null == interfaceKey) {
            return null;
        }
        ArrayList<DhcpIntfOpt82Formate> dhcpRelayFilter = new ArrayList<DhcpIntfOpt82Formate>();
        DhcpIntfOpt82Formate dhcpRelay = new DhcpIntfOpt82Formate();
        dhcpRelay.setDevID(interfaceKey.getDevID());
        dhcpRelay.setIfName(interfaceKey.getIfName());
        dhcpRelayFilter.add(dhcpRelay);
        Collection dhcpRelayResult = this.queryByFields(DhcpIntfOpt82Formate.class, new String[]{"devID", "ifName"}, dhcpRelayFilter, false);
        if (!CollectionUtils.isEmpty((Collection)dhcpRelayResult)) {
            Iterator it = dhcpRelayResult.iterator();
            while (it.hasNext()) {
                ((DhcpIntfOpt82Formate)it.next()).setOptFormat(DhcpIntfOpt82Formate.OPT_FORMAT_ENUM.SELF_DEFINE);
            }
        }
        return dhcpRelayResult;
    }

    public Collection<DhcpIntfOpt82Formate> queryDhcpOption82Formates(Collection<Interface> interfaceKeys) throws VMFException {
        if (null == interfaceKeys || interfaceKeys.isEmpty()) {
            return new ArrayList<DhcpIntfOpt82Formate>();
        }
        ArrayList<DhcpIntfOpt82Formate> dhcpRelayFilter = new ArrayList<DhcpIntfOpt82Formate>();
        for (Interface interfaceKey : interfaceKeys) {
            DhcpIntfOpt82Formate dhcpRelay = new DhcpIntfOpt82Formate();
            dhcpRelay.setDevID(interfaceKey.getDevID());
            dhcpRelay.setIfName(interfaceKey.getIfName());
            dhcpRelayFilter.add(dhcpRelay);
        }
        Collection dhcpRelayResult = this.queryByFields(DhcpIntfOpt82Formate.class, new String[]{"devID", "ifName"}, dhcpRelayFilter, false);
        if (!CollectionUtils.isEmpty((Collection)dhcpRelayResult)) {
            Iterator it = dhcpRelayResult.iterator();
            while (it.hasNext()) {
                ((DhcpIntfOpt82Formate)it.next()).setOptFormat(DhcpIntfOpt82Formate.OPT_FORMAT_ENUM.SELF_DEFINE);
            }
        }
        return dhcpRelayResult;
    }
}

