/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.dhcp.common;

import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpRelay;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnOption82Conf;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.dhcp.Activator;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnDhcpRelayTranslator;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnOption82ConfTranslator;
import com.huawei.vmf.adapter.dhcp.translation.asn.QAsnOption82InsTranslator;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpIntfOpt82Formate;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpOpt82Intf;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayIfCfg;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class Utility {
    public static final int DHCPRELAY_ENABLE_CHG = 1;
    public static final int DHCPRELAY_SERVERADDRLIST_CHG = 2;
    public static final int DHCPRELAY_BOUNDLIMIT_CHG = 4;
    public static final int DHCPRELAY_SELECTPOLICY_CHG = 8;
    public static final int DHCPRELAY_TOS_CHG = 16;
    public static final int DHCPRELAY_IPRELAYGIADDRLIST_CHG = 32;
    public static final int OPTION82_MODE_CHG = 64;
    public static final int OPTION82_CONF_CHG = 128;
    public static final int SOURCEIP_CONF_CHG = 256;
    public static final Object[][] z_qasnDhcpRelayMasks = new Object[0][];
    public static final Object[][] z_dhcpRelayVpnCfgMasks = new Object[][]{{"isEnable", 1}, {"hopLimit", 4}, {"serverPolicy", 8}, {"serverAddrs", 2}};
    public static final Object[][] z_dhcpRelayIfCfgMasks = new Object[][]{{"isEnable", 1}, {"dhcpRelayServerAddrs", 2}, {"dhcpRelayGiaddrs", 32}};
    public static final Utility INSTANCE = new Utility();
    private final Logger logger = RunLogger.getLogger(this.getClass());

    private Utility() {
    }

    public <T extends IAsnTranslator<QAsnDhcpRelay, DhcpRelayIfCfg>> T getDhcpTranslator() {
        return (T)Activator.getAsnTranslator(QAsnDhcpRelay.class, DhcpRelayIfCfg.class);
    }

    public DhcpRelayIfCfg decodeSap(QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        DhcpRelayIfCfg mo = (DhcpRelayIfCfg)new QAsnDhcpRelayTranslator().decode((FStruct)asn, context);
        return mo;
    }

    public DhcpOpt82Intf decodeOpt82Intf(QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        DhcpOpt82Intf mo = (DhcpOpt82Intf)new QAsnOption82InsTranslator().decode((FStruct)asn, context);
        return mo;
    }

    public Collection<DhcpIntfOpt82Formate> decodeOption82Conf(QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        ArrayList<DhcpIntfOpt82Formate> opt82s = new ArrayList<DhcpIntfOpt82Formate>();
        if (asn == null || CollectionUtils.isEmpty((Collection)asn.lstOption82Conf)) {
            return opt82s;
        }
        QAsnOption82ConfTranslator decoder = new QAsnOption82ConfTranslator();
        for (Object asnopt82 : asn.lstOption82Conf) {
            if (((QAsnOption82Conf)asnopt82).poOperMask == 2) continue;
            DhcpIntfOpt82Formate opt82 = new DhcpIntfOpt82Formate();
            decoder.decode((QAsnOption82Conf)asnopt82, opt82, context);
            opt82s.add(opt82);
        }
        return opt82s;
    }

    public Collection<DhcpIntfOpt82Formate> decodeModifyOption82Conf(QAsnDhcpRelay asn, IAsnTranslationContext context) throws VMFException {
        ArrayList<DhcpIntfOpt82Formate> opt82s = new ArrayList<DhcpIntfOpt82Formate>();
        if (asn == null || CollectionUtils.isEmpty((Collection)asn.lstOption82Conf)) {
            return opt82s;
        }
        ArrayList<DhcpIntfOpt82Formate> deletes = new ArrayList<DhcpIntfOpt82Formate>();
        ArrayList<DhcpIntfOpt82Formate> creates = new ArrayList<DhcpIntfOpt82Formate>();
        QAsnOption82ConfTranslator decoder = new QAsnOption82ConfTranslator();
        for (Object asnopt82 : asn.lstOption82Conf) {
            if (((QAsnOption82Conf)asnopt82).poOperMask == 0) continue;
            DhcpIntfOpt82Formate opt82 = new DhcpIntfOpt82Formate();
            decoder.decode((QAsnOption82Conf)asnopt82, opt82, context);
            if (((QAsnOption82Conf)asnopt82).poOperMask == 2) {
                deletes.add(opt82);
                context.getTransactionContext().addChangeRecord(DhcpIntfOpt82Formate.class).addDelete((Object)opt82);
                continue;
            }
            creates.add(opt82);
            context.getTransactionContext().addChangeRecord(DhcpIntfOpt82Formate.class).addCreate((Object)opt82);
        }
        for (DhcpIntfOpt82Formate delete : deletes) {
            boolean modify = false;
            for (DhcpIntfOpt82Formate create : creates) {
                if (!delete.equals((Object)create)) continue;
                modify = true;
                break;
            }
            if (!modify) {
                context.getTransactionContext().addChangeRecord(DhcpIntfOpt82Formate.class).addDelete((Object)delete);
                opt82s.add(delete);
                continue;
            }
            context.getTransactionContext().addChangeRecord(DhcpIntfOpt82Formate.class).cancelDelete((Object)delete);
        }
        for (DhcpIntfOpt82Formate create : creates) {
            boolean modify = false;
            for (DhcpIntfOpt82Formate delete : deletes) {
                if (!delete.equals((Object)create)) continue;
                modify = true;
                context.getTransactionContext().addChangeRecord(DhcpIntfOpt82Formate.class).cancelCreate((Object)create);
                context.getTransactionContext().addChangeRecord(DhcpIntfOpt82Formate.class).addModify((Object)create, new PropertyChangeItem("userDefineText", (Object)create.getUserDefineText(), (Object)delete.getUserDefineText()));
                break;
            }
            if (!modify) {
                context.getTransactionContext().addChangeRecord(DhcpIntfOpt82Formate.class).addCreate((Object)create);
            }
            opt82s.add(create);
        }
        return opt82s;
    }

    public QAsnDhcpRelay encodeSap(DhcpRelayIfCfg mo, IAsnTranslationContext context) throws VMFException {
        return (QAsnDhcpRelay)new QAsnDhcpRelayTranslator().encode(mo, context);
    }

    public <T extends IAsnTranslator<QAsnDhcpRelay, DhcpIntfOpt82Formate>> T getOption82Translator() {
        return (T)Activator.getAsnTranslator(QAsnDhcpRelay.class, DhcpIntfOpt82Formate.class);
    }

    public DhcpIntfOpt82Formate decodeSapOption82(QAsnOption82Conf asn, IAsnTranslationContext context) throws VMFException {
        DhcpIntfOpt82Formate mo = (DhcpIntfOpt82Formate)new QAsnOption82ConfTranslator().decode((FStruct)asn, context);
        return mo;
    }

    public void encodeSapOption82(DhcpIntfOpt82Formate mo, QAsnOption82Conf asn, IAsnTranslationContext context) throws VMFException {
        new QAsnOption82ConfTranslator().encode(mo, asn, context);
        if (!StringUtil.isEmpty((String)mo.getSerialNum())) {
            // empty if block
        }
    }

    public <T extends VmfMO> void addMo2Context(Context cxt, EOperationType operType, Class<T> clazz, T mo, VmfMO mainMo) {
        switch (operType) {
            case CREATE: 
            case PREDEPLOY: {
                cxt.addChangeRecord(clazz).addCreate(mo);
                break;
            }
            case DEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (Integer.valueOf(1).equals(((DeployableMO)mo).getDeployStatus())) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(1));
                    cxt.addDBChangeRecord(clazz).addModify(mo, new PropertyChangeItem("deployStatus", (Object)1, (Object)0));
                }
                cxt.addChangeRecord(clazz).addCreate(mo);
                break;
            }
            case UNDEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (!((DeployableMO)mo).getDeployStatus().equals(1)) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(0));
                    cxt.addDBChangeRecord(clazz).addModify(mo, new PropertyChangeItem("deployStatus", (Object)0, (Object)1));
                }
                cxt.addChangeRecord(clazz).addDelete(mo);
                break;
            }
            case DELETE: {
                cxt.addChangeRecord(clazz).addDelete(mo);
                break;
            }
            case GET: {
                break;
            }
            default: {
                this.logger.error("unsupported oper-type:" + operType.name());
                return;
            }
        }
        this.addKeyRef2MainMo(mainMo, mo, operType, cxt);
    }

    private void addKeyRef2MainMo(VmfMO mainMo, VmfMO mo, EOperationType operType, Context cxt) {
        if (mainMo == null || cxt == null) {
            return;
        }
        mainMo.addKeyRefMo(mo);
        IMOChangeRecord rcd = cxt.addChangeRecord(mainMo.getClass());
        switch (operType) {
            case DEPLOY: {
                if (rcd.isCreated((Object)mainMo) || rcd.isModified((Object)mainMo, mo.getClass().getName())) break;
                rcd.addModify((Object)mainMo, Arrays.asList(mo.getClass().getName()));
                break;
            }
            case UNDEPLOY: {
                if (rcd.isDeleted((Object)mainMo) || rcd.isModified((Object)mainMo, mo.getClass().getName())) break;
                rcd.addModify((Object)mainMo, Arrays.asList(mo.getClass().getName()));
                break;
            }
            case DELETE: {
                break;
            }
        }
    }

    public <T extends VmfMO> void deployMo(Collection<T> mos, Class<T> clazz, boolean deployDev) throws VMFException {
        if (mos == null || mos.isEmpty()) {
            return;
        }
        Context cxt = new Context(false);
        IMOChangeRecord rcd = cxt.addChangeRecord(clazz);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(cxt);
        if (!dao.exists(clazz, mos).isEmpty()) {
            return;
        }
        rcd.addCreate(mos);
        if (deployDev) {
            VmfMO mo = (VmfMO)mos.iterator().next();
            HashMap<FeatureName, List<Class>> features = new HashMap<FeatureName, List<Class>>();
            features.put(mo.getFeatureName(), Arrays.asList(clazz));
            DeviceAccessorFactory.getDefaultNetconfDeployer((int)mo.getDevID(), (Context)cxt).merge(features);
        }
        dao.merge(clazz, true);
        Iterator<T> it = mos.iterator();
        while (it.hasNext()) {
            cxt.addChangeRecord(clazz).cancelCreate((Object)((VmfMO)it.next()));
        }
    }

    public <T extends VmfMO> void unDeployMo(Collection<T> mos, Class<T> clazz, boolean deployDev) throws VMFException {
        if (mos == null || mos.isEmpty()) {
            return;
        }
        Context cxt = new Context(false);
        IMOChangeRecord rcd = cxt.addChangeRecord(clazz);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(cxt);
        rcd.addDelete(mos);
        if (deployDev) {
            VmfMO mo = (VmfMO)mos.iterator().next();
            HashMap<FeatureName, List<Class>> features = new HashMap<FeatureName, List<Class>>();
            features.put(mo.getFeatureName(), Arrays.asList(clazz));
            DeviceAccessorFactory.getDefaultNetconfDeployer((int)mo.getDevID(), (Context)cxt).merge(features);
        }
        dao.merge(clazz, true);
    }
}

