/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.utilty;

import com.huawei.vmf.adapter.common.utilty.FileUtil;
import com.huawei.vmf.adapter.common.utilty.XMLUtil;
import com.huawei.vmf.common.tool.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class XmlParser {
    private static Logger logger = LoggerFactory.getLogger(XmlParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(File file) {
        SAXReader reader = XmlUtil.newSAXReader();
        Document document = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            document = reader.read((InputStream)fis);
        }
        catch (Exception e) {
            logger.error("parse xml file error. filePath=" + file.getPath(), (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.error("Close Stream failed. filePath=" + file.getPath(), (Throwable)e);
            }
        }
        return document;
    }

    public static Document parse(String filePath) {
        return XmlParser.parse(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseTextWithRemoveNS(String xmlContent) {
        if (!StringUtils.hasText((String)xmlContent)) {
            return null;
        }
        String tmpXmlContent = XMLUtil.removeNameSpaces(xmlContent);
        StringReader strReader = null;
        Document doc = null;
        SAXReader reader = XmlUtil.newSAXReader();
        try {
            strReader = new StringReader(tmpXmlContent.trim());
            doc = reader.read((Reader)strReader);
        }
        catch (Exception e) {
            logger.error("parse xml content error. xmlContent=" + xmlContent, (Throwable)e);
        }
        finally {
            if (null != strReader) {
                strReader.close();
            }
        }
        return doc;
    }

    public static Document parseWithRemoveNS(String filePath) {
        return XmlParser.parseTextWithRemoveNS(FileUtil.readFile(new File(filePath)));
    }
}

