/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.common.utilty;

import com.huawei.vmf.common.tool.DateTimeUtil;
import java.util.Calendar;

public class UTCDateFormater {
    public static final String HOUR_MINUTE_FORMAT = "HH:mm";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static String formatCalendar(Calendar calendar, String format) {
        if (calendar == null) {
            return null;
        }
        return DateTimeUtil.getUTCString((Calendar)calendar, (String)format);
    }

    public static long getUTCTimeOffset(String time) {
        if (time == null) {
            return 0L;
        }
        return DateTimeUtil.parse2UTCCalendar((String)time, (String)HOUR_MINUTE_FORMAT).getTimeInMillis();
    }

    public static Calendar getUTCTimeOffset(long offset) {
        Calendar utcCalendar = DateTimeUtil.getUTCCalendar();
        utcCalendar.setTimeInMillis(offset);
        return utcCalendar;
    }

    public static String getUTCDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return DateTimeUtil.getUTCString((Calendar)calendar, (String)DATE_FORMAT);
    }

    public static String getUTCTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return DateTimeUtil.getUTCString((Calendar)calendar, (String)HOUR_MINUTE_FORMAT);
    }

    public static String getUTCDateAndTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return DateTimeUtil.getUTCString((Calendar)calendar, (String)DATE_TIME_FORMAT);
    }

    public static Calendar getUTCCalendar() {
        return DateTimeUtil.getUTCCalendar();
    }

    public static Calendar getUTCCalendar(String date, String time) {
        if (date == null || time == null) {
            String msg = String.format("not allow convert null string to calendar:date=%s,time=%s", date, time);
            throw new IllegalArgumentException(msg);
        }
        return DateTimeUtil.parse2UTCCalendar((String)(date + " " + time), (String)DATE_TIME_FORMAT);
    }

    public static Calendar getUTCCalendar(String time) {
        if (time == null) {
            String msg = "not allow convert null string to calendar:time=null";
            throw new IllegalArgumentException(msg);
        }
        return DateTimeUtil.parse2UTCCalendar((String)time, (String)HOUR_MINUTE_FORMAT);
    }

    public static Calendar getUTCDateTimeCalendar(String datetime) {
        if (datetime == null) {
            String msg = "not allow convert null string to calendar:datetime=null";
            throw new IllegalArgumentException(msg);
        }
        return DateTimeUtil.parse2UTCCalendar((String)datetime, (String)DATE_TIME_FORMAT);
    }
}

